

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetVMClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_SetVMClient')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetVMClient <<<'
	drop procedure QS_SetVMClient
END
IF EXISTS (select * from GxQscripts where name='QS_SetVMClient')
	delete from GxQscripts where name = 'QS_SetVMClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMClient')
	delete from GXDBVersions where aliasname = 'QS_SetVMClient'
GO
print '... Creating Procedure: QS_SetVMClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_SetVMClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @client1 NVARCHAR(256) ='',
  @client2 NVARCHAR(256) ='',	
  @i_localeId INTEGER = 0,
  @o_Msg nvarchar(1024)='' OUTPUT
AS
SET NOCOUNT ON
DECLARE @ErrorCode		INT = 0
DECLARE @ErrorString	varchar(512)
DECLARE @clientId1		int
DECLARE @clientId2		int
DECLARE @sourceClientId		int
DECLARE @destClientId		int
DECLARE @lastError	integer = 0
DECLARE @localErrorMsg	varchar(1024) ='Error Encountered when running script.'
IF(@client1 = '')
BEGIN
	SET @ErrorString	=	'Error: Parameter client1 is empty'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
IF(@client2 = '')
BEGIN
	SET @ErrorString	=	'Error: Parameter client2 is empty'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
select @clientId1 =id from APP_client where name =@client1
IF (@clientId1 =0 OR @clientId1 IS NULL)
BEGIN
	SET @ErrorString	=	'Error: client1 '+ @client1 + 'doesn''t exists'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
select @clientId2 =id from APP_client where name =@client2
IF ( @clientId2 =0 OR @clientId2 IS NULL)
BEGIN
	SET @ErrorString	=	'Error: client2 ' + @client2 + 'doesn''t exists'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
IF ( @clientId2 = @clientId1)
BEGIN
	SET @ErrorString	=	'Error: Same client name is given for both the inputs.'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
DECLARE @indexingV2Client1 int =0
DECLARE @indexingV2Client2 int =0
DECLARE @indexingV2 int =0
if ( exists ( select 1 from app_clientprop where componentNameId = @clientId1 and attrname ='IndexingV2_VSA' and attrval ='1' and modified =0))
	SET @indexingV2Client1 =1
IF ( exists ( select 1 from app_clientprop where componentNameId = @clientId2 and attrname ='IndexingV2_VSA' and attrval ='1' and modified =0))
	SET @indexingV2Client2 =1
if ( exists ( select 1 from App_Application where clientId = @clientId1 and apptypeid !=106 )
     and exists ( select 1 from App_Application where clientId = @clientId2 and apptypeId !=106)
   )
BEGIN
	SET @ErrorString	=	'Error: Both ' + @client1 + ' and ' + @client2 + ' have simpana components, so they can''t be merged'
	SET @ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
if ( exists ( select 1 from App_Application A inner join APP_InstanceProp prop on A.instance = prop.componentNameId
			  and  prop.attrName ='Virtual Server Instance Type' and prop.modified =0
			  where clientId in ( @clientId1, @clientId2) and apptypeid =106
			  and not exists ( select 1 from app_instanceprop where attrname ='Discovered VM Instance'  and attrval ='1' and componentNameId = A.instance ))
   )
BEGIN
       SET @ErrorString     =      'Virtualizaton client can''t be given as input, so they can''t be merged.'
       SET @ErrorCode       =      1
       GOTO SCRIPT_EXIT
END
declare @parentBackupsets1 table ( id int)
declare @parentBackupsets2 table (id int)
if ( @indexingV2Client1 =1 and @indexingV2Client2 =1)
begin
	insert into @parentBackupsets1
	select ParentBackupSetId from APP_VMBackupSet where vmclientid = @clientId1
	insert into @parentBackupsets2
	select ParentBackupSetId from APP_VMBackupSet where vmclientid = @clientId2
	if ( exists ( select id from @parentBackupsets1 intersect select id from @parentBackupsets2) )
	begin
       SET @ErrorString     =      'Both the VMs have common parent backup set, so they can''t be merged.'
       SET @ErrorCode       =      1
       GOTO SCRIPT_EXIT
	end
end
declare @tempname  nvarchar(256)
declare @tempId   int
declare @jobId1   int
declare @jobId2   int
-- checks on client1, client2
declare @sourceClient NVARCHAR(256) =''
declare @destClient   NVARCHAR(256) =''
-- get the latest job id
select @jobId1 = ISNULL(MAX(jobId),0) from APP_VMProp where VMclientId = @clientId1
select @jobId2 = ISNULL(MAX(jobId),0) from APP_VMProp where VMclientId = @clientId2
declare @copyProps  int = 0
-- if client1 has package and client2 doesn't have then client1 will be retained
-- if client1 doesn't have underscore and client2 doesn't have then client2 will be retained
if ( exists ( select 1 from App_Application where clientId = @clientId1 and apptypeid !=106 )
     and not exists ( select 1 from App_Application where clientId = @clientId2 and apptypeId !=106)
   )
begin
   set @destClient = @client1
   set @destClientId = @clientId1
   set @sourceClient = @client2
   set @sourceClientId = @clientId2
   if exists ( select 1 from App_Application where clientId = @clientId1 and apptypeid !=106 )
      PRINT @client1 + ' has an agent installed , so this client will be retained'
   if (@jobId2 >= @jobId1 )
begin
      PRINT 'Client VM Properties will be copied from [' + @sourceClient +'] to [' + @destClient +']'
      set @copyProps =1
end
end
else if (exists ( select 1 from App_Application where clientId = @clientId2 and apptypeid !=106 )
   and not exists ( select 1 from App_Application where clientId = @clientId1 and apptypeid !=106 )
     )
begin
   set @destClient = @client2
   set @destClientId = @clientId2
   set @sourceClient = @client1
   set @sourceClientId = @clientId1
   if exists ( select 1 from App_Application where clientId = @clientId2 and apptypeid !=106 )
      PRINT @client2 + ' has an agent installed , so this client will be retained'
   if (@jobId1 >= @jobId2 )
   begin
      set @copyProps =1
      PRINT 'Client VM Properties will be copied from [' + @sourceClient +'] to [' + @destClient +']'
   end
end
else if ( patindex('%[_][0-9]%',@client1  ) = 0 and patindex('%[_][0-9]%',@client2  ) > 0 )
begin
   set @destClient = @client1
   set @destClientId = @clientId1
   set @sourceClient = @client2
   set @sourceClientId = @clientId2
   PRINT @client1 + ' does not has underscore in the client name , so this client will be retained'
   if (@jobId2 >= @jobId1 )
	begin
		PRINT 'Client VM Properties will be copied from [' + @sourceClient +'] to [' + @destClient +']'
		set @copyProps =1
	end
end
else if ( patindex('%[_][0-9]%',@client2  ) = 0 and patindex('%[_][0-9]%',@client1  ) > 0 )
begin
   set @destClient = @client2
   set @destClientId = @clientId2
   set @sourceClient = @client1
   set @sourceClientId = @clientId1
   PRINT @client2 + ' does not has underscore in the client name, so this client will be retained'
   if (@jobId1 >= @jobId2 )
   begin
      set @copyProps =1
      PRINT 'Client VM Properties will be copied from [' + @sourceClient +'] to [' + @destClient +']'
   end
end
else if ( @jobId1 >= @jobId2 )
begin
   set @destClient = @client1
   set @destClientId = @clientId1
   set @sourceClient = @client2
   set @sourceClientId = @clientId2
end
else
begin
   set @destClient = @client2
   set @destClientId = @clientId2
   set @sourceClient = @client1
   set @sourceClientId = @clientId1
   end
   PRINT 'Source Client  = [' + @sourceClient + '] and Destination Client = [' + @destClient + ']'
IF ( (@sourceClient = @client1 and @indexingV2Client1 =1)
	  or ( @sourceClient = @client2 and @indexingV2Client2 =1) )
BEGIN
	SET @indexingV2 =1
END
DECLARE @vmGUID varchar(64)
DECLARE @vmName nvarchar(256)
DECLARE @vmHostName nvarchar(256)
DECLARE @vmIPAddr nvarchar(256)
DECLARE @vmInstanceUUID nvarchar(256)
declare @lastBackupJobId  nvarchar(256)
SELECT @vmGUID = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Virtual Machine GUID' and modified =0
SELECT @vmIPAddr = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Virtual Machine IP Address' and modified =0
SELECT @vmName = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Virtual Machine Name' and modified =0
SELECT @vmHostName = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Virtual Machine Host Name' and modified =0
SELECT @vmInstanceUUID = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Virtual Machine Instance UUID' and modified =0
SELECT @lastBackupJobId = attrVal from app_clientprop where componentNameId = @sourceClientId and attrName ='Last Backup JobId' and modified =0
declare @propId int
declare @propValue nvarchar(1064)
declare @unixTime int
set @unixTime = dbo.GetUnixTime(GetUTCDate())
set @propId = null
set @propValue = null
BEGIN TRAN
BEGIN TRY
if ( @copyProps = 1 )
begin
select @propId = id from APP_ClientProp where attrName = 'Virtual Server Discovered Clients' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Server Discovered Clients', 2, '1', @unixTime, 0)
end
else if @propValue <> '1'
begin
	--update the current record
	update APP_ClientProp set attrVal = '1' where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Server Discovered Clients' and modified =0
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Name' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Machine Name', 1, @vmName, @unixTime, 0)
end
else if @propValue <> @vmName
begin
	--update the current record
	update APP_ClientProp set attrVal = @vmName, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Machine Name' and modified =0
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine GUID' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Machine GUID', 1, @vmGUID, @unixTime, 0)
end
else if @propValue <> @vmGUID
begin
	--update the current record
	update APP_ClientProp set attrVal = @vmGUID, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Machine GUID' and modified =0
IF ( @vmInstanceUUID is NOT NULL)
BEGIN
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Instance UUID' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Machine Instance UUID', 1, @vmInstanceUUID, @unixTime, 0)
end
else if @propValue <> @vmGUID
begin
	--update the current record
	update APP_ClientProp set attrVal = @vmInstanceUUID, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Machine Instance UUID' and modified =0
END
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Host Name' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Machine Host Name', 1, @vmHostName, @unixTime, 0)
end
else if @propValue <> @vmHostName
begin
	--update the current record
	update APP_ClientProp set attrVal = @vmHostName, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Machine Host Name' and modified =0
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine IP Address' and modified = 0 and componentNameId = @destClientId
if @propId is null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Virtual Machine IP Address', 1, @vmIPAddr, @unixTime, 0)
end
else if @propValue <> @vmIPAddr
begin
	--update the current record
	update APP_ClientProp set attrVal = @vmIPAddr, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Virtual Machine IP Address' and modified =0
set @propId = null
set @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Last Backup JobId' and modified = 0 and componentNameId = @destClientId
if @propId is null and @lastBackupJobId is not null
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'Last Backup JobId', 7, @lastBackupJobId, @unixTime, 0)
end
else if @propValue <> @lastBackupJobId
begin
	--update the current record
	update APP_ClientProp set attrVal = @lastBackupJobId, modified =0 where id = @propId
end
update App_clientprop set modified = @unixTime where componentNameId = @sourceClientId and attrName ='Last Backup JobId' and modified =0
update App_clientprop set attrVal='0' where componentNameId = @destClientId and attrName ='Virtual Machine Deletion Time' and modified =0
PRINT 'Copied all the Virtual Machine properties from [' + @sourceClient + '] to  [' + @destClient + ']'
end
DELETE V1
from APP_VMProp V1
inner join APP_VMProp V2
ON V1.commCellId = V2.commCellId and V1.jobId = V2.jobId
WHERE V1.VMclientId = @sourceClientId and V2.VMclientId = @destClientId
update APP_VMPROP set VMClientId = @destClientId where VMClientId = @sourceClientId
DELETE J1
FROM JMQinetixUpdateStatus J1
inner join JMBkpStats Bkp
on bkp.appType = 106
AND BKP.jobId = J1.jobId
INNER JOIN JMQinetixUpdateStatus J2
ON J1.jobId = J2.jobId
where J1.clientId = @sourceClientId AND J2.clientId = @destClientId
update JMQinetixUpdateStatus set clientId = @destClientId, clientName = @destClient
from JMQinetixUpdateStatus JMQ
where JMQ.clientId = @sourceClientId and exists(select 1 from app_VMProp vmProp where vmProp.jobid=JMQ.jobId )
if ( @indexingV2 = 1 )
BEGIN
update B
set name  = name + '_merged',
	status = ( status & ~8)
from APP_Application A
inner join APP_BackupSetName B
on A.backupSet =B.id
and A.clientId = @sourceClientId
and A.appTypeId =106
update APP_Application set clientId=@destClientId where clientId = @sourceClientId and appTypeId =106
update APP_VMBackupSet
set VMClientId = @destClientId
from APP_VMBackupSet VM
where VMClientId = @sourceClientId
update JMBkpStats
set targetClientId = @destClientId
where targetClientId = @sourceClientId
and appType = 106
--Mark the clients as configured, as v2 vm clients are in configured state by default.
update APP_ClientProp set attrval ='0'
where componentNameId = @destClientId and attrName ='PlatformDeleted 4'
update App_client set status = status & ~6
where id = @destClientId
if not exists ( select 1 from app_idaname where apptypeId =106 and clientId = @destClientId)
begin
update app_idaname
set clientid = @destClientId
where clientId = @sourceClientId
end
if not exists ( select 1 from app_clientprop where  attrName ='IndexingV2_VSA' and componentNameId = @destClientId and attrval='1' and modified=0)
begin
	--insert new property
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		values (@destClientId, 'IndexingV2_VSA', 2, '1', @unixTime, 0)
end
END
PRINT 'Merged all the Virtual Machine jobs from [' + @sourceClient + '] to  [' + @destClient + ']'
SET @o_Msg = (SELECT message FROM EvLocaleMsgs WHERE messageId = (301 | (CAST(POWER(2, 24) AS BIGINT) * 91)) and localeid = @i_localeId)
SET @o_Msg = REPLACE(@o_Msg, '^1%s', @sourceClient)
SET @o_Msg = REPLACE(@o_Msg, '^2%s', @destClient)
SET @o_Msg = REPLACE(@o_Msg, '^3%s', @sourceClient)
IF NOT EXISTS ( SELECT * from simInstalledPackages where ClientId = @sourceClientId)
BEGIN
	IF NOT EXISTS ( SELECT * from APP_Application where ClientId = @sourceClientId)
	BEGIN
		delete APP_ClientGroupAssoc where clientId = @sourceClientId
		delete APP_OpWindowRule where clientId = @sourceClientId
		delete UMSearchstring where clientId = @sourceClientId
		delete APP_Platform where clientId = @sourceClientId
		delete APP_ClientProp where componentNameId = @sourceClientId
		delete APP_ExtendedProperties where clientId = @sourceClientId
		if ( @indexingV2 = 1)
		BEGIN
		delete from APP_IDAProp where componentNameId in(select id from APP_IDAName where clientId=@sourceClientId)
		delete APP_IDAName where clientid = @sourceClientId
		END
		delete APP_Client where id = @sourceClientId
        PRINT ' Deleted the client [' + @sourceClient + ']'
		SET @o_Msg = REPLACE(@o_Msg, '^4%s', 'Deleted')
	END
	ELSE
		SET @o_Msg = REPLACE(@o_Msg, '^4%s', 'Not Deleted')
END
ELSE
	SET @o_Msg = REPLACE(@o_Msg, '^4%s', 'Not Deleted')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError = ERROR_NUMBER()
	SET @localErrorMsg  = ERROR_MESSAGE()
END CATCH
IF @lastError <> 0
BEGIN
	ROLLBACK TRAN
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
ELSE
	COMMIT TRAN
SCRIPT_EXIT:
if @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetVMClient')
	delete from GxQscripts where name = 'QS_SetVMClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMClient')
	delete from GXDBVersions where aliasname = 'QS_SetVMClient'
GO

insert into GXDBVersions values(2, 'QS_SetVMClient',  '00000000000000000000', 'QS_SetVMClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetVMClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_SetVMClient -si ''client name_1'' -si ''client name'''
 + CHAR(10) + '--  -                    '
 + CHAR(10) + '--  -                    '
 + CHAR(10) + '--  -  If both clients have a Commvault agent installed, the command fails. '
 + CHAR(10) + '--  -  If one of the clients has a agent installed, backup history is merged into the client with the agent.'
 + CHAR(10) + '--  -  If one of the clients has a numeric suffix in the client name (such as _1), backup history is merged into the client without the numeric suffix in its name.'
 + CHAR(10) + '--  -  If neither client has a Commvault agent installed or a numeric suffix in the client name, backup history is merged into the client with the latest backup.'
 + CHAR(10) + '--  -  If both clients have a numeric suffix in the client name, and do not have a Commvault agent installed, backup history is merged into the client with the latest backup.'
)
GO

