

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseVSSGlobally.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseVSSGlobally <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseVSSGlobally')
	drop procedure QS_SetUseVSSGlobally
IF EXISTS (select * from GxQscripts where name='QS_SetUseVSSGlobally')
	delete from GxQscripts where name = 'QS_SetUseVSSGlobally'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseVSSGlobally')
	delete from GXDBVersions where aliasname = 'QS_SetUseVSSGlobally'
GO
print '... Creating Procedure: QS_SetUseVSSGlobally'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetUseVSSGlobally
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @ACTION varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @ACTION	varchar(512)
--SET @ACTION = '%s'
-----------------------
-- CONVENIENCE DEFS  --
-----------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setUseVssGlobally'
DECLARE @nowTime    integer
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
DECLARE @created			   integer
SET     @created				= 0
DECLARE @SC_STATUS_BITS        integer
SET		@SC_STATUS_BITS        =  4					-- CV_STATUS_DELETED
DECLARE @USE_VSS_PROPNAME     varchar(50)
SET     @USE_VSS_PROPNAME     ='Use Shadow Copy'			-- GUI says "Use VSS" by checkbox, internally we use "Shadow Copy"
DECLARE @USE_VSS_OPTIONS		varchar(50)
SET		@USE_VSS_OPTIONS		='Use VSS Options'				-- From 10.0, this property is implemented as an enum. Old property will also be saved and the new property will also be used
DECLARE @USE_VSS_ENABLED		varchar(50)
SET		@USE_VSS_ENABLED		='Use VSS Enabled'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
DECLARE @appTypeId              integer
DECLARE @instanceId             integer
DECLARE @backupSetId			integer
DECLARE @subClientId			integer
DECLARE @subClientName			nvarchar(1024)
DECLARE @objectName				nvarchar(4000)
DECLARE @NEWVAL					int
DECLARE @OLDVAL					int
DECLARE @newVSSVal				int
DECLARE @oldVSSVal				int
DECLARE @releaseId				int
DECLARE @ACTION_TAKEN			nvarchar(512)
DECLARE @ERROR_COUNT			int
SET		@ERROR_COUNT			=0
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @ACTION =  'enable'
--SET @ACTION =  'disable'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @ACTION = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
    GOTO   ARGS_ERROR
END
------------------------------------------------
--- CHECK IF A PROPER REQUEST WAS MADE       ---
------------------------------------------------
IF @ACTION <> 'enable' AND @ACTION <> 'disable'                         -- Case Insensitive Check
BEGIN
    SET @localErrorMsg  ='Error. Enable/Disable parameter specified incorrectly as ['+@action +'].'
    SET @lastError = 1
    GOTO   ARGS_ERROR
END
IF @ACTION = 'enable'
BEGIN
	SET @NEWVAL = 1
END
ELSE
BEGIN
	SET @NEWVAL = 0
END
-------------------------------------------------------
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
-------------------------------------------------------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + '].'
--  ===============================================================
--  LOOP FOR ALL THE SUBCLIENTS THAT NEED TO HAVE THE PROPERTY SET
--  ===============================================================
DECLARE SUBC_CURSOR CURSOR FOR
	SELECT id, clientId, appTypeId, instance, backupSet, subClientName from app_application
--		WHERE appTypeId in (11, 33, 34, 42, 43)				-- USE VSS Option Not supported in Win2K!
		WHERE appTypeId in (33, 34, 42, 43)
		  AND (subClientStatus & @SC_STATUS_BITS) = 0
	UNION
	SELECT id, clientId, appTypeId, instance, backupSet, subClientName from app_application
	 WHERE backupSet in( SELECT componentNAmeId
						 FROM app_backupsetProp
							WHERE AttrNAme = 'Associated subclient Policy Ida Type'
							  AND attrVal = 2
							  AND modified = 0 )
	   AND appTypeId = 1030
	   AND (subClientStatus & @SC_STATUS_BITS) = 0
	   ORDER BY clientId, appTypeId, backupset, subClientName
OPEN SUBC_CURSOR
FETCH SUBC_CURSOR INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subClientName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @releaseId = ISNULL((SELECT releaseId FROM APP_Client WHERE id = @clientId),0)
	SET @objectName = '  ['+ CONVERT(char(25), (select name from app_client where id = @clientId))				+ ']['
							   + CONVERT(char(25),(select name from app_idaType where type = @appTypeId))			+ ']['
							   + CONVERT(char(20), (select name from app_backupSetName where id = @backupSetId))	+ ']['
							   + CONVERT(char(20), @subClientName) + ']'
	SET @ACTION_TAKEN		= ''					-- "reset" at the top of ea. loop
	SET @lastError		= 0
	------------------------------------------------------
	-- WANT TO IGNORE THIS SUBCLIENT IF PART OF A SCP	--
	------------------------------------------------------
	IF @appTypeId <> 1030
	   AND EXISTS (SELECT * FROM APP_SubClientProp Where ComponentNameId =@subClientId AND attrName = 'Associated subclient Policy' AND modified = 0)
	BEGIN
			SET @ACTION_TAKEN = ' (Skipping. Part of a SubClient Policy)'
			GOTO REPORT_RESULTS
	END
IF @releaseId < 15
	BEGIN
		SET @OLDVAL = ISNULL((Select CAST(attrVal AS INT) FROM app_subClientProp
							   Where componentNameId = @subClientId AND attrName = @USE_VSS_PROPNAME AND modified = 0)
							   , 0)
	END
	ELSE
	BEGIN
		IF (((SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = @USE_VSS_ENABLED) = '1')
			AND (((SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = @USE_VSS_OPTIONS) = '1')
			OR NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = @USE_VSS_OPTIONS)))
			SET @oldVal = 1				--Use shadow copy is ON
		ELSE
			SET @oldVal = 0				--Use shadow copy is OFF
	END
	------------------------------------------------------
	--	DON'T WANT TO AGE/MODIFY PROPERTY IF VALUE IS	--
	--  ALREADY SET AT CORRECT VALUE					--
	------------------------------------------------------
	IF @OLDVAL = @NEWVAL
	BEGIN
		SET @ACTION_TAKEN=' (already '+@ACTION + 'd)'
		GOTO REPORT_RESULTS
	END
	------------------------------------------------------
	--  PROP NEEDS TO CHANGE AGE EXISTING PROPERTY 1ST	--
	------------------------------------------------------
	BEGIN TRAN
	BEGIN TRY
IF(@releaseId < 15)
			UPDATE APP_SUBCLIENTPROP
			SET  modified = @nowTime
			WHERE componentNameId = @subClientId
			  AND attrName = @USE_VSS_PROPNAME
			  AND modified = 0
		ELSE
		BEGIN
			IF(@ACTION = 'enable')
			BEGIN
				UPDATE APP_SubclientProp
				SET modified = @nowTime
				WHERE componentNameId = @subclientId
					AND	attrName = @USE_VSS_ENABLED
					AND modified = 0
				UPDATE App_Subclientprop
				SET modified = @nowTime
				WHERE componentNameId = @subclientId
					AND attrName = @USE_VSS_OPTIONS
					AND modified = 0
			END
			ELSE
			BEGIN
				UPDATE APP_SubclientProp
				SET modified = @nowTime
					WHERE componentNameId = @subclientId
					AND	attrName = @USE_VSS_ENABLED
					AND modified = 0
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = ERROR_MESSAGE()
		SET @ERROR_COUNT = @ERROR_COUNT +1
		SET @ACTION_TAKEN = @ACTION_TAKEN + @localErrorMsg
		GOTO NEXT_FETCH
	END CATCH
			--	NOW CREATE THE NEW VALUE --
	BEGIN TRY
IF(@releaseId < 15)
		BEGIN
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@subClientId, @USE_VSS_PROPNAME, 2, CAST(@NEWVAL AS NVARCHAR(10)), @nowTIme, 0)
		END
		ELSE
		BEGIN
			IF @action = 'enable'
			BEGIN
				INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_ENABLED, 2, '1', @nowTIme, 0)
				INSERT INTO App_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_OPTIONS, 7, '1', @nowTime, 0)
			END
			ELSE
			BEGIN
				INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_ENABLED, 2, '0', @nowTime, 0)
			END
		END
		SET @ACTION_TAKEN = @ACTION_TAKEN + ' Now ' + @ACTION + 'd.'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = ERROR_MESSAGE()
		SET @ERROR_COUNT = @ERROR_COUNT +1
		SET @ACTION_TAKEN = @ACTION_TAKEN + @localErrorMsg
		GOTO NEXT_FETCH
	END CATCH
	NEXT_FETCH:
    IF (@lastError = 0)
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
REPORT_RESULTS:
	PRINT @objectName+@ACTION_TAKEN
	FETCH SUBC_CURSOR INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subClientName	-- NEXT!
END
CLOSE		SUBC_CURSOR
DEALLOCATE	SUBC_CURSOR
--------------------------------------
-- ALL DONE, REPORT BACK TO CALLER	--
--------------------------------------
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + ']. Errors/Warnings(' +convert(varchar(2), @ERROR_COUNT) + ').'
if @ERROR_COUNT <> 0
BEGIN
	SET @localErrorMsg = 'Script completed with [' + CONVERT(varchar(4), @ERROR_COUNT) + '] errors/warnings. Consult Script log for details'
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
RETURN
--------------------------------------------------------
-- ONLY COME HERE IF HAD PROBLEM WITH INPUT PARAMS	--
--------------------------------------------------------
ARGS_ERROR:
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseVSSGlobally')
	delete from GxQscripts where name = 'QS_SetUseVSSGlobally'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseVSSGlobally')
	delete from GXDBVersions where aliasname = 'QS_SetUseVSSGlobally'
GO

insert into GXDBVersions values(2, 'QS_SetUseVSSGlobally',  '00000000000000000000', 'QS_SetUseVSSGlobally', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseVSSGlobally',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn setUseVSSGlobally.sql -si enable | disable 
'
 + CHAR(10) + '--   script_name : SetUseVSSGlobally'
)
GO

