

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseInstanceGUID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseInstanceGUID <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseInstanceGUID')
	drop procedure QS_SetUseInstanceGUID
IF EXISTS (select * from GxQscripts where name='QS_SetUseInstanceGUID')
	delete from GxQscripts where name = 'QS_SetUseInstanceGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseInstanceGUID')
	delete from GXDBVersions where aliasname = 'QS_SetUseInstanceGUID'
GO
print '... Creating Procedure: QS_SetUseInstanceGUID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetUseInstanceGUID
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- Stored Procedure Inputs
  @clientName nvarchar(MAX)=N'',
  @instanceName nvarchar(MAX)=N'',
  @val NVARCHAR(2) = N''
AS
Set NOCOUNT ON
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetUseInstanceGUID'
-------- Local Variables    -------------
DECLARE @lastError				integer=0
DECLARE @localErrorMsg			varchar(MAX)=N''
-- for test
--SET @val = '1'
-- Local variables
DECLARE @clientId   INT = 0
DECLARE @instanceId INT = 0
-- Validate inputs
IF @clientName = N'' OR @instanceName = N''
BEGIN
    SET @localErrorMsg = N'Client Name or Instance Name  not passed. Please check the usage of the script..'
    SET @lastError = 1
    GOTO    ARGS_ERROR
END
IF (@val <> N'0' AND @val <> N'1')
  BEGIN
      SET @localErrorMsg = N'Property Value can be 0 or 1. Please check the usage of the script.'
      SET @lastError = 1
      GOTO    ARGS_ERROR
  END
IF @clientName = N'ALL' AND @instanceName = N'ALL'
BEGIN
	MERGE APP_InstanceProp P
	USING
	(
				SELECT distinct App.instance
				FROM App_Application App WHERE App.appTypeId = 106
	) AS T ON T.instance = P.componentNameId
	WHEN MATCHED AND P.attrName='Use VM Instance GUID' AND P.modified = 0 THEN
				UPDATE SET attrVal = @val
	WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES (T.instance, 'Use VM Instance GUID', 2, @val, dbo.GetUnixTime(GETDATE()), 0, 0)
				;
END
ELSE
BEGIN
	-- Check client
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName), 0)
	IF @clientId = 0
			BEGIN
					SET @localErrorMsg = 'Cannot find client [' + @clientName + '] in CS DB'
					SET @lastError =1
					GOTO    ARGS_ERROR
			END
	SET @instanceId = ISNULL((SELECT distinct App.instance FROM APP_INSTANCENAME I,App_Application App
	WHERE I.name = @instanceName and App.clientId = @clientId and App.appTypeId = 106 and App.instance=I.id), 0)
	IF @instanceId = 0
			BEGIN
					SET @localErrorMsg = 'Cannot find instance [' + @instanceName + '] in CS DB'
					SET @lastError =1
					GOTO    ARGS_ERROR
			END
	-- Insert/Update
	IF NOT EXISTS (	select * from APP_INSTANCEPROP where componentNameId = @instanceId
									AND attrName = 'Use VM Instance GUID' and modified=0 )
	BEGIN
			INSERT INTO APP_INSTANCEPROP VALUES (@instanceId, 'Use VM Instance GUID', 2, @val, dbo.GetUnixTime(GETDATE()), 0, 0)
	END
	ELSE
			BEGIN
					UPDATE APP_INSTANCEPROP set attrVal = @val  where componentNameId = @instanceId AND attrName = 'Use VM Instance GUID' and modified = 0
			END
END
SET @lastError = @@error
IF @lastError <> 0
BEGIN
SET @localErrorMsg = 'Error: Query Unsucess full'
GOTO ARGS_ERROR
END
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseInstanceGUID')
	delete from GxQscripts where name = 'QS_SetUseInstanceGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseInstanceGUID')
	delete from GXDBVersions where aliasname = 'QS_SetUseInstanceGUID'
GO

insert into GXDBVersions values(2, 'QS_SetUseInstanceGUID',  '00000000000000000000', 'QS_SetUseInstanceGUID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseInstanceGUID',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn SetUseInstanceGUID -si clientname -si instancename -si ''0/1''
'
 + CHAR(10) + '--   script_name : SetUseInstanceGUID'
 + CHAR(10) + '--   Qscript to enable or disable the use of VM Instance UUIDs to identify virtual machines for a virtual server instance or all virtual server instances in a CommCell hierarchy. '
 + CHAR(10) + '--   To enable/disable on an instance:'
 + CHAR(10) + '--   qoperation execscript -sn SetUseInstanceGUID -si "Virtualization Client Name" -si "Instance Name" -si 1/0'
 + CHAR(10) + '--   To enable/disable on all instances:'
 + CHAR(10) + '--   qoperation execscript -sn SetUseInstanceGUID -si "ALL" -si "ALL" -si 1/0'
)
GO

