

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseGlobalFilters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseGlobalFilters <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseGlobalFilters')
	drop procedure QS_SetUseGlobalFilters
IF EXISTS (select * from GxQscripts where name='QS_SetUseGlobalFilters')
	delete from GxQscripts where name = 'QS_SetUseGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseGlobalFilters')
	delete from GXDBVersions where aliasname = 'QS_SetUseGlobalFilters'
GO
print '... Creating Procedure: QS_SetUseGlobalFilters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetUseGlobalFilters
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @NEWSTATE varchar(512) = '%s',
  @CLIENTNAME varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER				 --
-------------------------------------------
--DECLARE @NEWSTATE		varchar(512)
--DECLARE @CLIENTNAME     varchar(1024)
--SET @NEWSTATE   = '%s'
--SET @CLIENTNAME = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetUseGlobalFilters'
DECLARE @created			   integer
SET     @created				= 0
DECLARE @SC_STATUS_BITS        integer
SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @CV_USE_GLOBAL_FILTERS  nvarchar(80)
SET		@CV_USE_GLOBAL_FILTERS  = 'use global filters'
DECLARE @CV_USE_CS_SETTING  nvarchar(80)
SET		@CV_USE_CS_SETTING  = 'use cs setting for global filters'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
DECLARE @appTypeId				integer
DECLARE @instanceId				integer
DECLARE @backupSetId			integer
DECLARE	@subClientId			integer
DECLARE @backupSetName			varchar(1024)
DECLARE @appTypeName			varchar(512)
DECLARE	@subclientName			varchar(1024)
DECLARE @SCdescription			varchar(2048)
DECLARE @currentPropId1 integer
DECLARE @currentPropId2 integer
DECLARE @newUseGF			integer
DECLARE @newUseCSVal			integer
DECLARE @oldUseGF			integer
DECLARE @oldUseCSVal			integer
DECLARE @lastError				integer
DECLARE @OldState				varchar(512)
DECLARE @NewStateName			varchar(128)
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @newState =  'on'
--Set @clientName = 'jewelfish_cn'
--Set @clientName = 'cocoa71'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @newState = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF (@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg	='Error. No Client Name Specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
-- "Normalize" new state to what Props Expect --
------------------------------------------------
IF (@newState = 'on' OR @newState = 'enable')
BEGIN
	SET @newUseGF = 1
	SET @newUseCSVal = 0
	Set @newStateName = 'enabled'
END
ELSE if  (@newState = 'off' OR @newState = 'disable')
BEGIN
	SET @newUseGF = 0
	SET @newUseCSVal = 0
	Set @newStateName = 'disabled'
END
else IF (@newState = 'use cell level policy')
BEGIN
	SET @newUseGF = 0
	SET @newUseCSVal = 1
	Set @newStateName = 'use cell level property'
END
else
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Invalid input : '+@newState
	GOTO ARGS_ERROR
END
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newStateName
         + '], client = ['
         + @clientName
         + '].'
--------------------------------------
-- Figure Out ClientId from name:	--
--------------------------------------
SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
IF @clientId is Null
BEGIN
	SET @localErrorMsg	='No Client with name ['+@ClientName+'] exists.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
-- DO THE WORK (LOOP FOR ALL SUBCLIENTS)!	----
------------------------------------------------
begin tran
DECLARE subClientCursor CURSOR STATIC FOR
  SELECT distinct id, clientId, appTypeId, instance, backupSet, subclientName  from APP_APPLICATION
	WHERE clientId = @clientId
        AND (subClientStatus & @SC_STATUS_BITS) = 0
		AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    WHILE @@FETCH_STATUS = 0
    BEGIN
		Set @appTypeName   = (Select name from APP_IDATYPE			Where type = @appTypeId)
		SET @backupSetName = (Select name from APP_BACKUPSETNAME	Where id = @backupSetId)
		SET @clientName	   = (Select name from APP_CLIENT			Where id = @clientId)				-- Fetching Again in case we ever "wildCard" client selection
		SET @SCdescription = '['+@clientName + '(' + @appTypeName + ')-->'+@backupSetName + '-->' + @subClientName + ']'
--		SEE IF PROPERTY ALREADY EXISTS FOR THIS SUBCLIENT, AND IF IT HAS CHANGED  ---
		SET @currentPropId1 =
			(SELECT id FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_GLOBAL_FILTERS
				AND   modified = 0
			)
		SET @currentPropId2 =
			(SELECT id FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_CS_SETTING
				AND   modified = 0
			)
		Set @oldUseCSVal = ISNULL((select attrVal from APP_SUBCLIENTPROP WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_CS_SETTING
				AND   modified = 0), 1)
		Set @oldUseGF = ISNULL((select attrVal from APP_SUBCLIENTPROP WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_GLOBAL_FILTERS
				AND   modified = 0), 0)
		--select @subClientId, @currentPropId1, @currentPropId2, 'old', @oldUseCSVal, @oldUseGF, 'new', @newUseCSVal, @newUseGF
		IF @oldUseCSVal <> @newUseCSVal OR @oldUseGF <> @newUseGF
		BEGIN
			IF @currentPropId1 IS NOT NULL AND @oldUseGF <> @newUseGF
			BEGIN
				Update APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @subClientId
						AND   attrName = @CV_USE_GLOBAL_FILTERS
						AND   modified = 0
				--select 'updated', @CV_USE_GLOBAL_FILTERS
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @CV_USE_GLOBAL_FILTERS
							+ ' for subClient '
							+ @SCdescription
							+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR					--- FOR NOW, DEBUGGING! !@#!
			END
			IF @currentPropId2 IS NOT NULL AND @oldUseCSVal <> @newUseCSVal
			BEGIN
				Update APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @subClientId
						AND   attrName = @CV_USE_CS_SETTING
						AND   modified = 0
						--select 'updated', @CV_USE_CS_SETTING
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @CV_USE_GLOBAL_FILTERS
							+ ' for subClient '
							+ @SCdescription
							+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR					--- FOR NOW, DEBUGGING! !@#!
			END
			IF @oldUseCSVal <> @newUseCSVal
			BEGIN
				--select 'inserting', @CV_USE_CS_SETTING, @newUseCSVal
				IF @newUseCSVal = '1'
					INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
							VALUES (@subclientId, @CV_USE_CS_SETTING, 2, '1', @nowTime, 0)
				ELSE INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
							VALUES (@subclientId, @CV_USE_CS_SETTING, 2, '0', @nowTime, 0)
			END
			IF @oldUseGF <> @newUseGF
			BEGIN
				--select 'inserting', @CV_USE_GLOBAL_FILTERS, @newUseCSVal
				IF @newUseGF = '1'
					INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@subclientId, @CV_USE_GLOBAL_FILTERS, 2, '1', @nowTime, 0)
				ELSE INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@subclientId, @CV_USE_GLOBAL_FILTERS, 2, '0', @nowTime, 0)
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
					SET @localErrorMsg	= '    Error[' +convert(varchar(12), @lastError)
								+'] when attempting addition of property ['
								+ @CV_USE_GLOBAL_FILTERS
								+ ' for subClient '
								+ @SCdescription
								+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR
			END
			PRINT '   Property ['+@CV_USE_GLOBAL_FILTERS + '] is now ' + @newStateName + ' for ' +@SCdescription + '.'
		END
		ELSE
		BEGIN
			PRINT '    State for ' + @SCdescription + ' has not changed. Property is still ' +@newStateName + '.'
			FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
			CONTINUE
		END
    FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    END
TRAN_ERROR:
    CLOSE       subClientCursor
    DEALLOCATE  subClientCursor
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newStateName
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseGlobalFilters')
	delete from GxQscripts where name = 'QS_SetUseGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseGlobalFilters')
	delete from GXDBVersions where aliasname = 'QS_SetUseGlobalFilters'
GO

insert into GXDBVersions values(2, 'QS_SetUseGlobalFilters',  '00000000000000000000', 'QS_SetUseGlobalFilters', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseGlobalFilters',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f SetUseGlobalFilters -i enable|disable  -i clientName
'
 + CHAR(10) + '--   script_name : SetUseGlobalFilters'
)
GO

