

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSubclientPrePostProcess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetSubClientPrePostProcess')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetSubClientPrePostProcess <<<'
	drop procedure QS_SetSubClientPrePostProcess
END
IF EXISTS (select * from GxQscripts where name='QS_SetSubClientPrePostProcess')
	delete from GxQscripts where name = 'QS_SetSubClientPrePostProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientPrePostProcess')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientPrePostProcess'
GO
print '... Creating Procedure: QS_SetSubClientPrePostProcess'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSubClientPrePostProcess
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SubclientId nvarchar(10) = '%s',
  @AllScripts nvarchar(3999)  = '%s',
  @isLocalAccount nvarchar(10) = '%s',
  @UserName nvarchar(50) = '%s',
  @EncryptedPasswrd nvarchar(512) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @SubClientId NVARCHAR(10)
--SET @SubClientId = '%s'
--DECLARE @AllScripts NVARCHAR(3999)
--SET @AllScripts  = '%s'
--DECLARE @isLocalAccount NVARCHAR(10)
--SET @isLocalAccount = '%s'
--DECLARE @UserName NVARCHAR(50)
--SET @UserName = '%s'
--DECLARE @EncryptedPasswrd NVARCHAR(512)
--SET @EncryptedPasswrd = '%s'
------------------command line input format------------
-- 4 PreScan=E:\Batch\PreScan.bat,PostScan=E:\Batch\PostScan.bat,PreBackup=E:\Batch\PreBackup.bat,PostBackup=E:\Batch\PostBackup.bat YES/NO username encrytedPassword
------------------input prefixes----------------------
DECLARE @PrelfindPrefix NVARCHAR(50)
SET @PrelfindPrefix = 'PreScan='
DECLARE @PostlfindPrefix NVARCHAR(50)
SET @PostlfindPrefix = 'PostScan='
DECLARE @PreBackupPrefix NVARCHAR(50)
SET @PreBackupPrefix = 'PreBackup='
DECLARE @PostBackupPrefix NVARCHAR(50)
SET @PostBackupPrefix = 'PostBackup='
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetSubClientPrePostProcess'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @cPrelfindPrefix NVARCHAR(50)
SET @cPrelfindPrefix = 'sys:pre PreIfind'
DECLARE @cPostlfindPrefix NVARCHAR(50)
SET @cPostlfindPrefix = 'sys:post PostIfind'
DECLARE @cPreBackupPrefix NVARCHAR(50)
SET @cPreBackupPrefix = 'sys:pre PreBackup'
DECLARE @cPostBackupPrefix NVARCHAR(50)
SET @cPostBackupPrefix = 'sys:post PostBackup'
DECLARE @cUsePrePostUser  NVARCHAR(50)
SET @cUsePrePostUser = 'use prepost username'
DECLARE @cPrePostUser  NVARCHAR(50)
SET @cPrePostUser = 'prepost username'
DECLARE @cPrePostPassword  NVARCHAR(50)
SET @cPrePostPassword = 'prepost password'
DECLARE @end NVARCHAR(2)
SET @end = ','
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
BEGIN TRAN
IF @SubClientId = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No SubClient Id was given.'
	GOTO ARGS_ERROR
END
BEGIN TRY
IF NOT EXISTS(select *from APP_Application where id = @SubClientId)
BEGIN
	SET @errorString = 'Error.  Invalid SubClient Id.'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
DECLARE @AttrName NVARCHAR(50)
SET @AttrName = ''
DECLARE @AttrType int
SET @AttrType = 1
DECLARE @AttrVal NVARCHAR(256)
SET @AttrVal = ''
IF(@AllScripts  = @noParameter)
BEGIN
	SET @errorString = 'Error. Pre Scan and Post Backup Path not given.'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
IF @isLocalAccount <> @noParameter
BEGIN
	SET @isLocalAccount = UPPER(RTRIM(LTRIM(@isLocalAccount)))
END
IF ((@isLocalAccount = 'NO') AND (@UserName = @noParameter OR @EncryptedPasswrd = @noParameter))
BEGIN
	SET @errorString = 'Error. User name or Password not given'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
DECLARE @Iterator int
SET @Iterator = 0
DECLARE @WatchFlag int
SET @WatchFlag = 0
DECLARE @startIndex int
DECLARE @endIndex int
DECLARE @Path NVARCHAR(2000)
DECLARE @PathLen int
DECLARE @Prefix NVARCHAR(50)
DECLARE @cPrefix NVARCHAR(50)
While @Iterator < 4
BEGIN
	IF @Iterator = 0
	BEGIN
		SET @Prefix  = @PrelfindPrefix
		SET @cPrefix = @cPrelfindPrefix
	END
	ELSE IF @Iterator = 1
	BEGIN
		SET @Prefix  = @PostlfindPrefix
		SET @cPrefix = @cPostlfindPrefix
	END
	ELSE IF @Iterator = 2
	BEGIN
		SET @Prefix  = @PreBackupPrefix
		SET @cPrefix = @cPreBackupPrefix
	END
	ELSE IF @Iterator = 3
	BEGIN
		SET @Prefix  = @PostBackupPrefix
		SET @cPrefix = @cPostBackupPrefix
	END
	SET @startIndex = 0
	SET @endIndex = 0
	SET @PathLen = 0
	SET @Path = ''
	SET @startIndex = CHARINDEX(@Prefix,@AllScripts ,0)
	IF @startIndex <> 0
	BEGIN
		SET @endIndex = CHARINDEX(@end,@AllScripts ,@startIndex)
		IF @endIndex = 0
		BEGIN
			SET @endIndex = LEN(@AllScripts)+1
		END
		SET @startIndex = @startIndex + LEN(@Prefix)
		SET @PathLen = @endIndex - @startIndex
		BEGIN TRY
			SET @Path = LTRIM(RTRIM(SUBSTRING(@AllScripts ,@startIndex,@PathLen)))
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @Path = ''
			SET @startIndex = 0
		END CATCH
	END
	IF @startIndex <> 0 and @Path <> ''
	BEGIN
		SET @WatchFlag = 1
		SET @AttrName = @cPrefix
		IF EXISTS(select * from APP_SubClientProp where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName)
			BEGIN
				update APP_SubClientProp set modified = @nowTime where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName and modified = 0
				insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@Path,@nowTime,0)
			END
		ELSE
			BEGIN
				insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@Path,@nowTime,0)
		END
		SET @errorCode = @@ERROR
		IF @errorCode = 0
		BEGIN
			PRINT @scriptName + ' Parameters '+ @Prefix +@Path + ' update success.'
		END
		ELSE
		BEGIN
			SET @errorString = ' Parameters '+ @Prefix +@Path + ' update failed.'
			goto	ARGS_ERROR
		END
	END
	SET @Iterator = @Iterator + 1
END
IF  @WatchFlag = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = ' Parameter [AllScripts: '+ @AllScripts + '] wrong syntax given.'
		goto	ARGS_ERROR
	END
IF (NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = @SubClientId AND attrType = 7 AND attrName = @cUsePrePostUser AND modified = 0) )AND @isLocalAccount = @noParameter
BEGIN
	SET @isLocalAccount = 'YES'
END
SET @Iterator = (SELECT CASE (@isLocalAccount) WHEN('NO') THEN 0 ELSE (CASE (@isLocalAccount) WHEN('YES') THEN 1  ELSE 4 END) END)
WHILE @Iterator < 3
BEGIN
	IF @Iterator = 0
	BEGIN
		SET @attrType = 1
		SET @AttrName =  @cPrePostUser
		SET @AttrVal =  @UserName
	END
	IF @Iterator = 1
	BEGIN
		SET @attrType = 1
		SET @AttrName =  @cPrePostPassword
		SET @AttrVal = 	(SELECT CASE (@isLocalAccount) WHEN('YES') THEN CAST(2 AS VARCHAR) ELSE @EncryptedPasswrd END)
	END
	IF @Iterator = 2
	BEGIN
		SET @attrType = 7
		SET @AttrName =  @cUsePrePostUser
		SET @AttrVal = 	(SELECT CASE (@isLocalAccount) WHEN('YES') THEN CAST(1 AS VARCHAR) ELSE CAST(2 AS VARCHAR)  END)
	END
	--SET @CCPId = (select ccpId from APP_Application where id = @SubClientId)
	IF NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = @SubClientId AND attrType = @attrType AND attrName = @AttrName AND modified = 0)
		BEGIN
			insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@AttrVal,@nowTime,0)
		END
	ELSE
		BEGIN
			update APP_SubClientProp set modified = @nowTime where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName and modified = 0
			insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@AttrVal,@nowTime,0)
		END
	SET @errorCode = @@ERROR
	IF @errorCode<> 0
	BEGIN
		SET @errorString = 'Insertion/Updation of User Name Info failed'
		goto ARGS_ERROR
	END
	SET @Iterator = @Iterator + 1
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
IF @Iterator = 4
BEGIN
	print 'Info: no Accout Type Information given isLocalAccount(YES/NO)'
END
print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+ ' with Parameters:[ Subclient Id='
										+@SubClientId+' AllScripts=' + @AllScripts+'].'
ARGS_ERROR:
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSubclientPrePostProcess')
	delete from GxQscripts where name = 'QS_SetSubclientPrePostProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubclientPrePostProcess')
	delete from GXDBVersions where aliasname = 'QS_SetSubclientPrePostProcess'
GO

insert into GXDBVersions values(2, 'QS_SetSubclientPrePostProcess',  '00000000000000000000', 'QS_SetSubclientPrePostProcess', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSubclientPrePostProcess',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSubClientPrePostProcess.sql -si subclientid -si ScriptsPaths -si isLocalAccount -si username -si encryptedPassword
'
 + CHAR(10) + '--   script_name : SetSubClientPrePostProcess'
)
GO

