

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSubClientProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetSubClientProperty.sp,v $ $Id: QS_SetSubClientProperty.sp,v 1.4.60.2 2018/03/22 01:33:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSubClientProperty <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSubClientProperty')
	drop procedure QS_SetSubClientProperty
IF EXISTS (select * from GxQscripts where name='QS_SetSubClientProperty')
	delete from GxQscripts where name = 'QS_SetSubClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientProperty')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientProperty'
GO
print '... Creating Procedure: QS_SetSubClientProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSubClientProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = '',
  @PARAM4 varchar(1024) = '',
  @PARAM5 varchar(1024) = '',
  @PARAM6 varchar(1024) = '',
  @PARAM7 varchar(1024) = '',
  @PARAM8 INT = 7
AS
Set NOCOUNT ON
DECLARE @clientName varchar(1024)
DECLARE @dataAgentName varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @bkpsetName varchar(1024)
DECLARE @subclientName varchar(1024)
DECLARE @propName varchar(1024)
DECLARE @propType int
DECLARE @propvalue varchar(max)
DECLARE @scriptName nvarchar(128)
SET @clientName = @PARAM1
SET @dataAgentName = @PARAM2
SET @instanceName = @PARAM3
SET @bkpsetName = @PARAM4
SET @subclientName = @PARAM5
SET @propName =  @PARAM6
SET @propvalue =  @PARAM7
SET @propType =  @PARAM8
SET @scriptName = 'SetSubClientProperty'
DECLARE @lastError integer
SET @lastError = 0
DECLARE @localErrorMsg nvarchar(1024)
SET @localErrorMsg = ''
DECLARE @noParameter varchar(4)
SET     @noParameter            ='%'
SET     @noParameter            =@noParameter + 's'
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ERROR_EXIT
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @clientName, @dataAgentName, @instanceName, @bkpsetName, @subclientName,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ERROR_EXIT
END
BEGIN TRAN
BEGIN TRY
update APP_SubClientProp
set modified = dbo.getunixtime(GETUTCDATE())
where attrName = @propName
and componentNameId = @subclientId
and modified = 0
if @@error = 0 --and @@ROWCOUNT = 0
BEGIN
	insert into APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				 values (@subclientId, @propName, @propType, @propvalue, dbo.getunixtime(GETUTCDATE()), 0)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN
	SET @lastError = ERROR_NUMBER()
        SET @localErrorMsg = 'Problems updating SubClient properties ' +ERROR_MESSAGE()
 	GOTO ERROR_EXIT
END
END CATCH
if @lastError = 0
	COMMIT TRAN
	ERROR_EXIT:
     	-- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+ Convert(varchar(2),@lastError) +').'
if @lastError <> 0
     	Raiserror(@localErrorMsg,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
     				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSubClientProperty')
	delete from GxQscripts where name = 'QS_SetSubClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientProperty')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientProperty'
GO

insert into GXDBVersions values(2, 'QS_SetSubClientProperty',  '00010004006000020000', 'QS_SetSubClientProperty', '00010004006000020000')
GO

insert into GxQscripts values(2,'QS_SetSubClientProperty',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSubClientProperty.sql -si ''c=clientname''  -si ''a=Q_UNIX_DB2''  -si  ''i=instancename'' -si ''b=backupsetname'' -si ''s=subclientname'' -si subclientprop  -si subclientpropvalue
'
 + CHAR(10) + '-- 	script_name: SetSubcClientProperty.'
 + CHAR(10) + '-- 	Sets specified subclient property to given value under the given client, application type, instance, backupset and subclient.'
)
GO

