

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSubClientPolicyForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSubClientPolicyForClient <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSubClientPolicyForClient')
	drop procedure QS_SetSubClientPolicyForClient
IF EXISTS (select * from GxQscripts where name='QS_SetSubClientPolicyForClient')
	delete from GxQscripts where name = 'QS_SetSubClientPolicyForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientPolicyForClient')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientPolicyForClient'
GO
print '... Creating Procedure: QS_SetSubClientPolicyForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSubClientPolicyForClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @subclientPolicyName nvarchar(1024),
  @clientName nvarchar(1024),
  @backupSetName nvarchar(1024) = ''
AS
Set NOCOUNT ON
------------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'SetSubClientPolicyForClient'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError	integer = 0
DECLARE @localErrorMsg	varchar(1024) ='Error Encountered when running script.'
----------- Validate inputs   -------------
	if @subclientPolicyName = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Subclient Policy name was not supplied as an input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @clientName = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Client name was not supplied as an input.'
		Set @lastError = 2
		goto   ARGS_ERROR
	END
--------- Check if ids exists ---------------
DECLARE @scpId integer = (select id from APP_BackupSetName B where B.name = @subclientPolicyName AND B.status&128=128)
DECLARE @clientId integer = (select id from APP_Client C where C.name = @clientName)
DECLARE @timeStamp integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @backupsetId integer
DECLARE @scPolicyType integer
DECLARE	@simType VARCHAR(1024)
DECLARE	@idaType VARCHAR(1024)
DECLARE	@scpName VARCHAR(1024)
	if @scpId IS NULL OR @scpId = 0
	BEGIN
		SET @localErrorMsg = 'Error.  Subclient Policy ['+ @subclientPolicyName + '] does not exist.'
		Set @lastError = 3
		goto   ARGS_ERROR
	END
	if @clientId IS NULL OR  @clientId = 0
	BEGIN
		SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
		Set @lastError = 4
		goto   ARGS_ERROR
	END
	SET @scPolicyType = (SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = @scpId AND attrName='Associated subclient Policy Ida Type')
	SET @simType = (SELECT Type FROM simOperatingSystem WHERE id in (
						SELECT simOperatingSystemId FROM APP_Client WHERE id = @clientId
						)
					)
	SET @idaType = (SELECT CASE
						WHEN @scPolicyType=1 or @scPolicyType=2 THEN 'Windows'
						WHEN @scPolicyType=3 THEN 'Unix'
						WHEN @scPolicyType=4 THEN 'Netware'
					END
					)
	if @idaType <> @simType
	BEGIN
		SET @localErrorMsg = 'Error.  Subclient Policy IDA type ['+ @idaType + '] does not match client IDA type ['+ @simType + '].'
		Set @lastError = 5
		goto   ARGS_ERROR
	END
	IF @backupSetName <> @NoParameter AND @backupSetName <> ''
	BEGIN
		SET @backupsetId = (SELECT id FROM APP_BackupSetName B WHERE B.name = @backupSetName AND id in (
			SELECT backupSet FROM APP_Application WHERE clientId = @clientId
			)
		)
		if @backupsetId IS NULL OR  @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Backupset ['+ @backupSetName + '] for client ['+ @clientName + '] does not exist.'
			Set @lastError = 6
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SELECT @backupsetId=id, @backupSetName=name FROM APP_BackupSetName B WHERE B.status&8=8 AND id in (
			SELECT backupSet FROM APP_Application WHERE clientId = @clientId AND appTypeId in (
				SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)		--APPGRP_FileSystemIDA
				)
			)
	END
	if EXISTS(SELECT 1 FROM APP_BackupSetProp WHERE componentNameId = @backupsetId AND attrName='Associated subclient Policy' and modified=0)
	BEGIN
		SET @scpName = (SELECT name FROM APP_BackupSetName WHERE id in (
			SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = @backupsetId AND attrName='Associated subclient Policy' and modified=0)
		)
		SET @localErrorMsg = 'Error.  Backupset ['+ @backupSetName + '] has already been associated to Subclient policy ['+ @scpName + '].'
		Set @lastError = 5
		goto   ARGS_ERROR
	END
	if EXISTS (SELECT 1 FROM APP_Application WHERE backupSet=@backupsetId AND subclientStatus = 0)
	BEGIN
		SET @localErrorMsg = 'Error.  Cannot associate backupset ['+ @backupSetName + '] to Subclient policy because it contains user-defined subclients '
		Set @lastError = 5
		goto   ARGS_ERROR
	END
	declare @appId integer
	declare @appClientId integer
	declare @appAppTypeId integer
	declare @appinstanceId integer
	declare @appbackupsetId integer
	declare @appappNumberId integer
	declare @appdArchId integer
	declare @applArchId integer
	declare @apprefTime integer
	declare @appmodifiedTime integer
	declare @appscStatus integer
	declare @compress integer
	declare @nwAgents integer
	declare @newSCId  integer
	declare @newAppTypeId  integer
	declare @newClientId  integer
	declare @newInstanceId  integer
	declare @NWWriteSpeed  integer
	declare @appscName nvarchar(128)
BEGIN TRAN
	BEGIN TRY
		-- Set the initial values
		Select @newClientId = clientId, @newAppTypeId = appTypeId , @newInstanceId = instance
			from APP_Application where backupset = @backupsetId
		DECLARE	GetSubclientsCursor CURSOR FOR
		SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus
			FROM APP_Application where backupset = @scpId
		OPEN GetSubclientsCursor
		FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			set @newSCId = 0
			--if it is default subclient, update will take place.
			IF ((@appscStatus & 8) = 8)
			BEGIN
				Select @newSCId = id  from APP_Application where backupset = @backupsetId AND ((subclientStatus & 8) = 8)
				--MR 146895: Do not change last backuptime
				--If there is change in the dataarchiveID or logarchiveId, then we need to change the last backup time and set the reason for clearinig the backup time
				--MR: 163985: Now bring back the code, it is enabled on key bEnablePopUpMessageDuringStoragePolicyChange
				IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnablePopUpMessageDuringStoragePolicyChange' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
				BEGIN
					IF ((Select dataArchGrpID from APP_Application where id = @newSCId) <> @appdArchId)
					BEGIN
						update APP_SubClientProp set attrVal = N'0'	where attrName IN('sys:last full','sys:last incr') and modified = 0 and componentNameId = @newSCId
						IF (EXISTS (select * from app_subclientprop where attrName LIKE N'Reason last backup time cleared' and modified = 0 and componentNameId = @newSCId))
						BEGIN
							update APP_SubClientProp set attrVal = N'9'	where attrName LIKE 'Reason last backup time cleared' and modified = 0 and componentNameId = @newSCId
						END
						ELSE
						BEGIN
							insert into APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified)
								values(@newSCId, N'Reason last backup time cleared', 7, 9, @timeStamp , 0)
						END
					END
				END
update APP_Application set dataArchGrpID = @appdArchId,  logArchGrpID = @applArchId, subclientName = @appscName , subclientStatus = (subclientStatus & 0x0100) | @appscStatus WHERE
				id = @newSCId
			END
			--if it is system state subclient, update will take place.
			ELSE IF (EXISTS (select * from APP_SubClientProp where componentnameId = @appId and modified = 0 and attrName = 'System State Subclient'))
			BEGIN
				Select @newSCId = id  from APP_Application where backupset = @backupsetId AND EXISTS (select * from APP_SubClientProp where componentnameId = APP_Application.id and modified = 0 and attrName = 'System State Subclient')
				if (@newSCId  <> 0)
				BEGIN
					--MR 146895: Do not change last backuptime
					--If there is change in the dataarchiveID or logarchiveId, then we need to change the last backup time and set the reason for clearinig the backup time
					--MR: 163985: Now bring back the code, it is enabled on key bEnablePopUpMessageDuringStoragePolicyChange
					IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnablePopUpMessageDuringStoragePolicyChange' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
					BEGIN
						IF ((Select dataArchGrpID from APP_Application where id = @newSCId) <> @appdArchId)
						BEGIN
							update APP_SubClientProp set attrVal = N'0'	where attrName IN('sys:last full','sys:last incr') and modified = 0 and componentNameId = @newSCId
							IF (EXISTS (select * from app_subclientprop where attrName LIKE N'Reason last backup time cleared' and modified = 0 and componentNameId = @newSCId ))
							BEGIN
								update APP_SubClientProp set attrVal = N'9'	where attrName LIKE 'Reason last backup time cleared' and modified = 0 and componentNameId = @newSCId
							END
							ELSE
							BEGIN
								insert into APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified)
									values(@newSCId, N'Reason last backup time cleared', 7, 9 , @timeStamp , 0)
							END
						END
					END
update APP_Application set dataArchGrpID = @appdArchId,  logArchGrpID = @applArchId, subclientName = @appscName, subclientStatus = (subclientStatus & 0x0100) | @appscStatus WHERE
					id = @newSCId
				END
				ELSE
					--Create System State subclient
					insert into APP_Application (clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,
							logArchGrpID,refTime,modified,subclientName,subclientStatus, origCCId, GUID)
						values(@newClientId, @newAppTypeId ,@newInstanceId, @backupsetId, @appappNumberId, @appdArchId,
										@applArchId, @timeStamp,   @timeStamp, @appscName, @appscStatus, 2, newid())
			END
			ELSE
			BEGIN
				insert into APP_Application (clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,
					logArchGrpID,refTime,modified,subclientName,subclientStatus, origCCId, GUID)
				values(@newClientId, @newAppTypeId ,@newInstanceId, @backupsetId, @appappNumberId, @appdArchId,
									@applArchId, @timeStamp,   @timeStamp, @appscName, @appscStatus, 2, newid())
			END
			Select @newSCId = id  from APP_Application where backupset = @backupsetId and subclientName = @appscName
			--Delete the already defined content and filter of the SC
			Update APP_ScFilterFile set modified = @timeStamp where componentNameId = @newSCId AND modified = 0
			--Delete the already defined overlapped properties
			Update APP_SubClientProp set modified = @timeStamp where componentNameId = @newSCId AND modified = 0 AND attrName in (Select attrName from APP_SubClientProp where componentnameId = @appId AND modified = 0)
			Delete archpipeconfig where appNumber = @newSCId
			--Insert the association id
			Insert into APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified)
				values(@newSCId, N'Associated subclient Policy' , 10 , @appId, @timeStamp , 0)
			--Insert the sw comp and NW agent in archpipeconfig table
			Select @compress = compressWhere, @nwAgents = numNWAgents, @NWWriteSpeed = NWWriteSpeed  from archpipeconfig where appNumber = @appId
			IF (@@ROWCOUNT <> 0)
			BEGIN
				insert into archpipeconfig values( @newSCId, @compress, @nwAgents, @NWWriteSpeed)
			END
			FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		END
		--Insert the association id for backupset
		Insert into APP_BackupSetProp (componentNameId,attrName,attrType,attrVal,created,modified)
			values(@backupsetId, N'Associated subclient Policy' , 7 , @scpId, @timeStamp, 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError = ERROR_NUMBER()
	SET @localErrorMsg  = ERROR_MESSAGE()
END CATCH
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
	CLOSE GetSubclientsCursor
	DEALLOCATE GetSubclientsCursor
ARGS_ERROR:
	Print ''
	PRINT @scriptName + ' completed at ' + Convert(varchar(60), getdate()) + ' subclient policy name = [' + @subclientPolicyName +
		'] client name = [' + @clientName + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSubClientPolicyForClient')
	delete from GxQscripts where name = 'QS_SetSubClientPolicyForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientPolicyForClient')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientPolicyForClient'
GO

insert into GXDBVersions values(2, 'QS_SetSubClientPolicyForClient',  '00000000000000000000', 'QS_SetSubClientPolicyForClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSubClientPolicyForClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Set subclient policy for client.
'
 + CHAR(10) + '-- 	script_name: SetSubClientPolicyForClient'
 + CHAR(10) + '-- 	qoperation execscript -sn SetSubClientPolicyForClient -si subclientPolicyName -si clientName -si <backupsetName>'
)
GO

