

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetStoragePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_SetStoragePolicy')
	drop procedure QS_SetStoragePolicy
IF EXISTS (select * from GxQscripts where name='QS_SetStoragePolicy')
	delete from GxQscripts where name = 'QS_SetStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicy'
GO
print '... Creating Procedure: QS_SetStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetStoragePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SpName varchar(1024) = '%s',
  @OPT varchar(1024) = '%s',
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @SpName	varchar(1024)
--SET		@SpName	= '%s'
--DECLARE @OPT	varchar(1024)
--SET		@OPT	= '%s'
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@SpName	= 'maglib(navia)_(1)'
--SET		@OPT	= 'all'
--SET		@PARAM1 = 'c=linuxsan5'
--SET		@PARAM2	= 'a=Q_unix_DB2'
--SET		@PARAM3 = 'i=db2inst1'
--SET		@PARAM4 = 'b=SAMPLE'
--SET		@PARAM5 = 's=default'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetStoragePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @logOption		varchar(10)
SET		@logOption		='log'
DECLARE @dataOption		varchar(10)
SET		@dataOption		='data'
DECLARE @allOption		varchar(10)
SET		@allOption		='all'
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------Validata storage policy name  -----------
IF @SpName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. No input was given. Please refer to readme_'+@scriptName+'.txt for usage.'
	GOTO ARGS_ERROR
END
DECLARE @spId integer
SET @spId = ISNULL((Select id from ArchGroup where name like @SpName), 0)
IF @spId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Storage Policy by name [' +@SpName +'] not found.'
	GOTO ARGS_ERROR
END
-------------------data or log?------------------
DECLARE @option integer
SET @option  = (case @OPT WHEN @dataOption THEN 1
WHEN @logOption THEN 2
WHEN @allOption THEN 3
ELSE 0  ---- option is mandatory for this script.
END)
IF @option = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Parameter 2 must be log/data/all. '
	GOTO ARGS_ERROR
END
------------ Get ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
IF  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
	@localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
DECLARE @cmdLineSC integer
SET @cmdLineSC = ((SELECT subclientStatus from APP_application Where id = @subclientId) & 64 )
----------------collect old ids for validation ------------------------------
DECLARE @dataArchGrpId integer
DECLARE @logArchGrpId integer
SELECT @logArchGrpId = logArchGrpId, @dataArchGrpId =dataArchGrpId
FROM App_application
where id = @subclientId
declare @SetAtSubclient integer
declare @SetAtBackupset integer
IF (@option & 2 = 2 )
BEGIN
	SET @SetAtSubclient = 0
	SET @SetAtBackupset = 0
	-- db apptypes: oracle, oracle rac, sql, db2, sybase, informix, mysql
	IF @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Cannot set log storage policy for subclient. Unsupported iDA.'
		GOTO ARGS_ERROR
	END
	-- sql - log Sp is exposed at subclient.
	IF (@apptypeId in (81))
		SET @SetAtSubclient = 1
	-- db2 at backupset level
	IF (@apptypeId in (37, 62))
		SET @SetAtBackupset = 1
	-- all command line subclients shouldn't affect instance properties DEFECT 27481
	IF @cmdLineSC > 0
		SET @SetAtSubclient = 1
END
------------Job running?-------------------------
IF (select count(*) from JMBkpJobInfo where applicationId = @subclientId) >0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Cannot change Storage policy. Job running for this subclient.'
	GOTO ARGS_ERROR
END
------------ Set storage policy   -----------
BEGIN TRAN
--1) DATA SP
	IF @option & 1 = 1 AND @dataArchGrpId != @spId
	BEGIN
		--if data sp is set for non DB apptypes reset both log and data sp to the same value.
		--otherwise subclient will be duplicated in storagepolixy properties -> associated subclients of both subclients
		IF (@option & 2 <> 2 )and @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
			Update App_application set dataArchGrpId = @spId, logArchGrpId = @spId where id = @subclientId
		ELSE
			Update App_application set dataArchGrpId = @spId where id = @subclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not change storage policy.'
			GOTO TRANS_EXIT
		END
		----------------reset backup times if  sp changed -------------------------
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'last data SP' and componentnameid = @SubclientId
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'last data SP', @dataArchGrpId, 7, @nowTime, 0)
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last full' and componentnameid = @SubclientId
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last incr' and componentnameid = @SubclientId
		IF  ( SELECT attrval FROM App_subclientprop
		where attrname like 'Reason last backup time cleared'
		 and componentnameid = @SubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
		BEGIN
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
			--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
		END
		-- Reset backupset modified time
		UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
	END
--2) LOG SP
	IF @option & 2 = 2 AND @logArchGrpId != @spId
	BEGIN
		--LOG SP EXPOSED AT SUBCLIENT LEVEL
		IF	 @SetAtSubclient = 1 --SQL
		BEGIN
			Update App_application set logArchGrpId = @spId where id = @subclientId
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg = 'Error. Could not change log storage policy.'
				GOTO TRANS_EXIT
			END
			----------------reset backup times if  sp changed -------------------------
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'last log SP' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'last log SP', @dataArchGrpId, 7, @nowTime, 0)
			IF  ( SELECT attrval FROM App_subclientprop
			where attrname like 'Reason last backup time cleared'
			 and componentnameid = @SubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
			BEGIN
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
				--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
			END
			-- Reset backupset modified time
			UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
		END
		ELSE IF @SetAtBackupset = 1--LOG SP EXPOSED AT BACKUPSET LEVEL
		BEGIN
			declare @nextSubclientId integer
			DECLARE BSetCursor CURSOR STATIC FOR
			SELECT id FROM App_application WHERE backupset = @BackupsetId
			OPEN BSetCursor
			FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				IF  ( SELECT attrval FROM App_subclientprop
				where attrname like 'Reason last backup time cleared'
				 and componentnameid = @nextSubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
				BEGIN
					UPDATE App_subclientprop SET modified = @nowTime
					where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
					Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
					Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
					--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				END
				UPDATE App_backupsetprop SET modified = @nowTime
				where attrname like 'DB2 Default Index SP' and componentnameid = @BackupsetId
				Insert into App_backupsetprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@BackupsetId, 'DB2 Default Index SP', @logArchGrpId, 7, @nowTime, 0)
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
				FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			END	--Cursor
			close BSetCursor
			deallocate BSetCursor
		END
		ELSE--LOG SP EXPOSED AT INSTANCE LEVEL
		BEGIN
			declare @nextBackupsettId integer
			DECLARE InstanceCursor CURSOR STATIC FOR
			SELECT id, backupset FROM App_application WHERE instance = @InstanceId
			OPEN InstanceCursor
			FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				IF  ( SELECT attrval FROM App_subclientprop
				where attrname like 'Reason last backup time cleared'
				 and componentnameid = @nextSubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
				BEGIN
					UPDATE App_subclientprop SET modified = @nowTime
					where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
					Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
					Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
					--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				END
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @nextBackupsettId
				FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			END	--InstanceCursor
			close InstanceCursor
			deallocate InstanceCursor
		END -- ELSE LOG SP EXPOSED AT INSTANCE LEVEL
	END -- @option & 2 = 2 AND @logArchGrpId != @spId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@SpName+', '+@OPT+', '+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+', '+@PARAM5+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetStoragePolicy')
	delete from GxQscripts where name = 'QS_SetStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicy'
GO

insert into GXDBVersions values(2, 'QS_SetStoragePolicy',  '00000000000000000000', 'QS_SetStoragePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetStoragePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetStoragePolicy.sql -si storage_policy_name -si data/log/all -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : SetStoragePolicy'
)
GO

