

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSpecialClientProp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_SetSpecialClientProp()
--  | Description:  Set 'Special Client in use' on the specified client
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetSpecialClientProp.sp,v $ $Id: QS_SetSpecialClientProp.sp,v 1.1.4.2 2020/06/06 03:02:12 bbrindavan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetSpecialClientProp')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetSpecialClientProp <<<'
	drop procedure QS_SetSpecialClientProp
END
IF EXISTS (select * from GxQscripts where name='QS_SetSpecialClientProp')
	delete from GxQscripts where name = 'QS_SetSpecialClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSpecialClientProp')
	delete from GXDBVersions where aliasname = 'QS_SetSpecialClientProp'
GO
print '... Creating Procedure: QS_SetSpecialClientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSpecialClientProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @param1 NVARCHAR(30),
  @param2 NVARCHAR(10)
AS
SET NOCOUNT ON
DECLARE @errorCode				INTEGER = 0
DECLARE @errorString			NVARCHAR(1024) = N'Successful'
DECLARE @canManage				INT	= 0
DECLARE @ClientId				INT = 0
DECLARE @valToSet				INT = 1
DECLARE @currentTime 			INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @SPECIAL_CLIENT_PROP_NAME	NVARCHAR(64)	=	N'Special Client in use'
DECLARE	@ERROR_NOT_LOGGED_IN		INTEGER	=	1
DECLARE	@ERROR_CLIENT_ID_EMPTY		INTEGER	=	2
DECLARE	@ERROR_CLIENT_ID_INVALID	INTEGER	=	3
DECLARE	@ERROR_VAL_EMPTY			INTEGER	=	2
DECLARE	@ERROR_VAL_INVALID			INTEGER	=	4
DECLARE	@ERROR_AUTH_FAILED			INTEGER	=	5
DECLARE	@ERROR_CLIENT_NOT_FOUND		INTEGER	=	6
DECLARE	@ERROR_EXECUTION			INTEGER	=	7
BEGIN TRY
	-- USER VALIDATION
	--Existence of table and fetching of top 1 userId is done for safety measures
	IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
	BEGIN
		SET @errorCode = @ERROR_NOT_LOGGED_IN
		SET @errorString = N'No logged in user found.'
		goto   SCRIPT_EXIT
	END
	DECLARE @userId INT
	SET @userId = 0
	SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
	IF @userId = 0
	BEGIN
		SET @errorCode = @ERROR_NOT_LOGGED_IN
		SET @errorString = N'No logged in user found.'
		goto   SCRIPT_EXIT
	END
	--Input validation - Client Id--
	--Empty check
	IF (@param1 = N'')
	BEGIN
		SET @ErrorCode = @ERROR_CLIENT_ID_EMPTY
		SET @ErrorString = N'Error. Input param ''ClientId'' is empty, please input a valid client Id.'
		GOTO SCRIPT_EXIT
	END
	IF (@param2 = N'')
	BEGIN
		SET @ErrorCode = @ERROR_VAL_EMPTY
		SET @ErrorString = N'Error. Input param ''value'' is empty, please input a valid ''value'' parameter (0 or 1).'
		GOTO SCRIPT_EXIT
	END
	-- check if client id is a number
	IF (ISNUMERIC(@param1) = 0)
	BEGIN
		SET @ErrorCode = @ERROR_CLIENT_ID_INVALID
		SET @ErrorString = N'Error. Input param ''ClientId'' [' + @param1 + '] is not a number, please input a valid client Id.'
		GOTO SCRIPT_EXIT
	END
	SET @ClientId = CONVERT (INT, @param1)
	-- check if input a valid client id
	IF @ClientId <= 0
	BEGIN
		SET @ErrorCode =  @ERROR_CLIENT_ID_INVALID
		SET @ErrorString = N'Error. Invalid client Id specified [' + CONVERT(NVARCHAR(30), @ClientId) + '].'
		GOTO SCRIPT_EXIT
	END
	-- check if input is a valid client on commcell
	DECLARE @TmpClientId INT  = ISNULL((SELECT id FROM APP_Client WITH(READUNCOMMITTED) WHERE id = @ClientId),0)
	IF @TmpClientId = 0
	BEGIN
		SET @ErrorCode =  @ERROR_CLIENT_ID_INVALID
		SET @ErrorString = N'Error. Client with id [' + CONVERT(NVARCHAR(30), @ClientId) + '] does not exist.'
		GOTO SCRIPT_EXIT
	END
	--Input validation - Value--
	-- check if value param is valid
	IF (ISNUMERIC(@param2) = 0)
	BEGIN
		SET @ErrorCode = @ERROR_VAL_INVALID
		SET @ErrorString = N'Error. Input param ''value'' [' + @param2 + '] is not a number, please input a valid value (0 or 1).'
		GOTO SCRIPT_EXIT
	END
	SET @valToSet =  CONVERT (INT, @param2)
	IF(@valToSet NOT IN (0,1))
	BEGIN
		SET @ErrorCode = @ERROR_VAL_INVALID
		SET @ErrorString = N'Error. Input param ''value'' [' + @param2 + '] is not valid, please input a valid value (0 or 1).'
		GOTO SCRIPT_EXIT
	END
EXEC sec_checkPermissionOnEntity  @userId, 2, @canManage OUTPUT, 3, @ClientId
	IF @canManage <> 1
	BEGIN
		set @errorCode = @ERROR_AUTH_FAILED
		set @errorString = N'Logged in user does not have rights to set property for client [' + CONVERT(NVARCHAR(30), @ClientId) + '].'
		GOTO SCRIPT_EXIT
	END
	UPDATE APP_ClientProp SET attrVal = CONVERT(NVARCHAR(5), @valToSet) WHERE attrName = @SPECIAL_CLIENT_PROP_NAME AND componentNameId=@ClientId AND modified = 0
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@ClientId, @SPECIAL_CLIENT_PROP_NAME, 7,CONVERT(NVARCHAR(5), @valToSet), @currentTime, 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = @ERROR_EXECUTION
		SET @errorString = N'Error on execution : (' + CONVERT(VARCHAR(20), ERROR_NUMBER()) +')[' + ERROR_MESSAGE() +']'
END CATCH
SCRIPT_EXIT:
-- Output will be a single row table - for being REST API compatible
SELECT  @errorCode AS ErrorCode ,
		@errorString AS ErrorMessage,
		GETDATE() AS ExecutionTime
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSpecialClientProp')
	delete from GxQscripts where name = 'QS_SetSpecialClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSpecialClientProp')
	delete from GXDBVersions where aliasname = 'QS_SetSpecialClientProp'
GO

insert into GXDBVersions values(2, 'QS_SetSpecialClientProp',  '00010001000400020000', 'QS_SetSpecialClientProp', '00010001000400020000')
GO

insert into GxQscripts values(2+8,'QS_SetSpecialClientProp',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '    To set or clear ''Special Client in use'' property on the specified client 
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_SetSpecialClientProp.sql -si clientId -si value
'
 + CHAR(10) + '    Where ''value'' should be either 0 or 1 to clear or set the property respectively.
'
)
GO

