

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSpareGroupProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSpareGroupProperties <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSpareGroupProperties')
	drop procedure QS_SetSpareGroupProperties
IF EXISTS (select * from GxQscripts where name='QS_SetSpareGroupProperties')
	delete from GxQscripts where name = 'QS_SetSpareGroupProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSpareGroupProperties')
	delete from GXDBVersions where aliasname = 'QS_SetSpareGroupProperties'
GO
print '... Creating Procedure: QS_SetSpareGroupProperties'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetSpareGroupProperties
-- Qscript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @TapeLibraryName VARCHAR(1024) = '%s',
  @opType INT			  = 0,
  @LowWaterMarkValue INT			  = -1,
  @HighWaterMarkValue INT			  = -1,
  @SpareMediaGroupName VARCHAR(1024) = '%s',
  @OldSpareMediaGroupName VARCHAR(1024) = '%s',
  @NewSpareMediaGroupName VARCHAR(1024) = '%s'
AS
Set NOCOUNT ON
DECLARE @errorString VARCHAR(1024) = 'Sucessfully Executed'
DECLARE @errorCode INT = 0
BEGIN TRANSACTION
--Check if the tape library name is correct
IF NOT EXISTS (	SELECT	*
				FROM	MMLibrary
				WHERE	AliasName = @TapeLibraryName )
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error: Provide Valid Library Name
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
--Check opType
IF NOT (@opType IN (1,2,3,4,5,6,7,8,9,10,11))
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error: Provide valid opType
						Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
END
--Check if the Spare Media Group name is correct
IF (@opType <> 11)
BEGIN
IF NOT EXISTS (	SELECT	*
				FROM	MMLibrary ML , MMSpareGroup SG
				WHERE	ML.LibraryId = SG.LibraryId
AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName AND ( SG.SpareGroupType = 1 OR SG.SpareGroupType = 2 ))
				BEGIN
					SET @errorCode = 3
					SET @errorString = 'Error: Provide a valid Spare Media Group Name
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
END
--@opType = 1 Set Default scratch pool.
--@opType = 2 Set low water mark.
--@opType = 3 Set high water mark.
--@opType = 4 Set low priority.
--@opType = 5 Set medium priority.
--@opType = 6 Set high priority.
--@opType = 7 Use most reused media first.
--@opType = 8 Use least reused media first.
--@opType = 9 Use media based on capacity "Fill lower capacity media first".
--@opType = 10 Use media based on capacity "Fill higher capacity media first".
--@opType = 11 Change the name of the spare media group.
IF (@opType = 1)
BEGIN
		UPDATE SG
SET SG.SpareGroupType = 1
		FROM	MMLibrary ML , MMSpareGroup SG
		WHERE	ML.LibraryId = SG.LibraryId
AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupType = 2
		IF (@@ERROR>0)
			BEGIN
				SET @errorCode = 4
				SET @errorString = 'Failed to update MMSpareGroup for setting default scratch pool.'
				GOTO SCRIPT_EXIT
			END
		UPDATE SG
SET SG.SpareGroupType = 2
		FROM	MMLibrary ML , MMSpareGroup SG
		WHERE	ML.LibraryId = SG.LibraryId
			AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
		IF (@@ERROR>0)
			BEGIN
				SET @errorCode = 5
				SET @errorString = 'Failed to update MMSpareGroup for setting default scratch pool.'
				GOTO SCRIPT_EXIT
			END
		SELECT 'Converted "' + @SpareMediaGroupName +'" as the Default Scratch Pool of "' +  @TapeLibraryName + '" tape library.'
END
ELSE IF(@opType = 2)
BEGIN
	--Check for valid low water mark input
	IF(@LowWaterMarkValue = -1)
		BEGIN
				SET @errorCode = 6
				SET @errorString = 'Provide valid input for low water mark setting.'
				GOTO SCRIPT_EXIT
		END
	-- Check if we are not exceeding the low water mark value
	IF((SELECT	SG.HighWaterMark
			FROM	MMLibrary ML , MMSpareGroup SG
			WHERE	ML.LibraryId = SG.LibraryId
				AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName) <> 0 )
	BEGIN
			IF((SELECT	SG.HighWaterMark
					FROM	MMLibrary ML , MMSpareGroup SG
					WHERE	ML.LibraryId = SG.LibraryId
						AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName) <= @LowWaterMarkValue )
			BEGIN
					SET @errorCode = 7
					SET @errorString = 'High Water mark setting should be greater than low water mark setting.'
					GOTO SCRIPT_EXIT
			END
	END
	UPDATE SG
	SET SG.LowWaterMark = @LowWaterMarkValue , SG.LastUpdateTime = dbo.GetUnixTime(GETUTCDATE())
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 8
			SET @errorString = 'Failed to update MMSpareGroup for setting low water mark.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Updated low water mark level to "'+ CAST (@LowWaterMarkValue AS VARCHAR(1024))+'" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF(@opType = 3)
BEGIN
		--Check for valid high water mark input
		IF(@HighWaterMarkValue = -1)
		BEGIN
				SET @errorCode = 9
				SET @errorString = 'Provide valid input for high water mark setting.'
				GOTO SCRIPT_EXIT
		END
		--Check if this needs to be set to infinite.
		IF(@HighWaterMarkValue = 0)
		BEGIN
				UPDATE SG
				SET SG.HighWaterMark = @HighWaterMarkValue
				FROM	MMLibrary ML , MMSpareGroup SG
				WHERE	ML.LibraryId = SG.LibraryId
					AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
				IF (@@ERROR>0)
				BEGIN
					SET @errorCode = 10
					SET @errorString = 'Failed to update MMSpareGroup for setting high water mark.'
					GOTO SCRIPT_EXIT
				END
				SELECT 'Updated high water mark level to "'+ CAST (@HighWaterMarkValue AS VARCHAR(1024)) +'" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
		END
		-- Check if we are not exceeding the low water mark value
		ELSE
		BEGIN
			IF((SELECT	SG.LowWaterMark
				FROM	MMLibrary ML , MMSpareGroup SG
				WHERE	ML.LibraryId = SG.LibraryId
					AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName) >= @HighWaterMarkValue )
			BEGIN
					SET @errorCode = 11
					SET @errorString = 'High Water mark setting should be greater than low water mark setting.'
					GOTO SCRIPT_EXIT
			END
			UPDATE SG
			SET SG.HighWaterMark = @HighWaterMarkValue
			FROM	MMLibrary ML , MMSpareGroup SG
			WHERE	ML.LibraryId = SG.LibraryId
				AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
			IF (@@ERROR>0)
			BEGIN
				SET @errorCode = 12
				SET @errorString = 'Failed to update MMSpareGroup for setting high water mark.'
				GOTO SCRIPT_EXIT
			END
			SELECT 'Updated high water mark level to "'+ CAST (@HighWaterMarkValue AS VARCHAR(1024)) +'" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
		END
END
ELSE IF(@opType = 4)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~7|1
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 13
			SET @errorString = 'Failed to update MMSpareGroup for setting low priority.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the priority to low for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
IF(@opType = 5)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~7|2
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 14
			SET @errorString = 'Failed to update MMSpareGroup for setting medium priority.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the priority to medium for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF(@opType = 6)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~7|4
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 15
			SET @errorString = 'Failed to update MMSpareGroup for setting high priority.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the priority to high for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF (@opType = 7)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~120|8
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 16
			SET @errorString = 'Failed to update MMSpareGroup for setting use most reused media first.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the "Spare Media Selection Criteria" to "Use most reused Media First" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF (@opType = 8)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~120|16
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 17
			SET @errorString = 'Failed to update MMSpareGroup for setting use least reused media first.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the "Spare Media Selection Criteria" to "Use least reused Media First" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF (@opType = 9)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~120|32
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 18
			SET @errorString = 'Failed to update MMSpareGroup for setting use media based on capacity "Fill lower capacity media first".'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the "Spare Media Selection Criteria" to "Use media based on Capacity - Fill lower capacity media first" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF (@opType = 10)
BEGIN
	UPDATE SG
SET SG.Attributes = SG.Attributes&~120|64
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @SpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 19
			SET @errorString = 'Failed to update MMSpareGroup for setting use media based on capacity "Fill higher capacity media first".'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Set the "Spare Media Selection Criteria" to "Use media based on Capacity - Fill higher capacity media first" for "' + @SpareMediaGroupName + '" spare media group of "' + @TapeLibraryName + '" tape library.'
END
ELSE IF (@opType = 11)
BEGIN
	--Check for valid inputs
	IF (@OldSpareMediaGroupName = '%s' OR @NewSpareMediaGroupName = '%s')
				BEGIN
					SET @errorCode = 20
					SET @errorString = 'Error: Provide Old and New Spare Media Group Name
										Please refer to the documentation and retry with necessary parameters.'
					GOTO SCRIPT_EXIT
				END
	--Check if the Old spare media group name is correct
	IF NOT EXISTS (	SELECT	*
				FROM	MMLibrary ML , MMSpareGroup SG
				WHERE	ML.LibraryId = SG.LibraryId
					AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @OldSpareMediaGroupName )
				BEGIN
					SET @errorCode = 21
					SET @errorString = 'Error: Provide a valid Spare Media Group Name
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
	--Check if the new spare media group name is already not being taken
	IF EXISTS (	SELECT	*
				FROM	MMLibrary ML , MMSpareGroup SG
				WHERE	ML.LibraryId = SG.LibraryId
					AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @NewSpareMediaGroupName )
				BEGIN
					SET @errorCode = 22
					SET @errorString = 'Error: Provide a valid new Spare Media Group Name since the given name is already being used by another media group.
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
	UPDATE SG
	SET SG.SpareGroupName = @NewSpareMediaGroupName
	FROM	MMLibrary ML , MMSpareGroup SG
	WHERE	ML.LibraryId = SG.LibraryId
		AND ML.AliasName = @TapeLibraryName AND SG.SpareGroupName = @OldSpareMediaGroupName
	IF (@@ERROR>0)
		BEGIN
			SET @errorCode = 23
			SET @errorString = 'Failed to update MMSpareGroup to change the spare group name".'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Converted spare media group name from "' + @OldSpareMediaGroupName + '" to "' + @NewSpareMediaGroupName + '" of "' + @TapeLibraryName + '" tape library.'
END
COMMIT TRANSACTION
SCRIPT_EXIT:
	IF(@errorCode <> 0)
		BEGIN
			ROLLBACK TRAN
			RAISERROR(@errorString,16,1)
		END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSpareGroupProperties')
	delete from GxQscripts where name = 'QS_SetSpareGroupProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSpareGroupProperties')
	delete from GXDBVersions where aliasname = 'QS_SetSpareGroupProperties'
GO

insert into GXDBVersions values(2, 'QS_SetSpareGroupProperties',  '00000000000000000000', 'QS_SetSpareGroupProperties', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSpareGroupProperties',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' Generic script for setting drive properties 
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + ' To set a spare media group as default scratch pool.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''1'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set low water mark on a spare media group.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''2'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'' -si @LowWaterMarkValue = ''<Value that needs to be set>'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set high water mark on a spare media group.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''3'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'' -si @HighWaterMarkValue = ''<Value that needs to be set>'''
 + CHAR(10) + ' If the @HighWaterMarkValue = 0 , then the high water mark level will be set to infinite.
'
 + CHAR(10) + '
'
 + CHAR(10) + ' To set priority as low on a spare media group.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''4'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set priority as medium on a spare media group.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''5'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set priority as high on a spare media group.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''6'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set "Spare Media Selection Criteria" to "Use most reused Media first".
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''7'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set "Spare Media Selection Criteria" to "Use least reused Media first".
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''8'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set "Spare Media Selection Criteria" to "Use media based on Capacity - Fill lower capacity Media first".
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''9'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To set "Spare Media Selection Criteria" to "Use media based on Capacity - Fill higher capacity Media first".
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''10'' -si @TapeLibraryName=''Name of the library'' -si @SpareMediaGroupName = ''Spare Media Group Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To change the name of the scratch pool
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetSpareGroupProperties -si @opType = ''11'' -si @TapeLibraryName=''Name of the library'' -si @OldSpareMediaGroupName = ''Current Spare Media Group Name'' -si @NewSpareMediaGroupName = ''New Spare Media Group Name'''
 + CHAR(10) + '
'
)
GO

