

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSchedulePolicy')
	drop procedure QS_SetSchedulePolicy
IF EXISTS (select * from GxQscripts where name='QS_SetSchedulePolicy')
	delete from GxQscripts where name = 'QS_SetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetSchedulePolicy'
GO
print '... Creating Procedure: QS_SetSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetSchedulePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @taskName varchar(1024) = '%s',
  @AppIdString varchar(1024) = '%s',
  @OPT varchar(4) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @taskName	varchar(1024)
--SET		@taskName	= '%s'
--DECLARE @AppIdString	varchar(1024)
--SET		@AppIdString	= '%s'
--DECLARE @OPT 		varchar(4)
--SET		@OPT		= '%s'
---------------------------------------
--test
--SET		@taskName	= 'newsp'
--SET		@AppIdString = '5'
--SET		@OPT		= 'ADD'
--SET		@OPT		= 'REM'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetSchedulePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @optAdd	varchar(32)
SET		@optAdd	= 'ADD'
DECLARE @optRem	varchar(32)
SET		@optRem	= 'REM'
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @taskName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @AppIdString = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient id Expected as parameter 2.'
	GOTO ARGS_ERROR
END
-------------add/rem------------------
IF @OPT = @NoParameter
BEGIN
	SET @OPT = @optAdd
	PRINT 'Subclient with id ['+@AppIdString +'] will be associated with schedule policy ['+@taskName+'].'
END
IF @OPT <> @optAdd AND @OPT <> @optRem
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Unsupported operation ['+@OPT +'].'
	GOTO ARGS_ERROR
END
------------ validate subclient id ----------------
DECLARE @subclientId integer
SET @subclientId = convert(integer, @AppIdString)
IF (SELECT count(*) from APP_application where id = @subclientId) = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id ['+@AppIdString+'] not found.'
	GOTO ARGS_ERROR
END
DECLARE @subclientFlag integer
SET @subclientFlag = (SELECT subclientStatus from APP_Application where id = @subclientId)
IF ((@subclientFlag & 2 = 2) OR  (@subclientFlag & 4 = 4))
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id ['+@AppIdString+'] is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
---------------- Get other ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
SELECT @ClientId = clientid, @AppTypeId = apptypeid, @InstanceId = instance, @BackupsetId = backupset
FROM APP_APPLICATION WHERE id = @subclientId
--------------STEP 1 ---------------------
--Get taskId using taskName From TM_Task
DECLARE @taskId integer
SET @taskId = ISNULL((Select taskId from TM_Task where taskName like @taskName ), 0)
IF @taskId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] not found.'
	GOTO ARGS_ERROR
END
--------------STEP 2 ---------------------
-- Type of policy must be backup.
DECLARE @schedType integer
Select @schedType = policyType from TM_Task where taskId = @taskId
IF @schedType <> 0 -- DATA_PROTECTION
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] is not for backups. It cannot be associated using this script.'
	GOTO ARGS_ERROR
END
--------------STEP 3 ---------------------
-- AppType must be compatible
DECLARE @appTypeTable TABLE (appType integer)
DECLARE @isAppTypeSupported int
	SET @isAppTypeSupported  = 0
Insert into @appTypeTable
Select filter_value from TM_AssocFilter where taskId = @taskId and filter_type = 2 -- AppType
Set @lastError = @@ERROR
IF @lastError <> 0
BEGIN
	SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
	GOTO TRANS_EXIT
END
-- Now insert all apptypes that are in this group to this table
Insert into @appTypeTable
Select appTypeId from APP_AppTypeGroupAssoc
where appGroupId in (Select filter_value from TM_AssocFilter where taskId = @taskId and filter_type = 1) -- AppGroup
Set @lastError = @@ERROR
IF @lastError <> 0
BEGIN
	SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
	GOTO TRANS_EXIT
END
Set @isAppTypeSupported = (Select COUNT(*) from @appTypeTable where appType = @apptypeid)
-- If no rows then it means all agents
IF (Select COUNT(*) from @appTypeTable) = 0
	Set @isAppTypeSupported = 1
IF @isAppTypeSupported = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] is not for this type of iDA. It cannot be associated with this subclient.'
	GOTO ARGS_ERROR
END
--------------STEP 4 ---------------------
BEGIN TRAN
-- ADD Option
IF @OPT = @optAdd
BEGIN
	-- Step 4.a --
	-- Check if subclient is already associated via parent node
	DECLARE @clientGroupTable TABLE (clientGroupId integer)
	Insert into @clientGroupTable
	Select clientGroupId  from APP_ClientGroupAssoc
	where clientId = @ClientId
	Set @lastError = @@ERROR
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
		GOTO TRANS_EXIT
	END
	IF ((Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientGroupId IN (Select clientGroupId from @clientGroupTable)
		and clientId = 0 and apptypeId = 0 and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL clients in a clientgroup parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId
		and apptypeId = 0 and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL iDAs in the client parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId
		and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL instances in the iDA parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId  and instanceId = @InstanceId
		and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL backupsets in the instance parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId and instanceId = @InstanceId and backupsetId = @BackupsetId
		and subclientId = 0) > 0 -- ALL subclients in the backupset parent node.
	    )
    BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Subclient is with this schedule policy through a parent node.'
		GOTO TRANS_EXIT
	END
	IF (Select COUNT(*) from TM_AssocEntity
	where taskId = @taskId and subclientId = @subclientId) > 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Subclient is already associated with this schedule policy.'
		GOTO TRANS_EXIT
	END
	-- Step 4.b --
	-- If not, add the association to the subclient
	DECLARE  @timeStamp int
		SET @timeStamp     = dbo.GetUnixTime (GetUTCdate())
	Insert into TM_AssocEntity	(assocType,			taskId,			flags,		created,		exclude,
								 clientGroupId,		clientId,		apptypeId,	instanceId,		backupsetId,
								 subclientId,		policyId,		copyId,		srmReportSet,	srmReportType,
								 trackingPolicyId,	MediaAgentId,	agentlessPolicyId, workflowId, sidbStoreId,
								 libraryId, logMonitoringPolicyId
								 )
values						(7,		@taskId,		0,			@timeStamp,		0,
								 0,					@ClientId,		@AppTypeId, @InstanceId,	@BackupsetId,
								 @subclientId,		0,				0,			0,				0,
								 0,					0,				0,			0,				0,
								 0,					0
								 )
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not associate schedule policy.'
		GOTO TRANS_EXIT
	END
END
-- REM Option
ELSE
IF @OPT = @optRem
BEGIN
	Delete from TM_AssocEntity
	where taskId = @taskId
	and subclientId = @subclientId and assocType = 7 -- Subclient association
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
		GOTO TRANS_EXIT
	END
END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@taskName+', '+@AppIdString+', '+@OPT+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSchedulePolicy')
	delete from GxQscripts where name = 'QS_SetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetSchedulePolicy'
GO

insert into GXDBVersions values(2, 'QS_SetSchedulePolicy',  '00000000000000000000', 'QS_SetSchedulePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSchedulePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSchedulePolicy.sql -si schedulepolicy_name -si subclient_ID [-si ADD/REM]
'
 + CHAR(10) + '--   script_name : SetSchedulePolicy'
)
GO

