

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetScanOptionsForSCP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetScanOptionsForSCP <<<'

IF EXISTS (select * from sysobjects where name='QS_SetScanOptionsForSCP')
	drop procedure QS_SetScanOptionsForSCP
IF EXISTS (select * from GxQscripts where name='QS_SetScanOptionsForSCP')
	delete from GxQscripts where name = 'QS_SetScanOptionsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetScanOptionsForSCP')
	delete from GXDBVersions where aliasname = 'QS_SetScanOptionsForSCP'
GO
print '... Creating Procedure: QS_SetScanOptionsForSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetScanOptionsForSCP
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @subclientPolicyName NVARCHAR(1024),
  @scanOptionsParam NVARCHAR(1024)
AS
--Inputs
--DECLARE @subclientPolicyName AS NVARCHAR(1024)
--DECLARE @scanOptionsParam AS NVARCHAR(1024)
SET NOCOUNT ON
--Constants
DECLARE @errorCode AS INTEGER
SET @errorCode = 0
DECLARE @errorString AS NVARCHAR(100)
SET @errorString = 'Successful'
DECLARE @nowTime AS INTEGER
SET @nowTime = dbo.GetUnixTime(GetUTCDate())
DECLARE @subclientPolicyId AS INTEGER
SET @subclientPolicyId = 0
DECLARE @scanOptions AS NVARCHAR(1024)
SET @scanOptions = ''
--Input validation
--1. Empty check
IF @subclientPolicyName = '' OR @scanOptionsParam = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient policy name and scan options must be provided'
	GOTO ERR_EXIT
END
--2. Subclient policy name validation
SET @subclientPolicyId = ISNULL((SELECT DISTINCT TOP 1 Bkp.id
								 FROM APP_Backupsetname Bkp INNER JOIN APP_Application Appl
								 ON Bkp.id = Appl.backupSet
								 WHERE Appl.appTypeId = 1030 AND Bkp.name = @subClientPolicyName),0)
IF @subclientPolicyId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient policy name is not valid'
	GOTO ERR_EXIT
END
IF (SELECT attrVal
	FROM APP_BackupSetProp
	WHERE componentNameId = @subclientPolicyId AND attrName = 'Associated subclient Policy Ida Type' AND modified = 0) <> '2'
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. This script can be used only with windows subclient policy'
	GOTO ERR_EXIT
END
--3. Scan options validation
--Valid combinations are
-------------------------------------------------------------------------------
--Change Journal
--Recursive Scan
--Recursive Scan + Preserve File Access Time
--Recursive Scan + Check archive bit during backups
--Recursive Scan + Preserve File Access Time + Check archive bit during backups
--Optimal Scan
--------------------------------------------------------------------------------
SET @scanOptions = @scanOptionsParam
IF CHARINDEX(';', @scanOptions, LEN(@scanOptions)) = 0
	SET @scanOptions = @scanOptions + ';'
DECLARE @optionsTable TABLE
(
	optionStr NVARCHAR(512)
)
DECLARE @currPos AS INT
SET @currPos = CHARINDEX(';', @scanOptions)
WHILE (@scanOptions <> N'') AND (@scanOptions IS NOT NULL)
BEGIN
	INSERT INTO @optionsTable(optionStr)
		VALUES(LTRIM(RTRIM(SUBSTRING(@scanOptions, 1, @currPos-1))))
	SET @scanOptions = SUBSTRING(@scanOptions, @currPos+1, LEN(@scanOptions)-@currPos)
	SET @currPos = CHARINDEX(';', @scanOptions)
END
IF EXISTS (SELECT *
		   FROM @optionsTable
		   WHERE optionStr NOT IN ('Change Journal',
								   'Recursive Scan',
								   'Preserve File Access Time',
								   'Check archive bit during backups',
								   'Optimal Scan'))
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid scan option [' + (SELECT TOP 1 optionStr
														 FROM @optionsTable
														 WHERE optionStr NOT IN ('Change Journal',
																				 'Recursive Scan',
																				 'Preserve File Access Time',
																				 'Check archive bit during backups',
																				 'Optimal Scan')) + '] specified'
	GOTO ERR_EXIT
END
DECLARE @optionWord AS INTEGER
SET @optionWord = 0
SET @optionWord = (SELECT SUM(POWER(2,(CASE optionStr
											WHEN 'Optimal Scan' THEN 0
											WHEN 'Check archive bit during backups' THEN 1
											WHEN 'Preserve File Access Time' THEN 2
											WHEN 'Recursive Scan' THEN 3
											WHEN 'Change Journal' THEN 4
										END)))
					FROM @optionsTable)
IF @optionWord NOT IN (1,8,10,12,14,16)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid combination of scan options specified'
	GOTO ERR_EXIT
END
--Inputs are valid. Doing the property insertion
DECLARE @entityTable TABLE
(
	backupSetId INT,
	subclientId INT
)
INSERT INTO @entityTable (backupSetId, subclientId)
	SELECT DISTINCT Appl.backupset, Appl.id
	FROM APP_BackupSetProp BkpProp INNER JOIN APP_Application Appl
	ON BkpProp.componentNameId = Appl.backupSet
	WHERE BkpProp.attrName = 'Associated Subclient Policy' AND BkpProp.attrVal = CAST(@subclientPolicyId AS NVARCHAR(10)) AND BkpProp.modified = 0 AND Appl.subclientStatus & 4 = 0
DELETE FROM @entityTable
WHERE backupSetId IN (SELECT id
					  FROM APP_BackupSetName
					  WHERE status & 2 = 2)
DELETE FROM @entityTable
WHERE backupSetId IN (SELECT DISTINCT Appl.backupSet
					  FROM APP_Application Appl INNER JOIN APP_Client Cli
					  ON Appl.clientId = Cli.id
					  WHERE Cli.releaseId < 15)
DECLARE @useChangeJournal AS NVARCHAR(10)
DECLARE @useClassicFileScan AS NVARCHAR(10)
DECLARE @preserveFileAccessTime AS NVARCHAR(10)
DECLARE @useArchiveBit AS NVARCHAR(10)
DECLARE @useDCForFSBackups AS NVARCHAR(10)
SET @useChangeJournal = '0'
SET @useClassicFileScan = '0'
SET @preserveFileAccessTime = '0'
SET @useArchiveBit  = '0'
SET @useDCForFSBackups = '0'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Change Journal')
	SET @useChangeJournal = '1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Optimal Scan')
	SET @useDCForFSBackups = '1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Recursive Scan')
	SET @useClassicFileScan = '1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Preserve File Access Time')
	SET @preserveFileAccessTime = '1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Check archive bit during backups')
	SET @useArchiveBit = '1'
BEGIN TRAN
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId IN (SELECT subclientId
							  FROM @entityTable)
		 AND attrName in ('Use DC for FS backups',
						  'Use Change Journal',
						  'Use Classic File Scan',
						  'Preserve File Access Times',
						  'Use Archive Bit')
		 AND modified = 0
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use DC for FS backups', 2, @useDCForFSBackups, @nowTime, 0
		FROM @entityTable
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use Change Journal', 2, @useChangeJournal, @nowTime, 0
		FROM @entityTable
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use Classic File Scan', 2, @useClassicFileScan, @nowTime, 0
		FROM @entityTable
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Preserve File Access Times', 2, @preserveFileAccessTime, @nowTime, 0
		FROM @entityTable
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use Archive Bit', 2, @useArchiveBit, @nowTime, 0
		FROM @entityTable
IF @@ERROR = 0
	COMMIT TRAN
ELSE
BEGIN
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
	ROLLBACK TRAN
END
ERR_EXIT:
IF @errorCode <> 0
    RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetScanOptionsForSCP')
	delete from GxQscripts where name = 'QS_SetScanOptionsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetScanOptionsForSCP')
	delete from GXDBVersions where aliasname = 'QS_SetScanOptionsForSCP'
GO

insert into GXDBVersions values(2, 'QS_SetScanOptionsForSCP',  '00000000000000000000', 'QS_SetScanOptionsForSCP', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetScanOptionsForSCP',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Change Journal"
'
 + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Recursive Scan"
'
 + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Recursive Scan ; Preserve File Access Time"
'
 + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Recursive Scan ; Check archive bit during backups"
'
 + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Recursive Scan ; Preserve File Access Time ; Check archive bit during backups"
'
 + CHAR(10) + '	qoperation execscript -sn "SetScanOptionsForSCP" -si "Subclient_policy_name" -si "Optimal Scan"
'
)
GO

