

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetScanOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetScanOptions <<<'

IF EXISTS (select * from sysobjects where name='QS_SetScanOptions')
	drop procedure QS_SetScanOptions
IF EXISTS (select * from GxQscripts where name='QS_SetScanOptions')
	delete from GxQscripts where name = 'QS_SetScanOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetScanOptions')
	delete from GXDBVersions where aliasname = 'QS_SetScanOptions'
GO
print '... Creating Procedure: QS_SetScanOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetScanOptions
--Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
--Stored Procedure Inputs
  @clientgroupName nvarchar(512) = N'',
  @scanOptionsParam nvarchar(1024) = N''
AS
--Dont print 'XXX rows affected' in the command line console when this script gets executed
SET NOCOUNT ON
--Input Variables--
DECLARE @clientGroupId AS INT
SET @clientGroupId = 0
DECLARE @scanOptions AS NVARCHAR(1024)
SET @scanOptions = N''
--Constants--
DECLARE @scriptName	AS NVARCHAR(512)
SET @scriptName	= 'SetScanOptions'
DECLARE @errorCode AS INTEGER
SET @errorCode = 0	--Be optimistic
DECLARE @errorString AS NVARCHAR(1000)
SET @errorString = 'Successful'
DECLARE @nowTime AS INTEGER
SET @nowTime = dbo.GetUnixTime(GetUTCDate())
--Input validation and assignation--
--1. Null and empty check
IF(@clientGroupName IS NULL OR @scanOptionsParam IS NULL OR @clientGroupName = N'' OR @scanOptionsParam = N'')
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error - empty inputs passed. Client group name and scan option must be specified mandatorily'
	GOTO ERROR_EXIT
END
--2. Validation of client group name
SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = @clientGroupName), 0)
IF @clientGroupId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Group name [' + @clientGroupName + '] is not valid'
	GOTO ERROR_EXIT
END
--3. Extraction of individual scan options from the specified string
SET @scanOptions = @scanOptionsParam
IF CHARINDEX(';', @scanOptions, LEN(@scanOptions)) = 0		--Check whether it is terminated with ';' if not append ';'
SET @scanOptions = @scanOptions + ';'
DECLARE @optionsTable TABLE
(
	optionStr NVARCHAR(512)
)
DECLARE @currPos AS INT
SET @currPos = CHARINDEX(';',@scanOptions)
WHILE (@scanOptions <> N'') AND (@scanOptions is not null)
BEGIN
	INSERT INTO @optionsTable(optionStr)
		VALUES(LTRIM(RTRIM(SUBSTRING(@scanOptions, 1, @currPos-1))))
	SET @scanOptions = SUBSTRING(@scanOptions, @currPos+1, LEN(@scanOptions) - @currPos)
SET @currPos = CHARINDEX(';', @scanOptions)
END
--4. Validation of the scan options specified
--------------------------------------------------------------------------------------------
--These are the valid combinations that can be specified from GUI for the specified apptypes:
--33, 42, 43, 34:
--use data classification;
--use classic file scan;
--use classic file scan; check archive bit during backups;
--use classic file scan; preserve file access time;
--use classic file scan; preserve file access time; check archive bit during backups;
--use change journal;
--------------------------------------------------------------------------------------------
--4a. Check if the option text is valid
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr NOT IN ('Use Data Classification', 'Check Archive bit during backups', 'Preserve File Access Time', 'Use Change Journal', 'Use Classic File Scan'))
BEGIN
	SET @errorCode = 1
SET @errorString = 'Error. Invalid scan option [' + (SELECT TOP 1 optionStr FROM @optionsTable WHERE optionStr NOT IN ('Use Data Classification', 'Check Archive bit during backups', 'Preserve File Access Time', 'Use Change Journal', 'Use Classic File Scan')) + '] specified'
	GOTO ERROR_EXIT
END
--4b. Check whether the combination is valid
DECLARE @optionWord AS INTEGER = 0
SET @optionWord = (SELECT SUM(POWER(2,(CASE optionStr
WHEN 'Use Data Classification'	THEN 0
WHEN 'Check Archive bit during backups'			THEN 1
WHEN 'Preserve File Access Time'	THEN 2
WHEN 'Use Classic File Scan'		THEN 3
WHEN 'Use Change Journal'			THEN 4
										END)))
					FROM @optionsTable)
IF @optionWord NOT IN (1,8,10,12,14,16)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid combination of scan option specified'
	GOTO ERROR_EXIT
END
--All the input options are valid.
--1. Fetch the file system backupsets for 9.0 clients (or lesser) belonging to this client Group
DECLARE @entityBkpSetTbl TABLE
(
	clientId INT,
	appTypeId INT,
	backupSetId INT
)
INSERT INTO @entityBkpSetTbl
	SELECT DISTINCT clientId, appTypeId, backupset
	FROM APP_Application
	WHERE clientId IN (SELECT clientid FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId)
		AND apptypeId IN (11, 33, 34, 42, 43)
		AND clientId IN (SELECT id FROM APP_Client WHERE releaseId < 15)
--2. Fetch the file system subclients for greater than 9.0 clients belonging to this client group
DECLARE @entitySubClientTbl TABLE
(
	clientId INT,
	appTypeId INT,
	backupSetId INT,
	subclientId INT
)
INSERT INTO @entitySubClientTbl
	SELECT DISTINCT clientId, appTypeId, backupset, id
	FROM APP_Application
	WHERE clientId IN (SELECT clientid FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId)
		AND apptypeId IN (11, 33, 34, 42, 43)
		AND clientId IN (SELECT id FROM APP_Client WHERE releaseId >= 15)
--3. Lets have a check whether the backupset and subclient ids are valid.
DELETE FROM @entityBkpSetTbl
WHERE backupSetId NOT IN (SELECT id
						  FROM APP_BackupSetName
WHERE ((status & 0x00004 = 0) AND
(status & 0x00002 = 0) AND
(status & 0x00010 = 0) AND
(status & 0x00020 = 0)))
DELETE FROM @entitySubClientTbl
WHERE subclientId NOT IN (SELECT id
						  FROM APP_Application
WHERE ((subClientStatus & 0x00004 = 0) AND
(subClientStatus & 0x00002 = 0) AND
(subClientStatus & 0x00010 = 0) AND
(subClientStatus & 0x00020 = 0)))
--4. These properties are implemented as radio buttons in GUI. So if you are enabling one property that means rest are disabled.
--So set the corresponding property to 1 and set others to 0
DECLARE @useChangeJournal AS NVARCHAR
DECLARE @checkArchiveBitDuringBackups AS NVARCHAR
DECLARE @preserveFileAccessTimes AS NVARCHAR
DECLARE @useDataClassification AS NVARCHAR
DECLARE @useClassicFileScan AS NVARCHAR
SET @useChangeJournal = N'0'
SET @checkArchiveBitDuringBackups = N'0'
SET @preserveFileAccessTimes = N'0'
SET @useDataClassification = N'0'
SET @useClassicFileScan = N'0'
--All the property present in @optionsTable should be saved with 1 for all the backupsets in @entityBkpSetTbl
--and subclients in @entitySubClientTbl
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Use Change Journal')
	SET @useChangeJournal = N'1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Check Archive bit during backups')
	SET @checkArchiveBitDuringBackups = N'1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Preserve File Access Time')
	SET @preserveFileAccessTimes = N'1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Use Data Classification')
	SET @useDataClassification = N'1'
IF EXISTS (SELECT * FROM @optionsTable WHERE optionStr = 'Use Classic File Scan')
	SET @useClassicFileScan = N'1'
--5. All valid entities which needs to be affected are present in @entityBkpSetTbl and @entitySubClientTbl.
--Delete the old property existing and then insert the appropriate new value
BEGIN TRAN
BEGIN TRY
	DELETE APP_BackupSetProp
	WHERE componentNameId IN (SELECT backupsetId FROM @entityBkpSetTbl)
AND attrName IN ('Use DC for FS backups', 'Use Archive Bit', 'Reset File Access times', 'Use Change Journal')
	UPDATE APP_SubclientProp
	SET modified = @nowTime
	WHERE componentNameId IN (SELECT subclientId FROM @entitySubClientTbl)
AND attrName IN ('Use Change Journal', 'Use Classic File Scan', 'Use Archive Bit', 'Preserve File Access times', 'Use DC for FS backups')
		AND modified = 0
--6. Insert the new values.
	INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT backupsetId, 'Use Change Journal', 2, @useChangeJournal, @nowTime, 0, 0
			FROM @entityBkpSetTbl
	INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT backupsetId, 'Use Archive Bit', 2, @checkArchiveBitDuringBackups, @nowTime, 0, 0
			FROM @entityBkpSetTbl
	INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT backupsetId, 'Reset File Access times', 2, @preserveFileAccessTimes, @nowTime, 0, 0
			FROM @entityBkpSetTbl
	INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT backupsetId, 'Use DC for FS backups', 2, @useDataClassification, @nowTime, 0, 0
			FROM @entityBkpSetTbl
	--Note. Classic file scan is identified by setting the other 2 options - Use Change journal and Use data classification to 0 till 9.0
	--From 10.0 we can set the property use classic file scan to 1
	INSERT INTO APP_Subclientprop(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Use Change Journal', 2, @useChangeJournal, @NowTime, 0, 0
		FROM @entitySubClientTbl
	INSERT INTO APP_Subclientprop(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Use Classic File Scan', 2, @useClassicFileScan, @NowTime, 0, 0
		FROM @entitySubClientTbl
	INSERT INTO APP_Subclientprop(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Use Archive Bit', 2, @checkArchiveBitDuringBackups, @NowTime, 0, 0
		FROM @entitySubClientTbl
	INSERT INTO APP_Subclientprop(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Preserve File Access times', 2, @preserveFileAccessTimes, @NowTime, 0, 0
		FROM @entitySubClientTbl
	INSERT INTO APP_Subclientprop(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Use DC for FS backups', 2, @useDataClassification, @NowTime, 0, 0
		FROM @entitySubClientTbl
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
	ROLLBACK TRAN
	GOTO ERROR_EXIT
END CATCH
IF @errorCode = 0
	COMMIT TRAN
ERROR_EXIT:
IF @errorCode <> 0
	RAISERROR(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetScanOptions')
	delete from GxQscripts where name = 'QS_SetScanOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetScanOptions')
	delete from GXDBVersions where aliasname = 'QS_SetScanOptions'
GO

insert into GXDBVersions values(2, 'QS_SetScanOptions',  '00000000000000000000', 'QS_SetScanOptions', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetScanOptions',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	Script_Name: SetScanOptions
'
 + CHAR(10) + '	Usage: qoperation execscript -sn SetScanOptions.sql -si client_group_name -si scan_options
'
 + CHAR(10) + '	Description: Sets the scan option specified for all the backupsets and subclients of Windows FS iDA within the given client group
'
)
GO

