

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSPDBSubclientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSPDBSubclientContent <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSPDBSubclientContent')
	drop procedure QS_SetSPDBSubclientContent
IF EXISTS (select * from GxQscripts where name='QS_SetSPDBSubclientContent')
	delete from GxQscripts where name = 'QS_SetSPDBSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSPDBSubclientContent')
	delete from GXDBVersions where aliasname = 'QS_SetSPDBSubclientContent'
GO
print '... Creating Procedure: QS_SetSPDBSubclientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSPDBSubclientContent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName nvarchar(1030) = '%s',
  @subClientName nvarchar(1030) = '%s',
  @fileName nvarchar(1030) = '%s'
AS
SET QUOTED_IDENTIFIER ON
set nocount on
---------------command line inputs-------
--DECLARE @clientName  NVARCHAR(1030)
--SET @clientName = '%s'
--DECLARE @subclientName  NVARCHAR(1030)
--SET @subclientName = '%s'
--DECLARE @fileName  NVARCHAR(1030)
--SET @fileName = '%s'
-------------------Test-------------------------------
--SET @clientName = 'scowss01.directory.ssdnintra.net'
--SET @subclientName = 'gokul_check6'
--SET @fileName  = 'C:\Content2.txt'
--------------------------------------------------------
-----------insufficient parameters ---------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
---------------constants--------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetSPDBSubclientContent'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @delim		varchar(1)
SET		@delim = '|'
DECLARE @dataType varchar(64)
SET @dataType =  'Site Collection'
DECLARE @attrVal varchar(64)
SET @attrVal = 'Site+1Collection 1 nothing nothing'
DECLARE @placeHolder	varchar(64)
SET @placeHolder = 'Place Holder'
--------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
----------------Variables--------------------
DECLARE @clientId	INT
DECLARE @instanceId INT
DECLARE @backupSetId	INT
DECLARE @defSubclientId INT
DECLARE @subclientId	INT
CREATE TABLE #tempfile (line varchar(1024))
---------------------------------------------
IF @clientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No client name was given.'
	GOTO ARGS_ERROR
END
IF @subclientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No subclient name  was given.'
	GOTO ARGS_ERROR
END
IF @fileName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No content file name was given.'
	GOTO ARGS_ERROR
END
-- Check if file exists ---
EXEC ('bulk INSERT #tempfile FROM "' + @fileName + '"')
IF @@ERROR	<> 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Unable to open content file.'
	GOTO ARGS_ERROR
END
---------------------------------------------------
-- Get ClientID first
SELECT @clientId = ISNULL( id  , 0)
FROM APP_Client
WHERE name = @clientName
IF @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid client specified.'
	GOTO ARGS_ERROR
END
-- Get Instance ID and BackupSet ID from default subclient
SELECT @instanceId = instance , @backupSetId = backupSet, @defSubclientId = id
FROM APP_Application
WHERE clientId = @clientId AND appTypeId = 69 AND subclientStatus&0x8 = 0x8-- SharePoint DB default subclient
IF @instanceId = 0 OR @backupSetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Unable to get default instance and backupSet for the client.'
	GOTO ARGS_ERROR
END
-- Check if already a subclient is there
IF (SELECT COUNT(*) FROM APP_Application WHERE clientId = @clientId AND appTypeId = 69 AND backupSet = @backupSetId AND subclientName = @subClientName AND subclientStatus&0x4 <> 4) <> 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Another subclient with the same name exists.'
	GOTO ARGS_ERROR
END
BEGIN TRAN
-- Create the new Subclient
INSERT INTO APP_Application (clientId,		appTypeId,		instance,
							 backupSet,		appNumber,		dataArchGrpID,
							 logArchGrpID,	refTime,		modified,
							 subclientName,	subclientStatus)
VALUES						(@clientId,		69,				@instanceId,
							 @backupSetId,  0,				1,
							 1,				@nowTime,		0,
							 @subclientName,0)
SET @errorCode = @@ERROR
SET @subclientId = @@IDENTITY
IF @errorCode <> 0 OR @subclientId = 0
BEGIN
	SET @errorString = 'Error. Could not create subclient.'
	GOTO TRANS_EXIT
END
----------------------------------------------------------------------------------------
-- Now parse through the #tempFileTable and insert records into Subclient Content table
----------------------------------------------------------------------------------------
DECLARE @currentSite varchar(1024)
DECLARE @desc		 varchar(40)
DECLARE @virtualServer varchar(1024)
DECLARE @currentFileName varchar(1024)
DECLARE @position INT
DECLARE GetSubclientContent CURSOR
FOR SELECT ISNULL(line,'') FROM #tempfile
OPEN GetSubclientContent
FETCH GetSubclientContent INTO @currentSite
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @currentSite = '' OR @currentSite = NULL
	BEGIN
		PRINT 'Skipping empty Site Content...'
		FETCH GetSubclientContent INTO @currentSite
		CONTINUE
	END
	SET @position = 0
	SET @virtualServer = ''
	SET @position = CHARINDEX('/', @currentSite, 0)
	WHILE SUBSTRING(@currentSite, @position + 1, 1) = '/'
	BEGIN
		SET @position = CHARINDEX('/', @currentSite, @position + 2)
	END
	IF @position = LEN(@currentSite) OR @position = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @virtualServer = ISNULL(SUBSTRING(@currentSite, 0, @position + 1), '')
	IF @virtualServer = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @position = 0
	SET @desc = ''
	SET @position = CHARINDEX('|', @currentSite, 0)
	IF @position = LEN(@currentSite) OR @position = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @desc = ISNULL(SUBSTRING(@currentSite, @position +1, 1024), '')
	SET @currentSite = ISNULL(SUBSTRING(@currentSite, 0,  @position), '')
	IF @desc = '' OR @currentSite = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Form the File Name as required
	SET @currentFileName = @dataType + '\' + @virtualServer + @delim + @currentSite + @delim + @desc + @delim + ' ' + @delim + ' \' + @placeHolder
	INSERT INTO APP_ScFilterFile(componentNameId,	type,		fileName,
								  created,			modified)
	VALUES						(@subclientId,		1,			@currentFileName,
								 @nowTime,			0)
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Form the File Name as required
	SET @currentFileName = @virtualServer + @delim + @currentSite + @delim + @desc + @delim + ' ' + @delim + ' \' + @placeHolder
	-- Remove from Default
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId = @defSubclientId AND attrType = 115 AND attrName = @currentFileName
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Check if already exists
	IF	(SELECT COUNT(*) FROM APP_SubClientProp
		 WHERE attrName = @currentFileName AND modified = 0 AND componentNameId IN (SELECT id FROM APP_Application
																				    WHERE backupSet = @backupSetId AND subclientStatus & 0x4 = 0)) <> 0
	BEGIN
		PRINT 'Skipping Site Content as it is part of another subclient.'
		FETCH GetSubclientContent INTO @currentSite
		CONTINUE
	END
	INSERT INTO APP_SubClientProp	(componentNameId,	attrName,			attrType,
									 attrVal,			created,			modified )
	VALUES							(@subclientId,		@currentFileName,	115,
									 @attrVal,			@nowTime,			0)
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	PRINT 'Added Content ['+@currentSite+'].'
	FETCH GetSubclientContent INTO @currentSite
END
---------------------------------------------------
TRANS_EXIT:
CLOSE GetSubclientContent
DEALLOCATE GetSubclientContent
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
	--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ARGS_ERROR:
 DROP TABLE #tempfile
 print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSPDBSubclientContent')
	delete from GxQscripts where name = 'QS_SetSPDBSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSPDBSubclientContent')
	delete from GXDBVersions where aliasname = 'QS_SetSPDBSubclientContent'
GO

insert into GXDBVersions values(2, 'QS_SetSPDBSubclientContent',  '00000000000000000000', 'QS_SetSPDBSubclientContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSPDBSubclientContent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSPDBSubclientContent.sql -si client_name -si subclient_name -si content_file_name
'
 + CHAR(10) + '--   script_name : SetSPDBSubclientContent'
)
GO

