

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSLAExclusionForSubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSLAExclusionForSubclients <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSLAExclusionForSubclients')
	drop procedure QS_SetSLAExclusionForSubclients
IF EXISTS (select * from GxQscripts where name='QS_SetSLAExclusionForSubclients')
	delete from GxQscripts where name = 'QS_SetSLAExclusionForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSLAExclusionForSubclients')
	delete from GXDBVersions where aliasname = 'QS_SetSLAExclusionForSubclients'
GO
print '... Creating Procedure: QS_SetSLAExclusionForSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSLAExclusionForSubclients
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- This is the script that read App IDs from 'C:\temp\ExcludeSubclientsFromSLA.txt'
-- Then enable os disable 'Exclude From SLA' property for the subclients
-- Stored Procedure Inputs
  @FileName NVARCHAR(1024),
  @Opt NVARCHAR(10)
AS
Set NOCOUNT ON
DECLARE @SQLString NVARCHAR(MAX)
DECLARE @lastError integer
SET     @lastError = 0									-- Be optimistic
DECLARE @localErrorMsg varchar(512)
SET	@localErrorMsg ='Error Encountered when running script.'
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'QS_SetSLAExclusionForSubclients'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
SET @FileName = LTRIM(RTRIM(@FileName))
IF @FileName = @NoParameter OR @FileName = '' OR @Opt NOT IN ('Exclude', 'Include')
BEGIN
		SET @localErrorMsg = 'Incorrect input parameters'
		Set @lastError = 1
		goto ARGS_ERROR
END
IF OBJECT_ID('tempdb..#Subclients') IS NOT NULL
	DROP TABLE #Subclients
CREATE TABLE #Subclients (
AppId VARCHAR(32),
ClientName NVARCHAR(255),
AppTypeName VARCHAR(255),
InstanceName NVARCHAR(512),
BackupsetName NVARCHAR(128),
SubclientName NVARCHAR(128),
ClientExcluded VARCHAR(32),
SubclientExcluded VARCHAR(32)
)
BEGIN TRY
SET @SQLString = N'BULK INSERT #Subclients FROM ''' + @FileName + ''' WITH (FIELDTERMINATOR = ''\t'', ROWTERMINATOR = ''\r\n'')'
EXEC sp_executesql @SQLString
END TRY
BEGIN CATCH
END CATCH
IF NOT EXISTS (SELECT * FROM #Subclients) --May be something wrong with ROWTERMINATOR. Try with another row terminator
BEGIN
	BEGIN TRY
		SET @SQLString = N'BULK INSERT #Subclients FROM ''' + @FileName + ''' WITH (FIELDTERMINATOR = ''\t'', ROWTERMINATOR = ''\n'')'
		EXEC sp_executesql @SQLString
	END TRY
	BEGIN CATCH
	END CATCH
END
IF NOT EXISTS (SELECT * FROM #Subclients)
BEGIN
		SET @localErrorMsg = 'There is no subclient information in the input file'
		Set @lastError = 2
		goto ARGS_ERROR
END
IF OBJECT_ID('tempdb..#AppIDs') IS NOT NULL
	DROP TABLE #AppIDs
CREATE TABLE #AppIDs (appId INT)
INSERT	INTO #AppIDs
SELECT	CAST(AppId AS INT)
FROM	#Subclients
DROP TABLE #Subclients
DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
IF (@Opt = 'Exclude')
BEGIN
	DELETE	#AppIDs
	FROM	APP_SubClientProp SCP
	WHERE	appId = componentNameId AND attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0
	UPDATE	APP_SubClientProp SET modified = @now
	FROM	#AppIDs A
	WHERE	appId = componentNameId AND attrName = 'Exclude From SLA' AND attrVal = '0' AND modified = 0
	INSERT	INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT	appId, 'Exclude From SLA', 7, '1', @now, 0, 0
	FROM	#AppIDs
END
ELSE IF (@Opt = 'Include')
BEGIN
	DELETE	#AppIDs
	WHERE	appId NOT IN (
	SELECT componentNameId
	FROM	APP_SubClientProp SCP
	WHERE	appId = componentNameId AND attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0)
	UPDATE	APP_SubClientProp SET modified = @now
	FROM	#AppIDs A
	WHERE	appId = componentNameId AND attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0
	INSERT	INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT	appId, 'Exclude From SLA', 7, '0', @now, 0, 0
	FROM	#AppIDs
END
DROP TABLE #AppIDs
SET NOCOUNT OFF
ARGS_ERROR:
	Print ''
	PRINT @scriptName + ' completed at ' + Convert(varchar(60), getdate()) + '. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSLAExclusionForSubclients')
	delete from GxQscripts where name = 'QS_SetSLAExclusionForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSLAExclusionForSubclients')
	delete from GXDBVersions where aliasname = 'QS_SetSLAExclusionForSubclients'
GO

insert into GXDBVersions values(2, 'QS_SetSLAExclusionForSubclients',  '00000000000000000000', 'QS_SetSLAExclusionForSubclients', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSLAExclusionForSubclients',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	Modify the ''Exclude From SLA'' property for the clients and subclients from an input file. The input file can be created using QS_ListSLAExclusionForSubclients.
'
 + CHAR(10) + '-- 	script_name: QS_SetSLAExclusionForSubclients'
 + CHAR(10) + '-- 	usage: qoperation execscript -sn QS_SetSLAExclusionForSubclients -si FullFilePath -si [Exclude/Include]'
 + CHAR(10) + '-- 	Command to set ''Exclude From SLA'' property: qoperation execscript -sn QS_SetSLAExclusionForSubclients -si "c:\temp\sla.txt" -si Exclude'
 + CHAR(10) + '-- 	Command to remove ''Exclude From SLA'' property: qoperation execscript -sn QS_SetSLAExclusionForSubclients -si "c:\temp\sla.txt" -si Include'
)
GO

