

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetRetentionForUserDeletedItems.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetRetentionForUserDeletedItems.sp,v $ $Id: QS_SetRetentionForUserDeletedItems.sp,v 1.4.40.3 2018/05/08 15:17:05 anarde Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetRetentionForUserDeletedItems <<<'

IF EXISTS (select * from sysobjects where name='QS_SetRetentionForUserDeletedItems')
	drop procedure QS_SetRetentionForUserDeletedItems
IF EXISTS (select * from GxQscripts where name='QS_SetRetentionForUserDeletedItems')
	delete from GxQscripts where name = 'QS_SetRetentionForUserDeletedItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetRetentionForUserDeletedItems')
	delete from GXDBVersions where aliasname = 'QS_SetRetentionForUserDeletedItems'
GO
print '... Creating Procedure: QS_SetRetentionForUserDeletedItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetRetentionForUserDeletedItems
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @clientGroupName NVARCHAR(MAX) = '',
  @retentionType NVARCHAR(MAX) = '',
  @retentionDays INT = 0
AS
Set NOCOUNT ON
DECLARE @scriptName NVARCHAR(MAX) = N''
SET @scriptName = N'SetRetentionForUserDeletedItems'
DECLARE @lastError integer
SET @lastError = 0
DECLARE @localErrorMsg nvarchar(1024)
SET @localErrorMsg = ''
DECLARE @clientGroupId INT
DECLARE @appIDs TABLE(subclientId INT)
DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
SET @clientGroupId = (ISNULL((SELECT id FROM APP_ClientGroup WHERE name = @clientGroupName), 0))
IF @clientGroupName = '' OR @clientGroupName IS NULL
BEGIN
	SET @lastError = 1
    SET @localErrorMsg = 'Please pass client group name.'
 	GOTO ERROR_EXIT
END
IF @retentionType NOT IN ('Immediately', 'Days', 'Never')
BEGIN
	SET @lastError = 1
    SET @localErrorMsg = 'Please pass valid retention option.'
 	GOTO ERROR_EXIT
END
IF @retentionType = 'Days' AND @retentionDays <= 0
BEGIN
	SET @lastError = 1
    SET @localErrorMsg = 'Please pass proper retention value in days.'
 	GOTO ERROR_EXIT
END
ELSE IF @retentionType = 'Never'
BEGIN
	SET @retentionDays = -1
END
ELSE IF @retentionType = 'Immediately'
BEGIN
	SET @retentionDays = 0
END
-- Invalid client group Id
IF @clientGroupId = 0
BEGIN
	SET @lastError = 1
    SET @localErrorMsg = 'Invalid client group name passed.'
 	GOTO ERROR_EXIT
END
BEGIN TRAN
BEGIN TRY
	-- Get all non turbo FS subclients belonging to given client group
	INSERT INTO @appIDs
	SELECT DISTINCT APP.id
	FROM APP_Application APP
	INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = @clientGroupId AND CGA.clientId = APP.clientId -- Belonging to the given client group
	LEFT OUTER JOIN APP_SubClientProp SPROP ON APP.id = SPROP.componentNameId AND SPROP.attrName = N'First Turbo Job Id' AND SPROP.modified = 0
	LEFT OUTER JOIN APP_SubClientProp SPROP2 ON APP.id = SPROP2.componentNameId AND SPROP2.attrName = N'DDB Backup' AND SPROP2.modified = 0
	WHERE APP.appTypeId IN (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) -- FS apptypes only
	AND APP.subclientStatus & 30214 = 0 --(CV_STATUS_DELETED | CV_STATUS_DUMMY | CV_STATUS_ERASE_BACKUP | CV_STATUS_REFCOPY_SUB | CV_STATUS_EDGEDRIVE_SUB)
	AND SPROP.attrVal IS NULL -- Subclients do not have turbo job.
	AND (SPROP2.attrVal IS NULL OR SPROP.attrVal = '0')
	-- Invalidate old properties first if they exist
	UPDATE APP_SubClientProp
	SET modified = @currentTime
	WHERE componentNameId IN (SELECT subclientId FROM @appIDs)
	AND attrName IN (N'Keep items past their expiration', N'Days to keep items past their expiration')
	ANd modified = 0
	-- Insert new property
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT subclientId, 'Days to keep items past their expiration', 7, @retentionDays, @currentTime, 0, 0
	FROM @appIDs
	IF @retentionDays = -1
	BEGIN
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		SELECT subclientId, 'Keep items past their expiration', 2, 0, @currentTime, 0, 0
		FROM @appIDs
	END
END TRY
BEGIN CATCH
BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
	SET @lastError = ERROR_NUMBER()
    SET @localErrorMsg = 'Problems updating retention for subclients. ' +ERROR_MESSAGE()
 	GOTO ERROR_EXIT
END
END CATCH
if @lastError = 0
	COMMIT TRAN
	ERROR_EXIT:
     	-- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+ Convert(varchar(2),@lastError) +').'
if @lastError <> 0
     	Raiserror(@localErrorMsg,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
     				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetRetentionForUserDeletedItems')
	delete from GxQscripts where name = 'QS_SetRetentionForUserDeletedItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetRetentionForUserDeletedItems')
	delete from GXDBVersions where aliasname = 'QS_SetRetentionForUserDeletedItems'
GO

insert into GXDBVersions values(2, 'QS_SetRetentionForUserDeletedItems',  '00010004004000030000', 'QS_SetRetentionForUserDeletedItems', '00010004004000030000')
GO

insert into GxQscripts values(2,'QS_SetRetentionForUserDeletedItems',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetRetentionForUserDeletedItems.sql -si ''<ClientGroupName>''  -si ''<RetentionOption>'' -si ''<RetentionValueInDays''
'
 + CHAR(10) + '-- 	script_name: SetRetentionForUserDeletedItems.'
 + CHAR(10) + '-- 	Sets the retention value in days for all FS subclients under that client group.'
)
GO

