

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetReplicationSearchEngine.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetReplicationSearchEngine <<<'

IF EXISTS (select * from sysobjects where name='QS_SetReplicationSearchEngine')
	drop procedure QS_SetReplicationSearchEngine
IF EXISTS (select * from GxQscripts where name='QS_SetReplicationSearchEngine')
	delete from GxQscripts where name = 'QS_SetReplicationSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetReplicationSearchEngine')
	delete from GXDBVersions where aliasname = 'QS_SetReplicationSearchEngine'
GO
print '... Creating Procedure: QS_SetReplicationSearchEngine'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetReplicationSearchEngine
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_originalSearchEngine nvarchar(2048) = N'',
  @i_replicatedSearchEngine nvarchar(2048) =N'',
  @i_authCode NVARCHAR(64) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetReplicationSearchEngine'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @origCloudId		INTEGER = 0
DECLARE @repCloudId			INTEGER = 0
DECLARE @nowTime INT
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @CommCellNumber		INTEGER = 0
DECLARE @Authenticate		INTEGER = 0
-----------------------invalid parameters------------------------------
IF(@i_originalSearchEngine = @NoParameter OR @i_replicatedSearchEngine = @NoParameter OR @i_authCode = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of Search engines---------------------
SELECT @origCloudId = id from APP_ComponentProp (nolock) where stringval = @i_originalSearchEngine
IF @origCloudId = 0
BEGIN
	SET @errorString = N'Wrong original search engine name ['+ @i_originalSearchEngine +'] is provided.'
	SET @errorCode = 2
	GOTO SCRIPT_EXIT
END
SELECT @repCloudId = id from APP_ComponentProp (nolock) where stringval = @i_replicatedSearchEngine
IF @repCloudId = 0
BEGIN
	SET @errorString = N'Wrong replicated search engine name ['+ @i_replicatedSearchEngine +'] is provided.'
	SET @errorCode = 3
	GOTO SCRIPT_EXIT
END
SELECT @CommCellNumber = number from APP_CommCell where id = 2
SET @Authenticate = CONVERT(INTEGER, @i_authCode)
IF ((CHECKSUM(HASHBYTES('SHA1', '<' + CAST(@CommCellNumber AS VARCHAR(100)) + '><' + CAST(@i_originalSearchEngine AS VARCHAR(100)) + '><' + CAST(@i_replicatedSearchEngine AS VARCHAR(100)) + '><' + CAST(@CommCellNumber AS VARCHAR(100)) + '><COMMVAULT>')) & 2147483646) <> @Authenticate)
BEGIN
	SET @errorString = N'Wrong Authorization code passed [' + @i_authCode + '].'
	SET @errorCode = 4
	GOTO SCRIPT_EXIT
END
-----------------set conent indexing property for replication enigne--------------
BEGIN TRAN
	BEGIN TRY
IF NOT EXISTS (SELECT 1 FROM  APP_ComponentProp (nolock)  WHERE  componentType = 2 AND componentId = @origCloudId
AND propertyTypeId = 1039 AND longVal= @repCloudId)
		INSERT INTO APP_ComponentProp (componentType, componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created, modified)
VALUES (2 , @origCloudId, 1039, 7, @repCloudId, 0, '', @nowTime, 0)
	END TRY
	BEGIN CATCH
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO SCRIPT_EXIT
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_originalSearchEngine + ', '+@i_replicatedSearchEngine + ', ' + @i_authCode
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetReplicationSearchEngine')
	delete from GxQscripts where name = 'QS_SetReplicationSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetReplicationSearchEngine')
	delete from GXDBVersions where aliasname = 'QS_SetReplicationSearchEngine'
GO

insert into GXDBVersions values(2, 'QS_SetReplicationSearchEngine',  '00000000000000000000', 'QS_SetReplicationSearchEngine', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetReplicationSearchEngine',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetReplicationSearchEngine.sql -si ''OriginalSearchEngine'' -si ''ReplicatedSearchEngine'' -si AuthenticationCode
'
 + CHAR(10) + '-- 	script_name: QS_SetReplicationSearchEngine'
 + CHAR(10) + '-- 	 Qscript to set replicated search engine.'
 + CHAR(10) + '-- 	OriginalSearchEngine - specifies the original search engine name'
 + CHAR(10) + '-- 	ReplicatedSearchEngine - specifies the replicated search engine name'
 + CHAR(10) + '-- 	AuthenticationCode - Authentication Code.'
)
GO

