

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetReadMeServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetReadMeServer.sp,v $ $Id: QS_SetReadMeServer.sp,v 1.1.2.5 2018/03/27 09:08:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetReadMeServer <<<'

IF EXISTS (select * from sysobjects where name='QS_SetReadMeServer')
	drop procedure QS_SetReadMeServer
IF EXISTS (select * from GxQscripts where name='QS_SetReadMeServer')
	delete from GxQscripts where name = 'QS_SetReadMeServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetReadMeServer')
	delete from GXDBVersions where aliasname = 'QS_SetReadMeServer'
GO
print '... Creating Procedure: QS_SetReadMeServer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetReadMeServer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Run command below to see help on usage of this script.
  @clientName nvarchar(255) = '',
  @PackagesSavedBeforeEpochTime int = 0
AS
--CONVENIENCE DEFS
DECLARE @NoParams AS nvarchar(3)
DECLARE @ErrorCode AS int
DECLARE @ErrorString AS nvarchar(1000)
DECLARE @ScriptName AS nvarchar(100)
DECLARE @nowtime as int
DECLARE @ClientID AS int
DECLARE @RepositoryId AS int
SET @NoParams = ''
SET @ErrorCode = 0
SET @ErrorString = N'Succeeded'
SET @ScriptName = N'SetReadMeServer'
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
--
-- Check whether mandatory parameter is passed
IF (@clientName = @NoParams)
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Client name input not specified. Refer to usage of the script'
	GOTO ExitLine
END
-- validate client name
SELECT @ClientID = Id FROM APP_CLIENT
WHERE Name = @clientName
IF ISNULL(@ClientID, 0) = 0
BEGIN
	SET @ErrorCode = 2
	SET @ErrorString = 'Error. Invalid client name specified: ' + @clientName
	GOTO ExitLine
END
-- find repository for given client
SELECT @RepositoryId = MAX(PackageRepositoryId) FROM DCPackageRepository
WHERE clientid = @ClientID
-- return error if no repository exists for given client
IF ISNULL(@RepositoryId, 0) = 0
BEGIN
	SET @ErrorCode = 3
	SET @ErrorString = 'Error. No package repository found for specified web server client name: ' + @clientName + ''
	GOTO ExitLine
END
-- if we are here, that means we are successful
IF @PackagesSavedBeforeEpochTime > 0
BEGIN
	UPDATE DCPackagePlatform SET ReadMeRepositoryId = @RepositoryId
	WHERE dbo.GetUnixTime(ISNULL(ModifiedTime, CreateTime)) < @PackagesSavedBeforeEpochTime
END
ELSE
BEGIN
	UPDATE DCPackagePlatform SET ReadMeRepositoryId = @RepositoryId
END
-- we are almost done
ExitLine:
	-- raise error for failures..
    IF @ErrorCode <> 0
	BEGIN
		Raiserror(@ErrorString,
				15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetReadMeServer')
	delete from GxQscripts where name = 'QS_SetReadMeServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetReadMeServer')
	delete from GXDBVersions where aliasname = 'QS_SetReadMeServer'
GO

insert into GXDBVersions values(2, 'QS_SetReadMeServer',  '00010001000200050000', 'QS_SetReadMeServer', '00010001000200050000')
GO

insert into GxQscripts values(2,'QS_SetReadMeServer',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn SetReadMeServer.sql -si ClientNameOfWebServer 
'
 + CHAR(10) + ' OR
'
 + CHAR(10) + ' qoperation execscript -sn SetReadMeServer.sql -si ClientNameOfWebServer -si FixPackagesSavedBeforeEpochTime
'
 + CHAR(10) + '-- 	script_name: SetReadMeServer'
 + CHAR(10) + '-- 	ClientNameOfWebServer: Client name of web server machine, which has readme files, and configured as pacakge repository.'
 + CHAR(10) + '-- 	FixPackagesSavedBeforeEpochTime: Optional. If supplied, packages saved before this time only will be updated.'
 + CHAR(10) + '-- 	Useful for upgraded CommServ where upgrade process did not set right readme repository on download center packages.'
)
GO

