

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetOracleInstanceProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetOracleInstanceProperties.sp,v $ $Id: QS_SetOracleInstanceProperties.sp,v 1.3.60.2 2018/03/27 08:15:53 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetOracleInstanceProperties <<<'

IF EXISTS (select * from sysobjects where name='QS_SetOracleInstanceProperties')
	drop procedure QS_SetOracleInstanceProperties
IF EXISTS (select * from GxQscripts where name='QS_SetOracleInstanceProperties')
	delete from GxQscripts where name = 'QS_SetOracleInstanceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleInstanceProperties')
	delete from GXDBVersions where aliasname = 'QS_SetOracleInstanceProperties'
GO
print '... Creating Procedure: QS_SetOracleInstanceProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetOracleInstanceProperties
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = '',
  @PARAM5 nvarchar(1024) = '',
  @PARAM6 INT = 1
AS
Set NOCOUNT ON
DECLARE @clientName nvarchar(1024)
DECLARE @dataAgentName nvarchar(1024)
DECLARE @instanceName nvarchar(1024)
DECLARE @propName nvarchar(1024)
DECLARE @propType int
DECLARE @propvalue nvarchar(max)
DECLARE @scriptName nvarchar(128)
SET @clientName = @PARAM1
SET @dataAgentName = @PARAM2
SET @instanceName = @PARAM3
SET @propName =  @PARAM4
SET @propvalue =  @PARAM5
SET @propType =  @PARAM6
SET @scriptName = 'SetOracleInstanceProperties'
DECLARE @lastError integer
SET @lastError = 0
DECLARE @localErrorMsg nvarchar(1024)
SET @localErrorMsg = ''
DECLARE @noParameter varchar(4)
SET     @noParameter            ='%'
SET     @noParameter            =@noParameter + 's'
IF @clientname = @noParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
IF @instanceName = @noParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Instance Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
IF @dataAgentName = @noParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
SELECT @ClientId = id FROM APP_Client WHERE name = @clientName AND status & 2 <> 2 AND status & 4 <> 4
      IF(@ClientId = 0 OR @ClientId IS null)
      BEGIN
            SET @lastError = 1
            SET @localErrorMsg = 'Error. Client ['+ @clientName + '] does not exist'
            GOTO ERROR_EXIT
      END
SELECT @AppTypeId =
        CASE @dataAgentName
                  WHEN 'Q_ORACLE'THEN 22
                  WHEN 'Q_MSSQL'THEN 81
                  WHEN 'Q_SYBASE'THEN 5
                  WHEN 'Q_ORACLE_RAC'THEN 80
                  WHEN 'Q_MYSQL'THEN 104
                  WHEN 'Q_SAP_ORADB'THEN 61
            ELSE 0
            END
      IF((SELECT count(id) FROM app_idaname WHERE clientId = @ClientId AND AppTypeId = @AppTypeId AND status & 2 <> 2 AND status & 4 <> 4) < 1)
            SET @AppTypeId = 0
      IF(@AppTypeId = 0 OR @AppTypeId IS null)
      BEGIN
            SET @lastError = 1
            SET @localErrorMsg = 'Error. AppType ['+ @dataAgentName + '] does not exist on Client ['+ @clientName+'].'
            GOTO ERROR_EXIT
      END
SELECT @InstanceId= APP_InstanceName.id from APP_InstanceName
join APP_Application
on APP_Application.clientId = @ClientId and APP_Application.instance =APP_InstanceName.id  and appTypeId = @AppTypeId and subclientStatus = 8
where name = @instanceName
      IF(@InstanceId = 0 OR @InstanceId IS null)
      BEGIN
            SET @lastError = 1
            SET @localErrorMsg = 'Error. instance ['+ @instanceName + '] does not exist'
            GOTO ERROR_EXIT
      END
BEGIN TRAN
BEGIN TRY
update APP_InstanceProp
set attrVal = @propvalue
where attrName = @propName
and componentNameId = @InstanceId
and modified = 0
if @@error = 0 and @@ROWCOUNT = 0
BEGIN
	insert into APP_InstanceProp (componentNameId, attrName, attrType, attrVal, created, modified)
				 values (@InstanceId, @propName, @propType, @propvalue, dbo.getunixtime(GETUTCDATE()), 0)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN
	SET @lastError = ERROR_NUMBER()
        SET @localErrorMsg = 'Problems updating Instance properties ' +ERROR_MESSAGE()
 	GOTO ERROR_EXIT
END
END CATCH
if @lastError = 0
	COMMIT TRAN
	ERROR_EXIT:
     	-- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+ Convert(varchar(2),@lastError) +').'
if @lastError <> 0
     	Raiserror(@localErrorMsg,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
     				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetOracleInstanceProperties')
	delete from GxQscripts where name = 'QS_SetOracleInstanceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleInstanceProperties')
	delete from GXDBVersions where aliasname = 'QS_SetOracleInstanceProperties'
GO

insert into GXDBVersions values(2, 'QS_SetOracleInstanceProperties',  '00010003006000020000', 'QS_SetOracleInstanceProperties', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_SetOracleInstanceProperties',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetOracleInstanceProperties.sql -si ''clientname''  -si ''Q_ORACLE''  -si  ''instancename''  -si instanceprop  -si instancevalue -si atttype
'
 + CHAR(10) + '-- 	script_name: SetOracleInstanceProperties.'
 + CHAR(10) + '-- 	Sets specified instance property to given value under the given client, application type, instance'
)
GO

