

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetOracleCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetOraclecredentials <<<'

IF EXISTS (select * from sysobjects where name='QS_SetOraclecredentials')
	drop procedure QS_SetOraclecredentials
IF EXISTS (select * from GxQscripts where name='QS_SetOraclecredentials')
	delete from GxQscripts where name = 'QS_SetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_SetOraclecredentials'
GO
print '... Creating Procedure: QS_SetOraclecredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetOraclecredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @PARAM2 varchar(512) = '%s',
  @PARAM3 varchar(512) = '%s',
  @PARAM4 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--DECLARE @PARAM3     	varchar(512)
--DECLARE @PARAM4     	varchar(512)
DECLARE @HIDEPARAM3 	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- Type (Catalog, DB, (user) impersonate
--SET @PARAM3 = '%s'					-- encryptedpassworrd
--SET @PARAM4 = '%s'					-- username (optional)
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @PARAM1 =	'c=TESTRAC'
--SET @PARAM1 =	'allclients'
--SET @PARAM2 =	't=RAC'
--SET @PARAM3 =	'BadPassword'
--SET @PARAM4 =	'GALAXYLAB\administrator'
SET		@HIDEPARAM3		=@PARAM3				-- COMMENT OUT THE NEXT LINE SO THAT PASSWORD IS DISPLAYED!
SET		@HIDEPARAM3		='XXXXXXX'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetOraclecredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
-----
DECLARE @CV_ORACLE_CATALOG_CONNECT		varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT		= 'Catalog Connect'
DECLARE @CV_ORACLE_CATALOG_CONNECT_PWD	varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT_PWD	= 'Catalog Connect Password'
-----
DECLARE @CV_ORACLE_SQL_CONNECT			varchar(40)
SET		@CV_ORACLE_SQL_CONNECT			= 'SQL Connect'
DECLARE @CV_ORACLE_SQL_CONNECT_PWD		varchar(40)
SET		@CV_ORACLE_SQL_CONNECT_PWD		= 'SQL Connect Password'
-----
DECLARE @CV_ORACLE_DOMAIN_NAME			varchar(40)
SET		@CV_ORACLE_DOMAIN_NAME			= 'Domain Name'
DECLARE @CV_ORACLE_DOMAIN_USER_PASSWORD	varchar(40)
SET		@CV_ORACLE_DOMAIN_USER_PASSWORD	= 'Domain User Password'
DECLARE	@CV_ORACLE_USER_NAME			varchar(40)
SET		@CV_ORACLE_USER_NAME			='Oracle User'
DECLARE @MAX_ENTITY_SIZE smallint
SET @MAX_ENTITY_SIZE = 100
-----
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @domainName				nvarchar(1024)
SET		@domainName				=''
DECLARE @useConnect				nvarchar(40)
SET		@useConnect				=''
DECLARE @usePassword			nvarchar(40)
SET		@usePassword			=''
DECLARE	@isOracleRAC			integer
SET		@isOracleRAC			= 0
DECLARE @SlashPosn				int
DECLARE @Domain					nvarchar(1024)
DECLARE @winOStype int = 0
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---       CREDENTIALS TYPE			---
-- Type is one of:					---
--   Catalog, DB, user impersonate  ---
--   or Oracle RAC					---
---------------------------------------
IF @PARAM2 = 't=Catalog'
BEGIN
	SET		@useConnect				=@CV_ORACLE_CATALOG_CONNECT
	SET		@usePassword			=@CV_ORACLE_CATALOG_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=DB'
BEGIN
	SET		@useConnect				=@CV_ORACLE_SQL_CONNECT
	SET		@usePassword			=@CV_ORACLE_SQL_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=Impersonate'
BEGIN
--	SET		@useConnect				=@CV_ORACLE_DOMAIN_NAME
	SET		@useConnect				=@CV_ORACLE_USER_NAME
	SET		@usePassword			=@CV_ORACLE_DOMAIN_USER_PASSWORD
	SET		@winOStype				=1
END
ELSE IF @PARAM2 = 't=RAC'
	SET		@isOracleRAC = 1
-----
ELSE
BEGIN
	SET @localErrorMsg	='Error. Parameter 2 must be specified as t=Catalog|DB|Impersonate|RAC.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
---------------------------------------
---  ENCRYPTED PASSWORD				---
---------------------------------------
IF @PARAM3 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Encrypted password must be specified as parameter3.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @Password = @PARAM3
---------------------------------------
---  USERNAME (OPTIONAL)				---
---------------------------------------
IF @PARAM4 = @NoParameter
	SET @USERNAME=''
ELSE IF LEN(@PARAM4 ) > @MAX_ENTITY_SIZE
BEGIN
	SET @localErrorMsg = 'Error. User name cannot be more than ' + CAST(@MAX_ENTITY_SIZE AS VARCHAR(3)) + ' characters.'
	SET @lastError = 1
	goto ARGS_ERROR
END
ELSE
BEGIN
IF @PARAM2 = 't=Impersonate'
BEGIN
	SET	@SlashPosn  = CHARINDEX('\', @PARAM4)
	IF @SlashPosn <> 0
	BEGIN
		SET @Domain		=SUBSTRING(@PARAM4, 1, @SLASHPOSN-1)
		SET @USERNAME	=SUBSTRING(@PARAM4, @SLASHPOSN+1, LEN(@PARAM4)-@SLASHPOSN)
--		select step='debug', domain=@Domain, userN=@USERNAME
	END
	ELSE
		SET @USERNAME = @PARAM4
END
ELSE
		SET @USERNAME = @PARAM4
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@PARAM2+', ' +REPLACE(@HIDEPARAM3, @NoParameter, '[]') +', ' +REPLACE(@PARAM4, @NoParameter, '[]')
         + ')'
IF @USERNAME =''
	PRINT '................. Username not specified. Existing Username(s) will be preserved.'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
DECLARE @instId int
DECLARE @instanceCur CURSOR
BEGIN TRAN
BEGIN TRY
	IF @IsOracleRAC = 0
	BEGIN
		IF object_id('tempdb.dbo.#tempInstancetbl') IS NOT null DROP TABLE #tempInstancetbl
		CREATE TABLE #tempInstancetbl (instanceId int)
		IF @winOStype = 0
		BEGIN
		INSERT into #tempInstancetbl
		SELECT distinct inst.id FROM APP_InstanceName inst JOIN APP_APPLICATION app ON  inst.id = app.instance WHERE appTypeId in (2, 22, 80) and inst.status & 16 = 0 and inst.status & 2048 = 0 and (clientId = @clientId or @clientId=0)
		END
		ELSE
		BEGIN
		INSERT into #tempInstancetbl
		SELECT distinct inst.id FROM APP_InstanceName inst JOIN APP_APPLICATION app ON  inst.id = app.instance JOIN APP_Client client on client.id = app.clientId  WHERE appTypeId in (2, 22, 80) and inst.status & 16 = 0 and inst.status & 2048 = 0 and (clientId = @clientId or @clientId=0) AND client.simOperatingSystemId in (select id from simOperatingSystem where Type = 'windows')
		END
		--IF @clientId = 0
		--BEGIN
			SET @instanceCur = CURSOR
			FOR (SELECT instanceId from #tempInstancetbl)
			OPEN @instanceCur
			FETCH NEXT FROM @instanceCur INTO @instId
			WHILE @@FETCH_STATUS = 0
			BEGIN
			--password
			IF EXISTS (select * from APP_InstanceProp where attrName = @usePassword and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @PASSWORD WHERE attrName = @usePassword AND modified = 0 and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @usePassword, 1, @PASSWORD, dbo.GetUnixTime (GetUTCdate()), 0)
			--userName
			IF @userName <> ''
			BEGIN
			IF EXISTS (select * from APP_InstanceProp where attrName = @useConnect and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @UserName WHERE attrName = @useConnect AND modified = 0  and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @useConnect, 1, @UserName, dbo.GetUnixTime (GetUTCdate()), 0)
			END
			IF @domain <> ''
			BEGIN
			IF EXISTS (select * from APP_InstanceProp where attrName = @CV_ORACLE_DOMAIN_NAME and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @domain WHERE attrName = @CV_ORACLE_DOMAIN_NAME AND modified = 0  and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @CV_ORACLE_DOMAIN_NAME, 1, @domain, dbo.GetUnixTime (GetUTCdate()), 0)
			END
			FETCH NEXT FROM @instanceCur INTO @instId
			END--END cursor fetch loop
			DEALLOCATE @instanceCur
	--	END
		GOTO ALL_DONE						-- DONE WITH NON-ORACLE RAC
	END
---- FOR ORACLE RAC, WILL UPDATE APP_ORACLERACINSTANCE TABLE WHERE INSTANCEid=INSTANCE OF ORACLE RAC INSTANCE DERIVED FROM
---- APP_APPLICATION TABLE.  Columns to be updated are InstanceOraUser and InstanceOraPasswd. For now, all RAC Instances for the
---- Chosen instance will be updated (all clients or under pseudo client).  Future will be able to select a particular one by name? or clientId?
	IF @clientId = 0
	BEGIN
--		SELECT step='debug before:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
		IF @userName <> ''
			UPDATE APP_OracleRACInstance
				SET InstanceOraUser = @USERNAME, InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
		ELSE
			UPDATE APP_OracleRACInstance
				SET InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
--		SELECT step='debug after:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
	END
	ELSE
	BEGIN
--		SELECT step='debug before:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
		IF @userName <> ''
			UPDATE APP_OracleRACInstance
				SET InstanceOraUser = @USERNAME, InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
		ELSE
			UPDATE APP_OracleRACInstance
				SET InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80and clientId=@clientId)
--		SELECT step='debug after:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
	END
END TRY
BEGIN CATCH
BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF object_id('tempdb.dbo.#tempInstancetbl') IS NOT null DROP TABLE #tempInstancetbl
IF (@lastError  = 0)
	commit   Tran
--	rollback Tran				-- For Debugging
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( '
		 +REPLACE(@PARAM1, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM2, @NoParameter, '[]') +', '
		 +REPLACE(@HIDEPARAM3, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM4, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetOracleCredentials')
	delete from GxQscripts where name = 'QS_SetOracleCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleCredentials')
	delete from GXDBVersions where aliasname = 'QS_SetOracleCredentials'
GO

insert into GXDBVersions values(2, 'QS_SetOracleCredentials',  '00000000000000000000', 'QS_SetOracleCredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetOracleCredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f setOraclecredentials -i c=clientName|allclients t=Catalog|DB|Impersonate|RAC	encryptedpassword [username]
'
 + CHAR(10) + '--   script_name : SetOraclecredentials'
)
GO

