

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetOnPremiseStorageForCompany.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_SetOnPremiseStorageForCompany()
--  | Description:  Allows or denies on premise storage at company level
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetOnPremiseStorageForCompany.sp,v $ $Id: QS_SetOnPremiseStorageForCompany.sp,v 1.1.2.1 2018/09/29 21:31:58 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetOnPremiseStorageForCompany <<<'

IF EXISTS (select * from sysobjects where name='QS_SetOnPremiseStorageForCompany')
	drop procedure QS_SetOnPremiseStorageForCompany
IF EXISTS (select * from GxQscripts where name='QS_SetOnPremiseStorageForCompany')
	delete from GxQscripts where name = 'QS_SetOnPremiseStorageForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOnPremiseStorageForCompany')
	delete from GXDBVersions where aliasname = 'QS_SetOnPremiseStorageForCompany'
GO
print '... Creating Procedure: QS_SetOnPremiseStorageForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetOnPremiseStorageForCompany
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @companyName NVARCHAR(4000)
AS
SET NOCOUNT ON
DECLARE @errorCode				INTEGER
DECLARE @errorString			NVARCHAR(1024)
DECLARE @canManageProvider		INT
DECLARE @companyId				INT
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
	--INSERT/UPDATE Operation
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'Successful'
        -- USER VALIDATION
		--Existence of table and fetching of top 1 userId is done for safety measures
		IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		DECLARE @userId INT
		SET @userId = 0
		SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
		IF @userId = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		--Input validation and assignation--
		--1. Null and empty check
		IF(@companyName IS NULL OR @companyName = N'' )
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Invalid companyName value. Please see description'
			GOTO SCRIPT_EXIT
		END
		SET @companyId = ISNULL((SELECT id FROM UMDSProviders WHERE domainName = RTRIM(LTRIM(@companyName)) AND serviceType = 5),0)
		--3. Checking if user has permissions to change company settings
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManageProvider OUTPUT, 61, @companyId
		IF @canManageProvider <> 1
		BEGIN
			set @errorCode = 4
			set @errorString = 'Logged in user does not have rights to modify settings for Company.'
			GOTO SCRIPT_EXIT
		END
		-- Its a one time setting as mentioned in the description. Should not be allowed to change
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @companyId AND attrName = 'AllowOnPremiseStorage')
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'AllowOnPremiseStorage', 1, 1, @nowTime, 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
PRINT ' completed at '
            + Convert(varchar(60), getdate())
            + ' with Parameters: ['+@companyName+']. Execution('+ @errorString +').'
IF @errorCode <> 0
BEGIN
  RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetOnPremiseStorageForCompany')
	delete from GxQscripts where name = 'QS_SetOnPremiseStorageForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOnPremiseStorageForCompany')
	delete from GXDBVersions where aliasname = 'QS_SetOnPremiseStorageForCompany'
GO

insert into GXDBVersions values(2, 'QS_SetOnPremiseStorageForCompany',  '00010001000200010000', 'QS_SetOnPremiseStorageForCompany', '00010001000200010000')
GO

insert into GxQscripts values(2+8,'QS_SetOnPremiseStorageForCompany',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    To enable onPremiseStorage on company whose name is myCompany 
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_SetOnPremiseStorageForCompany.sql -si myCompany
'
)
GO

