

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNextJobIdCounter.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_SetNextJobIdCounter
--  | Description:  Sets the Job counter in GxCounter table. Prevents clash of
--	|				JobIds when a tape import is run after DR restore.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetNextJobIdCounter.sp,v $ $Id: QS_SetNextJobIdCounter.sp,v 1.5.54.2 2018/03/20 00:13:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNextJobIdCounter <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNextJobIdCounter')
	drop procedure QS_SetNextJobIdCounter
IF EXISTS (select * from GxQscripts where name='QS_SetNextJobIdCounter')
	delete from GxQscripts where name = 'QS_SetNextJobIdCounter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNextJobIdCounter')
	delete from GXDBVersions where aliasname = 'QS_SetNextJobIdCounter'
GO
print '... Creating Procedure: QS_SetNextJobIdCounter'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetNextJobIdCounter
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_PercentIncrease INTEGER
AS
-- Increase the job id counter by nearest next 1000 after increase by the input percent
	DECLARE @i_CurrentJobCounter INTEGER SET @i_CurrentJobCounter = 0
	DECLARE @i_IncreasedByPercent INTEGER SET @i_IncreasedByPercent = 0
	DECLARE @i_JobCounterRounded	INTEGER SET @i_JobCounterRounded = 0
	DECLARE @i_ChunkCounterRounded	INTEGER SET @i_ChunkCounterRounded = 0
	SELECT @i_CurrentJobCounter = IDENT_CURRENT('GxJobCounter')
	SET @i_IncreasedByPercent = @i_CurrentJobCounter + (@i_CurrentJobCounter * (@i_PercentIncrease / 100))
	SET @i_JobCounterRounded = ((@i_IncreasedByPercent / 1000) + 1) * 1000
	DECLARE @IdentInsQuery NVARCHAR(MAX)
	SET @IdentInsQuery = 'INSERT INTO GxJobCounter(jobId) VALUES(' + STR(@i_JobCounterRounded) + ')'
	EXEC SQLUtilIdentityInsert @IdentInsQuery, 'GxJobCounter'
	-- Increase chunk counter by 10 percent
	-- Chunk counters are increased by flat 10 percent
	DECLARE @i_CurrentChunkCounter INTEGER SET @i_CurrentChunkCounter = 0
	SELECT @i_CurrentChunkCounter = next_l
	FROM GXCounter
	WHERE name = 'Chunk_Counter'
	SET @i_IncreasedByPercent = @i_CurrentChunkCounter + (@i_CurrentChunkCounter / 10)
	SET @i_ChunkCounterRounded = ((@i_IncreasedByPercent / 1000) + 1) * 1000
	UPDATE GXCounter
	SET next_l = @i_ChunkCounterRounded
	WHERE name = 'Chunk_Counter'
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNextJobIdCounter')
	delete from GxQscripts where name = 'QS_SetNextJobIdCounter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNextJobIdCounter')
	delete from GXDBVersions where aliasname = 'QS_SetNextJobIdCounter'
GO

insert into GXDBVersions values(2, 'QS_SetNextJobIdCounter',  '00010005005400020000', 'QS_SetNextJobIdCounter', '00010005005400020000')
GO

insert into GxQscripts values(2,'QS_SetNextJobIdCounter',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNextJobIdCounter -si increase_by_percent
'
)
GO

