

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNetHostnameByID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetNetHostNameByID')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetNetHostNameByID <<<'
	drop procedure QS_SetNetHostNameByID
END
IF EXISTS (select * from GxQscripts where name='QS_SetNetHostNameByID')
	delete from GxQscripts where name = 'QS_SetNetHostNameByID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostNameByID')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostNameByID'
GO
print '... Creating Procedure: QS_SetNetHostNameByID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetNetHostNameByID
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientId varchar(1024) = '%s',
  @netHostName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientId varchar(1024)
--SET @clientId = '%s'
--DECLARE @netHostName varchar(1024)
--SET @netHostName = '%s'
--------------------------------------
--SET @clientId = 2
--SET @netHostName = 'spark'
--------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetNetHostNameByID'
DECLARE @propName varchar(32)
SET @propName  = 'NetHost Name'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @duplicateID			varchar(1024)
DECLARE @duplicateClient		varchar(1024)
--DECLARE @MAX_ENTITY_SIZE	smallint
--SET @MAX_ENTITY_SIZE = 100
----------- VAlidate inputs   -------------
if @clientId = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  ClientId was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @netHostName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  NetHostName for Client ['+ @clientId +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------- Check if client ID exists ---------------
if NOT EXISTS(select 1 from APP_Client C where C.id = @clientId)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientId + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------- Check for Duplicate netHostName ----------------
if EXISTS (Select 1 from APP_Client C where C.net_hostname = @netHostName)
BEGIN
	SET @duplicateID	 = (select C.id from APP_Client C where C.net_hostname = @netHostName)
	SET @duplicateClient = (select C.name from APP_Client C where C.net_hostname = @netHostName)
	SET @localErrorMsg = 'Error.  HostName already exists for clientId ['+ @duplicateID + '] and alias name ['+ @duplicateClient +']'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF(LEN(@netHostName) > 100 )
BEGIN
	SET @lastError = 1
SET @localErrorMsg = 'Error. Host name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
----------- Set netHostName  -------------
UPDATE APP_Client SET net_hostname = @netHostName WHERE id = @clientId
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: netHostName = ['
         + @netHostName
         + '], client = ['
         + @clientId
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNetHostnameByID')
	delete from GxQscripts where name = 'QS_SetNetHostnameByID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostnameByID')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostnameByID'
GO

insert into GXDBVersions values(2, 'QS_SetNetHostnameByID',  '00000000000000000000', 'QS_SetNetHostnameByID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNetHostnameByID',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNetHostNameByID -si clientID -si netHostName
'
 + CHAR(10) + '	Updates the client net hostname in the CommServe database. Use the clientID parameter to identify the client you want to update.
'
 + CHAR(10) + '	Note: Do not use this qscript if you need to update the client hostname in the client registry.
'
 + CHAR(10) + '	
'
 + CHAR(10) + '--   script_name : SetNetHostNameByID'
)
GO

