

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNetHostName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNetHostName <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNetHostName')
	drop procedure QS_SetNetHostName
IF EXISTS (select * from GxQscripts where name='QS_SetNetHostName')
	delete from GxQscripts where name = 'QS_SetNetHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostName')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostName'
GO
print '... Creating Procedure: QS_SetNetHostName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetNetHostName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @netHostName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
--DECLARE @netHostName varchar(1024)
--SET @netHostName = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
--------------------------------------
--SET @clientName  = 'bingo_cn'
--SET @netHostName = 'bingo.gp.cv.commvault.com'
--------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'SetNetHostName'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError	integer
DECLARE @localErrorMsg	varchar(512)
SET	@localErrorMsg	='Error Encountered when running script.'
SET     @lastError  = 0					-- Be optimistic
DECLARE @nowTime integer
SET @nowTime  = dbo.GetUnixTime (GetUTCdate())
----------- VAlidate inputs   -------------
if @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @netHostName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  NetHostName for Client ['+ @clientName +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------- Check if client exists ---------------
if NOT EXISTS(select 1 from APP_Client C where C.name like @clientNAme)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------- Check for Duplicate netHostName ----------------
DECLARE @duplicateName			varchar(1024)
if EXISTS (Select 1 from APP_Client C where C.net_hostname = @netHostName)
BEGIN
	SET @duplicateNAme	 = (select C.name from APP_Client C where C.net_hostname = @netHostName)
	SET @localErrorMsg = 'Error.  HostName ['+@netHostName +']already exists for client ['+ @duplicateName+ '].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF LEN(@netHostName ) > 100
BEGIN
	SET @lastError = 1
SET @localErrorMsg = 'Error. Host Name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
----------- Set netHostName  -------------
UPDATE APP_Client SET net_hostname = @netHostName, modified = @nowTime WHERE name like  @clientName
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
	 + ' with Parameters: netHostName = ['
         + @netHostName
         + '], client name = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNetHostName')
	delete from GxQscripts where name = 'QS_SetNetHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostName')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostName'
GO

insert into GXDBVersions values(2, 'QS_SetNetHostName',  '00000000000000000000', 'QS_SetNetHostName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNetHostName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNetHostName.sql -si clientName -si netHostName
'
 + CHAR(10) + '	Updates the client net hostname in the CommServe database. Use the clientName parameter to identify the client you want to update. 
'
 + CHAR(10) + '	Note: Do not use this qscript if you need to update the client hostname in the client registry.
'
 + CHAR(10) + '	
'
 + CHAR(10) + '--   script_name : SetNetHostName'
)
GO

