

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNasIDAProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNasIDAProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNasIDAProp')
	drop procedure QS_SetNasIDAProp
IF EXISTS (select * from GxQscripts where name='QS_SetNasIDAProp')
	delete from GxQscripts where name = 'QS_SetNasIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNasIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetNasIDAProp'
GO
print '... Creating Procedure: QS_SetNasIDAProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetNasIDAProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @clientName AS NVARCHAR(MAX) = '',
  @userName AS NVARCHAR(MAX) = '',
  @password AS NVARCHAR(MAX) = ''
AS
DECLARE @errorcode		AS	INT = 0
DECLARE @errorstring	AS	NVARCHAR(MAX) = 'Successful'
DECLARE @TRUE			AS	INT = 1
DECLARE @FALSE			AS	INT = 0
DECLARE @clientId		AS	INT = 0
DECLARE @idaId			AS	INT = 0
DECLARE @qs_resultTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
--Validate first parameter, client name
IF @clientName = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientName), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name[' + @clientName + '] not correct. Please give valid client name.'
			SET		@errorcode = 2
			GOTO	ARGS_ERROR
		END
		SET @idaId = ISNULL((SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = 13), 0)
		IF @idaId = 0
		BEGIN
			SET		@errorstring = 'Error: NAS IDA is not installed on client [' + @clientName + '].'
			SET		@errorcode = 3
			GOTO	ARGS_ERROR
		END
	END
--Validate second parameter, user name
IF @userName = ''
BEGIN
	SET @errorcode = 4
	SET @errorstring = 'Error: Second parameter user name is empty, please give user name.'
	GOTO ARGS_ERROR
END
--Validate third parameter, password
IF @password = ''
	BEGIN
		SET @errorcode = 5
		SET @errorstring = 'Error: Third parameter password is empty, please give password.'
		GOTO ARGS_ERROR
	END
--ELSE
--	BEGIN
--		IF SUBSTRING (@password, 1, 1) != '2'
--		BEGIN
--			SET @errorcode = 6
--			SET @errorstring = 'Error: Third parameter password is not in p2 format, please give thrid parameters as -p2 <password>.'
--			GOTO ARGS_ERROR
--		END
--	END
-----------------------------------------------
--Validation done, add User Name and Password--
-----------------------------------------------
BEGIN TRAN
BEGIN TRY
	--Set User Name----------------------------------------------------------------------------------------------------
	IF EXISTS(SELECT * FROM MMNDMPHostInfo WHERE ClientId = @clientId)
		BEGIN
			UPDATE MMNDMPHostInfo
			SET Login = @userName, Password = @password
			WHERE ClientId = @clientId
			print 'Successfully set properties.'
		END
	ELSE
		BEGIN
			print 'Unable to set properties, Configure Nas client from GUI.'
		END
	-------------------------------------------------------------------------------------------------------------------
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNasIDAProp')
	delete from GxQscripts where name = 'QS_SetNasIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNasIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetNasIDAProp'
GO

insert into GXDBVersions values(2, 'QS_SetNasIDAProp',  '00000000000000000000', 'QS_SetNasIDAProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNasIDAProp',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNasIDAProp -si @clientName=''Client Name'' -si @userName=''User Name'' -p2 @password=''Password''
'
 + CHAR(10) + '	Where 	ClientName		would be client name.
'
 + CHAR(10) + '			UserName		User name to be set for IDA
'
 + CHAR(10) + '			Password		Password to be set for IDA.
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn SetNasIDAProp -si @clientName=''Client Name'' -si @userName=''admin'' -p2 @password=''Password''
'
 + CHAR(10) + '-- 	script_name: SetNasIDAProp'
 + CHAR(10) + '-- 	Set properties of NAS IDA.'
)
GO

