

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMountpathPassword.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMountpathPassword <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMountpathPassword')
	drop procedure QS_SetMountpathPassword
IF EXISTS (select * from GxQscripts where name='QS_SetMountpathPassword')
	delete from GxQscripts where name = 'QS_SetMountpathPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountpathPassword')
	delete from GXDBVersions where aliasname = 'QS_SetMountpathPassword'
GO
print '... Creating Procedure: QS_SetMountpathPassword'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetMountpathPassword
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS VARCHAR(MAX) = '',
  @param2 AS NVARCHAR(MAX) = ''
AS
DECLARE @scriptName		AS VARCHAR(MAX) = 'SetMountpathPassword'
DECLARE @inUser VARCHAR(MAX) = @param1
DECLARE @password NVARCHAR(MAX) = @param2
DECLARE @aliasName VARCHAR(MAX) = ''
DECLARE @MountPathName VARCHAR(MAX) = ''
DECLARE @errorcode as INT = 0
DECLARE @errorstring as NVARCHAR(MAX) = 'Success'
IF @param1 = ''
BEGIN
	SET @errorcode = 1
	SET @errorstring = 'First input parameter user name [' + @param1 + '] is empty, please give user name.'
	GOTO ARGS_ERROR
END
BEGIN TRAN
BEGIN TRY
	UPDATE MMDeviceController
	SET UserPassword = @password
	WHERE UserName = @inUser
	IF @@ROWCOUNT = 0
		PRINT 'User [' + @inUser + '] do not have mount paths.'
	ELSE
		PRINT 'Successfully set password for user [' + @inUser + '].'
	--For Old style mount paths
	UPDATE MMMountPath
	SET UserPassword = @password
	WHERE UserName = @inUser
	IF @@ROWCOUNT = 0
		PRINT 'User [' + @inUser + '] do not have old style mount paths.'
	ELSE
		PRINT 'Successfully set password for user [' + @inUser + '] of old style mount paths.'
	PRINT 'Mount paths for user [' + @inUser + ']:'
	DECLARE MountPathCur CURSOR FOR SELECT
											MountPathName = CASE MP.MountPathTypeId
												WHEN 1 /* MOUNT_PATH_CENTERA */
												THEN ISNULL(
														(SELECT TOP 1 A.FriendlyName
															FROM MMCenteraInfo A INNER JOIN MMMountPathToStorageDevice B
															ON A.CenteraId = B.CenteraId
															WHERE B.MountPathId = MP.MountPathId),
														'Unavailable')
												ELSE ISNULL((
													SELECT DISTINCT CASE
														WHEN (MP.MountPathTypeId in ( 4 /* MOUNT_PATH_SHARED_STATIC */,
																						5 /* MOUNT_PATH_SHARED_REPLICA */,
																						7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST */ )
																AND MPDC.numController = 1)
														THEN MMDC.Folder
														ELSE MP.MountPathName
														END
												   FROM
														( SELECT a.MountPathId, a.DeviceId, COUNT(b.DeviceControllerId) as numController
															FROM    MMMountPathToStorageDevice a,
																	MMDeviceController b
															WHERE   a.DeviceId = b.DeviceId
															GROUP BY a.MountPathId, a.DeviceId
														) as MPDC,
														MMDeviceController MMDC
													WHERE   MPDC.MountPathId = MP.MountPathId
													AND MPDC.DeviceId = MMDC.DeviceId ), MP.MountPathName )
												END,
												ML.AliasName as LibraryName
									FROM    MMMountPath MP, MMLibrary ML
									WHERE MP.UserName = @inUser AND
									MP.LibraryId = ML.LibraryId
	OPEN MountPathCur
		FETCH NEXT FROM MountPathCur INTO @MountPathName, @aliasName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Mount Path:' + @MountPathName + ', Alias name:' + @aliasName
			FETCH NEXT FROM MountPathCur INTO @MountPathName, @aliasName
		END
	CLOSE MountPathCur
	DEALLOCATE MountPathCur
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @errorcode      = ERROR_NUMBER()
    SET @errorstring  = ERROR_MESSAGE()
END CATCH
IF (@errorcode  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMountpathPassword')
	delete from GxQscripts where name = 'QS_SetMountpathPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountpathPassword')
	delete from GXDBVersions where aliasname = 'QS_SetMountpathPassword'
GO

insert into GXDBVersions values(2, 'QS_SetMountpathPassword',  '00000000000000000000', 'QS_SetMountpathPassword', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetMountpathPassword',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetMountpathPassword -si ''username'' -p2 ''plainpassword''
'
 + CHAR(10) + '-- 	script_name: SetMountpathPassword'
 + CHAR(10) + '-- 	Set Mountpath Password'
)
GO

