

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMountPathWriters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMountPathWriters.sp,v $ $Id: QS_SetMountPathWriters.sp,v 1.2.200.2 2018/03/19 23:58:26 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMountPathWriters <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMountPathWriters')
	drop procedure QS_SetMountPathWriters
IF EXISTS (select * from GxQscripts where name='QS_SetMountPathWriters')
	delete from GxQscripts where name = 'QS_SetMountPathWriters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountPathWriters')
	delete from GXDBVersions where aliasname = 'QS_SetMountPathWriters'
GO
print '... Creating Procedure: QS_SetMountPathWriters'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMountPathWriters
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_library_name varchar(1024)='',
  @i_mountpath_name varchar(1024)='',
  @i_writers integer
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @num_MP	integer
	SET		@num_MP	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	=''
	DECLARE @tblMountPathInfo TABLE
	(
		MountPathId int,
		MaxConcurrentWriters int,
		LibraryId int
	)
	if not exists (select * from MMLibrary where aliasName = @i_library_name)
	BEGIN
		SET @localErrorMsg = 'Error: library not found!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	if exists (select * from MMLibrary where aliasName = @i_library_name and libraryTypeId <> 3) -- CV_LIB_MAGNETIC
	BEGIN
		SET @localErrorMsg = 'Error: library is not a disk library!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF @i_mountpath_name = ''
	BEGIN
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML
		WHERE MP.LibraryId = ML.LibraryId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
	END
	ELSE
	BEGIN
		-- For non-static-shared mount path created in 8.0 and before
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML
		WHERE MP.LibraryId = ML.LibraryId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		AND MP.MountPathName = @i_mountpath_name
		-- For Centeral mount path
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML, MMMountPathToStorageDevice MMPS
		WHERE MP.LibraryId = ML.LibraryId and MMPS.MountPathId = MP.MountPathId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		and MMPS.CenteraId > 0 and MMPS.CenteraId in
										(select CenteraId from MMCenteraInfo MMC
										where MMC.FriendlyName = @i_mountpath_name
										and MMC.CenteraId = MMPS.CenteraId)
		-- For all static-shared mount path
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML, MMDeviceController MMDC, MMMountPathToStorageDevice MMPS
		WHERE MP.LibraryId = ML.LibraryId and MMDC.DeviceId = MMPS.DeviceId and MMPS.MountPathId = MP.MountPathId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		AND (MP.MountPathName = @i_mountpath_name or MMDC.Folder = @i_mountpath_name)
	END
	set @num_MP = (select count(*) from @tblMountPathInfo)
	IF @num_MP = 0
	BEGIN
		SET @localErrorMsg = 'Error: Mounthpath not found!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF @i_writers < 0 OR @i_writers > 1000
	BEGIN
		SET @localErrorMsg = 'Error: Invalid number of writers.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	UPDATE MMMountPath
	SET MaxConcurrentWriters = @i_writers
	WHERE MountPathId in (SELECT MountPathId FROM @tblMountPathInfo)
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'DB Error: [' + @@ERROR + ']. Failed to update database.'
		SET @lastError = 1
	END
	ELSE
	BEGIN
		SET	@localErrorMsg	='Total number of mountpaths updated: [' + CONVERT (VARCHAR(10), @num_MP) + ']'
		select MountPathId from @tblMountPathInfo
	END
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMountPathWriters')
	delete from GxQscripts where name = 'QS_SetMountPathWriters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountPathWriters')
	delete from GXDBVersions where aliasname = 'QS_SetMountPathWriters'
GO

insert into GXDBVersions values(2, 'QS_SetMountPathWriters',  '00010002020000020000', 'QS_SetMountPathWriters', '00010002020000020000')
GO

insert into GxQscripts values(2,'QS_SetMountPathWriters',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	Command to set one mountpath of a library: qoperation execscript -sn setMountPathWriters -si library_name -si mountpath_name -si num_writers
'
 + CHAR(10) + '	Command to set all mountpaths of a library: qoperation execscript -sn setMountPathWriters -si library_name -si -si num_writers
'
 + CHAR(10) + '--   num_writers = 0:  Disable Mount Path for Write'
 + CHAR(10) + '--   num_writers = 1000: Maximum Allowed Writer'
 + CHAR(10) + '--   num_writers = 1 to 999: Number of writers to set'
)
GO

