

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMountPathProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMountPathProperties.sp,v $ $Id: QS_SetMountPathProperties.sp,v 1.4.84.9 2019/12/12 19:01:07 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetMountPathProperties')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetMountPathProperties <<<'
	drop procedure QS_SetMountPathProperties
END
IF EXISTS (select * from GxQscripts where name='QS_SetMountPathProperties')
	delete from GxQscripts where name = 'QS_SetMountPathProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountPathProperties')
	delete from GXDBVersions where aliasname = 'QS_SetMountPathProperties'
GO
print '... Creating Procedure: QS_SetMountPathProperties'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMountPathProperties
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_library_name varchar(1024)='',
  @i_mountpath_name varchar(1024)='',
  @i_Option varchar(1024)='',	-- 'writers', 'useunbuffio', 'setOfflineReason'
  @i_param1 varchar(1024)=''
AS
Set NOCOUNT ON
		DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @num_MP	integer
	SET		@num_MP	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	=''
	DECLARE @writers integer
	SET		@writers =	0
	DECLARE @setUseUnbufferedIO	integer
	SET		@setUseUnbufferedIO	=	0
	DECLARE @enableMP	integer
	SET		@enableMP	=	0
	DECLARE	@MagneticSpaceRsrvInMB	BIGINT
	SET		@MagneticSpaceRsrvInMB = 0
	DECLARE	@MaxDataToWriteMB	BIGINT
	SET		@MaxDataToWriteMB = 0
	DECLARE @maxIntVal INT = 2147483647
	DECLARE @tblMountPathInfo TABLE
	(
		MountPathId int,
		MaxConcurrentWriters int,
		LibraryId int
	)
	---------------------------------------------------
--- FOR GUI AUDIT TRAIL						-------
---------------------------------------------------
	DECLARE @userId					AS	integer = 0		-- Until there is a way to fetch from Qcommand!
	DECLARE @opMsgId			INTEGER
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(MAX)
	DECLARE @dataIsEvent		INTEGER
	DECLARE @prevValue			INTEGER
	SET @prevValue = 0
	DECLARE @mountpath_name varchar(1024)=''
	DECLARE @Cursor as CURSOR
	SET @Cursor = CURSOR FOR SELECT MountPathId FROM @tblMountPathInfo
	OPEN @Cursor
	DECLARE @mountpathId			INTEGER
---------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
	BEGIN
		SET @localErrorMsg = 'Error, no logged in user found'
		Set @lastError = 1
		GOTO   ARGS_ERROR
	END
	SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
	IF @userId = 0
	BEGIN
		SET @localErrorMsg = 'Error, no logged in user found'
		Set @lastError = 1
		GOTO   ARGS_ERROR
	END
	if not exists (select * from MMLibrary where aliasName = @i_library_name)
	BEGIN
		SET @localErrorMsg = 'Error: library not found!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	if exists (select * from MMLibrary where aliasName = @i_library_name and libraryTypeId <> 3) -- CV_LIB_MAGNETIC
	BEGIN
		SET @localErrorMsg = 'Error: library is not a disk library!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF(@i_Option  not in ('writers','useunbuffio','reservespace','setOfflineReason','doNotConsumeMoreThanGB','enableMountPath'))
	BEGIN
		SET @localErrorMsg = 'Error: invalid option '''+ @i_Option+'''.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF(rtrim(@i_param1) = '' )
	BEGIN
		SET @localErrorMsg = 'Error: '+@i_option+' value parameter not supplied.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF @i_mountpath_name = ''
	BEGIN
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML
		WHERE MP.LibraryId = ML.LibraryId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
	END
	ELSE
	BEGIN
		-- For non-static-shared mount path created in 8.0 and before
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML
		WHERE MP.LibraryId = ML.LibraryId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		AND MP.MountPathName = @i_mountpath_name
		-- For Centeral mount path
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML, MMMountPathToStorageDevice MMPS
		WHERE MP.LibraryId = ML.LibraryId and MMPS.MountPathId = MP.MountPathId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		and MMPS.CenteraId > 0 and MMPS.CenteraId in
										(select CenteraId from MMCenteraInfo MMC
										where MMC.FriendlyName = @i_mountpath_name
										and MMC.CenteraId = MMPS.CenteraId)
		-- For all static-shared mount path
		INSERT INTO @tblMountPathInfo
		SELECT distinct MP.MountPathId, MP.MaxConcurrentWriters, MP.libraryId
		FROM MMMountPath MP, MMLibrary ML, MMDeviceController MMDC, MMMountPathToStorageDevice MMPS
		WHERE MP.LibraryId = ML.LibraryId and MMDC.DeviceId = MMPS.DeviceId and MMPS.MountPathId = MP.MountPathId
		AND MP.MountPathId > 0 and MP.MountPathId not in (select MountPathId from @tblMountPathInfo)
		AND ML.aliasName = @i_library_name
		AND (MP.MountPathName = @i_mountpath_name or MMDC.Folder = @i_mountpath_name)
	END
	set @num_MP = (select count(*) from @tblMountPathInfo)
	IF @num_MP = 0
	BEGIN
		SET @localErrorMsg = 'Error: Mounthpath not found!'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	BEGIN TRANSACTION
SET @opMsgId = (106 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @dataIsEvent = 0
SET @paramMsgId  = (191 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = @i_library_name
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	FETCH NEXT FROM @Cursor INTO @mountpathId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @mountpath_name = (SELECT MountPathName from CNMMMountPathView CMP  where CMP.MountPathID = @mountpathId)
SET @paramMsgId  = (196 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData = @mountpath_name
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		IF (@i_Option  = 'writers')
		BEGIN
			SET @prevValue   = (SELECT MaxConcurrentWriters FROM MMMountPath WHERE MountPathId = @mountpathId)
			SET @writers = CONVERT(INTEGER, @i_param1)
IF (4096 = (SELECT attribute & 4096  FROM MMMountPath WHERE MountPathId = @mountpathId))
			BEGIN
				SET @localErrorMsg = 'Error: Writers cannot be updated when Mount Path Move operation is running.'
				SET @lastError = 1
				GOTO   ARGS_ERROR
			END
			IF @writers < 0 OR @writers > 1000
			BEGIN
				SET @localErrorMsg = 'Error: Invalid number of writers.'
				SET @lastError = 1
				GOTO   ARGS_ERROR
			END
			UPDATE MMMountPath
			SET MaxConcurrentWriters = @writers
			WHERE MountPathId = @mountpathId
			IF (@prevValue = 0 OR @i_param1 = 0) AND @i_param1 <> @prevValue
			BEGIN
				IF @prevValue = 0 AND @i_param1 <> 0
SET @paramMsgId  = (264 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				IF @i_param1 = 0 AND @prevValue <> 0
SET @paramMsgId  = (263 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = @mountpath_name
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
SET @paramMsgId  = (1136 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					IF @prevValue = 1000
						SET @paramData = 'Maximum'
					ELSE
						SET @paramData   = CONVERT(nvarchar,@prevValue)
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					IF @i_param1 = 1000
						SET @paramData = 'Maximum'
					ELSE
						SET @paramData   = @i_param1
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		ELSE IF( @i_Option	= 'useunbuffio')
		BEGIN
			--#define MNTPTH_ATTRIB_BUFFERED_IO       1
			SET @setUseUnbufferedIO = CONVERT(INTEGER, @i_param1)
			IF(@setUseUnbufferedIO not in (0,1))
			BEGIN
				SET @localErrorMsg = 'Error: Invalid input value. Enter 1 to enable 0 to disable.'
				SET @lastError = 1
				GOTO   ARGS_ERROR
			END
			IF(@setUseUnbufferedIO = 0)
			BEGIN
				UPDATE MMMountPath
				SET Attribute = (Attribute & ~1)	--#define MNTPTH_ATTRIB_BUFFERED_IO       1
				WHERE MountPathId = @mountpathId
SET @paramMsgId  = (642 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			END
			ELSE
			BEGIN
				UPDATE MMMountPath
				SET Attribute = (Attribute | 1)	--#define MNTPTH_ATTRIB_BUFFERED_IO       1
				WHERE MountPathId = @mountpathId
SET @paramMsgId  = (641 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			END
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		ELSE IF (@i_Option = 'reservespace')
		BEGIN
			SET @prevValue   = (SELECT MagneticSpaceRsrvInMB FROM MMMountPath WHERE MountPathId = @mountpathId)
			SET @MagneticSpaceRsrvInMB = CONVERT(BIGINT,@i_param1)
			IF (@MagneticSpaceRsrvInMB < 2048 OR @MagneticSpaceRsrvInMB > @maxIntVal)
			BEGIN
				SET @localErrorMsg = 'Error: Invalid reserve space'
				SET @lastError = 1
				GOTO ARGS_ERROR
			END
			ELSE
			BEGIN
				UPDATE MMMountPath
				SET MagneticSpaceRsrvInMB = @MagneticSpaceRsrvInMB, MaxDataToWriteMB = -1
				WHERE MountPathId = @mountpathId
SET @paramMsgId  = (1332 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = CONVERT(nvarchar,@prevValue)
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					SET @paramData   = @i_param1
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
		END
		ELSE IF (@i_Option = 'doNotConsumeMoreThanGB')
		BEGIN
			SET @prevValue   = (SELECT MaxDataToWriteMB FROM MMMountPath WHERE MountPathId = @mountpathId)
			SET @prevValue = @prevValue / 1024
			SET @MaxDataToWriteMB = CONVERT(BIGINT,@i_param1)
			SET  @MaxDataToWriteMB = 1024* @MaxDataToWriteMB
			IF (@MaxDataToWriteMB < 2048 OR @MaxDataToWriteMB > @maxIntVal)
			BEGIN
				SET @localErrorMsg = 'Error: Invalid do not consume more than GB value'
				SET @lastError = 1
				GOTO ARGS_ERROR
			END
			ELSE
			BEGIN
				UPDATE MMMountPath
				SET MaxDataToWriteMB = @MaxDataToWriteMB
				WHERE MountPathId = @mountpathId
SET @paramMsgId  = (1333 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = CONVERT(nvarchar,@prevValue)
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					SET @paramData   = @i_param1
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
		END
		ELSE IF (@i_Option = 'setOfflineReason')
		BEGIN
			IF (@i_param1 = 'MountPathPermanentlyLost')
			BEGIN
				UPDATE MMMountPath
				SET isOffline = 1,
					OfflineReason = 6 -- MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER
				WHERE MountPathId = @mountpathId
SET @paramMsgId  = (263 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = @mountpath_name
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
EXEC AppNotifyMountPathChangesToClient @mountpathId/*MPID*/, 4 /*opType*/
			END
			ELSE
			BEGIN
				SET @localErrorMsg = 'Error: Invalid mountPath offline reason'
				SET @lastError = 1
				GOTO ARGS_ERROR
			END
		END
		ELSE IF( @i_Option	= 'enableMountPath')
		BEGIN
			SET @enableMP = CONVERT(INTEGER, @i_param1)
			IF(@enableMP not in (0,1))
			BEGIN
				SET @localErrorMsg = 'Error: Invalid input value. Enter 1 to enable 0 to disable.'
				SET @lastError = 1
				GOTO   ARGS_ERROR
			END
			UPDATE MMMountPath
			SET IsEnabled = @enableMP, OfflineTimeStamp = case @enableMP when 0 then dbo.GetUnixTime(SYSUTCdateTIme()) else OfflineTimeStamp end
			WHERE MountPathId = @mountpathId
			INSERT INTO MMMountPathStateHistory
			SELECT mp.mediaSideId,0, t.mountPathId,@enableMP,SYSdateTIme(),0
			FROM @tblMountPathInfo t, MMMountPath mp
			WHERE mp.mountPathId = t.MountPathId
			IF @enableMP = N'1'
SET @paramMsgId  = (966 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				ELSE
SET @paramMsgId  = (967 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = (SELECT MD.AliasName FROM MMDevice MD, MMMountPathToStorageDevice MPSD WHERE MD.DeviceId = MPSD.DeviceId AND MPSD.MountPathId = @mountpathId)
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				SET @paramData = @mountpath_name
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		IF @@ERROR <> 0
		BEGIN
			SET @localErrorMsg = 'DB Error: [' + @@ERROR + ']. Failed to update database.'
			SET @lastError = 1
		END
		ELSE
		BEGIN
			SET	@localErrorMsg	='Total number of mountpaths updated: [' + CONVERT (VARCHAR(10), @num_MP) + ']'
			FETCH NEXT FROM @Cursor INTO @mountpathId
		END
	END
	CLOSE @Cursor
	DEALLOCATE @Cursor
	COMMIT TRANSACTION
	IF @lastError = 0
		SELECT @i_library_name Library_Name , MountPathName FROM CNMMMountPathView CMP , @tblMountPathInfo TMP WHERE CMP.MountPathID = TMP.MountPathId
ARGS_ERROR:
	if @lastError <> 0
		BEGIN
		IF @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
		END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMountPathProperties')
	delete from GxQscripts where name = 'QS_SetMountPathProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMountPathProperties')
	delete from GXDBVersions where aliasname = 'QS_SetMountPathProperties'
GO

insert into GXDBVersions values(2, 'QS_SetMountPathProperties',  '00010004008400090000', 'QS_SetMountPathProperties', '00010004008400090000')
GO

insert into GxQscripts values(2+8,'QS_SetMountPathProperties',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	Command to set one mountpath property of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si option -si optionvalue
'
 + CHAR(10) + '	Command to set all mountpath properties of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si option -si optionvalue
'
 + CHAR(10) + '	Command to Enable/Disable one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si enableMountPath -si ( 1 - To Enable, 0 - To Disable)
'
 + CHAR(10) + '	Command to Enable/Disable all mountpaths of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si enableMountPath -si (1 - To Enable, 0 - To Disable)
'
 + CHAR(10) + '	Command to set writers for one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si writers -si num_writers
'
 + CHAR(10) + '	Command to set writers for all mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si  -si writers -si num_writers
'
 + CHAR(10) + '	Command to set use unbufferedIO for one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si useunbuffio -si ( 1 - To Enable, 0 - To Disable)
'
 + CHAR(10) + '	Command to set use unbufferedIO for all mountpaths of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si useunbuffio -si (1 - To Enable, 0 - To Disable)
'
 + CHAR(10) + '	Command to set mountPath permanently offline for one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si setOfflineReason -si ''MountPathPermanentlyLost''
'
 + CHAR(10) + '	Command to set mountPath permanently offline for all mountpaths of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si setOfflineReason -si ''MountPathPermanentlyLost''
'
 + CHAR(10) + '    Command to set "reserve space" for one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si reservespace -si reserve_space_in_MB
'
 + CHAR(10) + '    Command to set "reserve space" for all mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si reservespace -si reserve_space_in_MB
'
 + CHAR(10) + '    Command to set "Do not Consume more than ##GB" space for one mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si mountpath_name -si doNotConsumeMoreThanGB -si space_in_GB
'
 + CHAR(10) + '    Command to set "Do not Consume more than ##GB" space for all mountpath of a library: qoperation execscript -sn SetMountPathProperties -si library_name -si -si doNotConsumeMoreThanGB -si space_in_GB
'
 + CHAR(10) + '--   num_writers = 0:  Disable Mount Path for Write'
 + CHAR(10) + '--   num_writers = 1000: Maximum Allowed Writer'
 + CHAR(10) + '--   num_writers = 1 to 999: Number of writers to set'
 + CHAR(10) + '--   reserve_space_in_MB = 2147483647: Maximum allowed reserve space in MB'
 + CHAR(10) + '--   reserve_space_in_MB = 2048: Minumun allowed reserve space in MB'
 + CHAR(10) + '--   doNotConsumeMoreThanGB = 2097151: Maximum allowed Do not Consume more than space in GB'
 + CHAR(10) + '--   doNotConsumeMoreThanGB = 2: Minumun allowed Do not Consume more than space in GB'
)
GO

