

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMediaLocation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMediaLocation.sp,v $ $Id: QS_SetMediaLocation.sp,v 1.2.208.2 2018/03/20 00:17:53 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMediaLocation <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMediaLocation')
	drop procedure QS_SetMediaLocation
IF EXISTS (select * from GxQscripts where name='QS_SetMediaLocation')
	delete from GxQscripts where name = 'QS_SetMediaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaLocation')
	delete from GXDBVersions where aliasname = 'QS_SetMediaLocation'
GO
print '... Creating Procedure: QS_SetMediaLocation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMediaLocation
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_barcode varchar(1024)='',
  @i_location varchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @mediaId			integer
	DECLARE @exportLocationId	integer
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	SET @mediaId = ISNULL((SELECT mediaId FROM MMMedia with (nolock) WHERE barcode = @i_barcode), 0)
	SET @exportLocationId = ISNULL((SELECT exportLocationId FROM MMExportLocation with (nolock) WHERE ExportLocation = @i_location), -1)
	IF @mediaId = 0
	BEGIN
		SET @localErrorMsg = 'Error: barcode is not found in database!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @exportLocationId = -1
	BEGIN
		SET @localErrorMsg = 'Error: export location is not found in database!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	UPDATE MMMedia
	SET ExportLocationId = @exportLocationId
	WHERE MediaId = @mediaId
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to update export location for media!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMediaLocation')
	delete from GxQscripts where name = 'QS_SetMediaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaLocation')
	delete from GXDBVersions where aliasname = 'QS_SetMediaLocation'
GO

insert into GXDBVersions values(2, 'QS_SetMediaLocation',  '00010002020800020000', 'QS_SetMediaLocation', '00010002020800020000')
GO

insert into GxQscripts values(2,'QS_SetMediaLocation',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetMediaLocation -si ''barcode'' -si ''location''
'
)
GO

