

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMediaDescriptionUsingBarcodeList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMediaDescriptionUsingBarcodeList.sp,v $ $Id: QS_SetMediaDescriptionUsingBarcodeList.sp,v 1.1.4.5 2018/03/22 03:11:31 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMediaDescriptionUsingBarcodeList <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMediaDescriptionUsingBarcodeList')
	drop procedure QS_SetMediaDescriptionUsingBarcodeList
IF EXISTS (select * from GxQscripts where name='QS_SetMediaDescriptionUsingBarcodeList')
	delete from GxQscripts where name = 'QS_SetMediaDescriptionUsingBarcodeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaDescriptionUsingBarcodeList')
	delete from GXDBVersions where aliasname = 'QS_SetMediaDescriptionUsingBarcodeList'
GO
print '... Creating Procedure: QS_SetMediaDescriptionUsingBarcodeList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMediaDescriptionUsingBarcodeList
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024)=''
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
------------------------------------------------
CREATE TABLE #tempBarcodes (Barcode varchar(256), Descript nvarchar(max))
CREATE TABLE #tFailedBarcodes ( Barcode varchar(256), Reason varchar(256))
BEGIN Tran
BEGIN TRY
DECLARE @str_command nvarchar(max)
SET @str_command = 'BULK
INSERT #tempBarcodes
FROM '''+ @PARAM1 +
'''WITH
(
FIELDTERMINATOR = '','',
ROWTERMINATOR = ''\n''
)'
EXEC SP_EXECUTESQL @str_command
INSERT INTO #tFailedBarcodes
SELECT DISTINCT tB.BarCode  , 'Given Media is Magnetic, cannot update'
FROM MMMedia mmm inner join #tempBarcodes tB on mmm.BarCode = tB.BarCode
where mmm.MediaTypeId = 10001
INSERT INTO #tFailedBarcodes
SELECT  tB.BarCode, 'Barcode not found'
FROM MMMedia mmm right outer join #tempBarcodes tB on mmm.BarCode = tB.BarCode
where mmm.Barcode is null
if((select COUNT(*) from #tFailedBarcodes ) > 0)
begin
	print 'Following barcodes were not updated:'
	select * from #tFailedBarcodes
end
Set NOCOUNT OFF
UPDATE MMMedia
SET    MMMedia.Descript = A.Descript
FROM   #tempBarcodes A INNER JOIN MMMedia B ON A.Barcode = B.Barcode
WHERE  NOT EXISTS (SELECT 1 FROM #tFailedBarcodes WHERE BarCode = B.Barcode)
END TRY
BEGIN CATCH
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = @localErrorMsg + ERROR_MESSAGE()
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
drop table #tempBarcodes
drop table #tFailedBarcodes
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMediaDescriptionUsingBarcodeList')
	delete from GxQscripts where name = 'QS_SetMediaDescriptionUsingBarcodeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaDescriptionUsingBarcodeList')
	delete from GXDBVersions where aliasname = 'QS_SetMediaDescriptionUsingBarcodeList'
GO

insert into GXDBVersions values(2, 'QS_SetMediaDescriptionUsingBarcodeList',  '00010001000400050000', 'QS_SetMediaDescriptionUsingBarcodeList', '00010001000400050000')
GO

insert into GxQscripts values(2,'QS_SetMediaDescriptionUsingBarcodeList',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn SetMediaDescriptionUsingBarcodeList -si CSVFileFullPath'
)
GO

