

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMediaBarcode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMediaBarcode.sp,v $ $Id: QS_SetMediaBarcode.sp,v 1.3.56.2 2018/03/20 00:03:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMediaBarcode <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMediaBarcode')
	drop procedure QS_SetMediaBarcode
IF EXISTS (select * from GxQscripts where name='QS_SetMediaBarcode')
	delete from GxQscripts where name = 'QS_SetMediaBarcode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaBarcode')
	delete from GXDBVersions where aliasname = 'QS_SetMediaBarcode'
GO
print '... Creating Procedure: QS_SetMediaBarcode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMediaBarcode
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_barcode varchar(1024)='',
  @i_barcode_old varchar(1024)='',
  @i_uniqueId_old varchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @beginTran	integer
	SET		@beginTran	= 0
	DECLARE @mediaId			integer
	DECLARE @mediaId_old		integer
	DECLARE @mediaTypeId		integer
	DECLARE @mediaTypeId_old	integer
	DECLARE @libraryId			integer
	DECLARE @libraryId_old		integer
	DECLARE @mediaLocation		integer
	DECLARE @mediaLocation_old	integer
	DECLARE	@spareGroupId		integer
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	SELECT @mediaId = mediaId, @mediaTypeId = mediaTypeId, @libraryId = libraryId, @mediaLocation = mediaLocation, @spareGroupId = spareGroupId
	FROM MMMedia with (nolock) WHERE barcode = @i_barcode
	SELECT @mediaId_old = mediaId, @mediaTypeId_old = mediaTypeId, @libraryId_old = @libraryId, @mediaLocation_old = mediaLocation
	FROM MMMedia with (nolock) WHERE barcode = @i_barcode_old
	IF @mediaId is null or @mediaId = 0
	BEGIN
		SET @localErrorMsg = 'Error: barcode is not found in database!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @mediaId_old is null or @mediaId_old = 0
	BEGIN
		SET @localErrorMsg = 'Error: old barcode is not found in database!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @mediaTypeId = 10001 or @mediaTypeId_old = 10001
	BEGIN
		SET @localErrorMsg = 'Error: we cannot replace barcode for magnetic library!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if not exists (select * from mmmedia where mediaId = @mediaId_old and uniqueId = @i_uniqueId_old)
	begin
		SET @localErrorMsg = 'Error: Input uniqueId does not match the old media uniqueId!'
		Set @lastError = 1
		goto   ARGS_ERROR
	end
	if exists (select * from mmvolume where mediaId = @mediaId and volumeId in (select volumeId from archchunk))
	begin
		SET @localErrorMsg = 'Error: the media with new barcode is not empty so cannot be replaced and then deleted!'
		Set @lastError = 1
		goto   ARGS_ERROR
	end
	IF NOT EXISTS (SELECT MD.* from MMDriveController as MMDC, MMDrive as MD, MMMasterPool as MP, MMRecfmtmedtyp as MR, MMDrivePool MDP
		where MMDC.driveId=MD.driveId and MD.drivetypeid=MR.drivetypeid and MD.masterpoolid=MP.masterpoolid
		and MR.mediatypeid=@mediaTypeId_old and MP.libraryid=@libraryId
		and MMDC.drivePoolId = MDP.drivePoolId
		and MDP.DrivePoolSoftState=1 and MDP.DrivePoolEnabled=1)
	BEGIN
		SET @localErrorMsg = 'Error: Media Type of the old barcode is not compatiable with the drive of library that the new barcode belongs to!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @mediaLocation_old <> 3
	BEGIN
		SET @localErrorMsg = 'Error: Media with the old barcode is still in library!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @mediaLocation = 3
	BEGIN
		SET @localErrorMsg = 'Error: Media with the new barcode is not in library!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	BEGIN TRAN setMediaBarcodeTran
	SET @beginTran = 1
	update MMSlot set MediaId = 0, barcode = '' where MediaId = @mediaId_old
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to update mmslot table for old barcode!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	update MMSlot set MediaId = @mediaId_old where MediaId = @mediaId
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to update mmslot table for new barcode!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	delete MMVolume where MediaId = @mediaId
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to delete from mmvolume table!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	delete MMMediaSide where MediaId = @mediaId
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to delete from mmmediaside table!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	delete MMMedia where MediaId = @mediaId
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to delete from mmmedia table!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	UPDATE MMMEDIA
	SET		BarCode = @i_barCode, LibraryId = @libraryId, mediaLocation = @mediaLocation, spareGroupId = @spareGroupId
	WHERE MediaId = @mediaId_old
	IF @@ERROR <> 0
	BEGIN
		SET @localErrorMsg = 'Error: failed to update media!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	COMMIT TRAN setMediaBarcodeTran
	PRINT 'Media with old barcode [' + @i_barcode_old + '] is updated with new barcode [' + @i_barcode + '] along with its library. Media with new barcode is deleted from database.'
	RETURN
ARGS_ERROR:
	IF @beginTran > 0 ROLLBACK TRAN setMediaBarcodeTran
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMediaBarcode')
	delete from GxQscripts where name = 'QS_SetMediaBarcode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMediaBarcode')
	delete from GXDBVersions where aliasname = 'QS_SetMediaBarcode'
GO

insert into GXDBVersions values(2, 'QS_SetMediaBarcode',  '00010003005600020000', 'QS_SetMediaBarcode', '00010003005600020000')
GO

insert into GxQscripts values(2,'QS_SetMediaBarcode',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetMediaBarcode -si ''barcode'' -si ''old_barcode'' -si ''old_uniqueId''
'
)
GO

