

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMaxParallelBackupCopyJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetMaxParallelBackupCopyJobs.sp,v $ $Id: QS_SetMaxParallelBackupCopyJobs.sp,v 1.1.2.1 2018/06/29 00:53:09 pkrishnan Exp $";
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "QS_SelectAdditionalJobs"							|
--	|																		|
--	|-------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetMaxParallelBackupCopyJobs')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetMaxParallelBackupCopyJobs <<<'
	drop procedure QS_SetMaxParallelBackupCopyJobs
END
IF EXISTS (select * from GxQscripts where name='QS_SetMaxParallelBackupCopyJobs')
	delete from GxQscripts where name = 'QS_SetMaxParallelBackupCopyJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMaxParallelBackupCopyJobs')
	delete from GXDBVersions where aliasname = 'QS_SetMaxParallelBackupCopyJobs'
GO
print '... Creating Procedure: QS_SetMaxParallelBackupCopyJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMaxParallelBackupCopyJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_SPName nvarchar(max),
  @i_MaxJobs integer,
  @i_RemoveConfig integer = 0
AS
SET NOCOUNT ON
DECLARE @ErrorMessage NVARCHAR(MAX)
DECLARE	@SPId INTEGER = 0
DECLARE	@modifyTime INTEGER = 0
BEGIN TRY
SELECT @SPId = id from ArchGroup WITH(NOLOCK) WHERE NAME = @i_SPName
IF @SPId = 0
BEGIN
	SET @ErrorMessage = N'Invalid Storage policy name'
	Raiserror(@ErrorMessage,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
IF (@i_RemoveConfig <> 1 AND @i_MaxJobs <= 0)
BEGIN
	SET @ErrorMessage = N'Invalid input. Enter a number greater than 0'
	Raiserror(@ErrorMessage,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
IF(@i_RemoveConfig = 1)
BEGIN
DELETE MMEntityProp WHERE EntityId = @SPId AND EntityType = 1 AND propertyName = 'MaxParallelBackupCopyJobs' AND CommCellId = 2
END
ELSE
BEGIN
IF EXISTS (SELECT 1 FROM MMEntityProp where EntityId = @SPId and propertyName = 'MaxParallelBackupCopyJobs' and EntityType = 1 AND CommCellId = 2)
	BEGIN
		UPDATE MMEntityProp SET intVal = @i_MaxJobs, modified = @modifyTime
WHERE EntityId = @SPId AND EntityType = 1 AND propertyName = 'MaxParallelBackupCopyJobs' AND CommCellId = 2
	END
	ELSE
	BEGIN
		INSERT INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
VALUES (@SPId, 1, 'MaxParallelBackupCopyJobs', 1,  @i_MaxJobs, 0, '', @modifyTime, @modifyTime, 2)
	END
END
IF(@i_RemoveConfig = 1)
	PRINT 'Successfully removed the config'
ELSE
	PRINT 'Successfully set the config'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
THROW
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMaxParallelBackupCopyJobs')
	delete from GxQscripts where name = 'QS_SetMaxParallelBackupCopyJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMaxParallelBackupCopyJobs')
	delete from GXDBVersions where aliasname = 'QS_SetMaxParallelBackupCopyJobs'
GO

insert into GXDBVersions values(2, 'QS_SetMaxParallelBackupCopyJobs',  '00010001000200010000', 'QS_SetMaxParallelBackupCopyJobs', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_SetMaxParallelBackupCopyJobs',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetMaxParallelBackupCopyJobs -si @i_SPName = ''SPName'' -si @i_MaxJobs = ''Number'' -si @i_RemoveConfig = ''0/1''
'
 + CHAR(10) + '-- 	script_name: QS_SetMaxParallelBackupCopyJobs.'
 + CHAR(10) + '-- 	Set maximum number of backup copy jobs that can run on a given storage policy in parallel.'
)
GO

