

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMSSQLCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetMSSQLcredentials')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetMSSQLcredentials <<<'
	drop procedure QS_SetMSSQLcredentials
END
IF EXISTS (select * from GxQscripts where name='QS_SetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_SetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_SetMSSQLcredentials'
GO
print '... Creating Procedure: QS_SetMSSQLcredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMSSQLcredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @PARAM2 varchar(512) = '%s',
  @PARAM3 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER! 				 --
---------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--DECLARE @PARAM3     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- encryptedpassworrd
--SET @PARAM3 = '%s'					-- username (optional)
DECLARE @HIDEPARAM2 	varchar(512)
SET		@HIDEPARAM2		=@PARAM2				-- COMMENT OUT THE NEXT LINE SO THAT PASSWORD IS DISPLAYED!
SET		@HIDEPARAM2		='XXXXXXX'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetMSSQLcredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--DECLARE @MAX_ENTITY_SIZE		smallint
--SET @MAX_ENTITY_SIZE			=100
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
---SET @PARAM1 =  'c=jewelfish_cn'
---SET @PARAM1 =  'allclients'
---SET @PARAM2 =  'QWERTY'
--SET @PARAM3 =	 'Stuk'
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---  ENCRYPTED PASSWORD				---
---------------------------------------
IF @PARAM2 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Encrypted password must specified as parameter2.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @Password = @PARAM2
---------------------------------------
---  USERNAME (OPTIONAL)			---
---------------------------------------
IF @PARAM3 = @NoParameter
	SET @USERNAME=''
ELSE
	SET @USERNAME = @PARAM3
IF LEN(@USERNAME) > 100
BEGIN
	SET @lastError = 1
SET @localErrorMsg = 'Error. User name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@HIDEPARAM2 +', ' +REPLACE(@PARAM3, @NoParameter, '[]')
IF @USERNAME =''
	PRINT '................. Username not specified. Existing Username(s) will be preserved.'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
-- MS SQL SERVER --
	IF @clientId = 0
	BEGIN
		UPDATE APP_INSTANCEPROP
			SET ATTRVAL =@PASSWORD
			  WHERE AttrName = 'MSSQL password'
				AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
				AND MODIFIED = 0
		IF @userName <> ''
			UPDATE APP_INSTANCEPROP
				SET ATTRVAL =@UserName
				  WHERE AttrName = 'MSSQL username'
					AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
					AND MODIFIED = 0
	END
	ELSE
	BEGIN
		UPDATE APP_INSTANCEPROP
			SET ATTRVAL = @PASSWORD
			  WHERE AttrName = 'MSSQL password'
				AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE clientId = @clientID AND appTypeId in (4, 16, 70, 81))
				AND Modified = 0
		IF @userName <> ''
			UPDATE APP_INSTANCEPROP
				SET ATTRVAL =@UserName
				  WHERE AttrName = 'MSSQL username'
					AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE clientId = @clientID AND appTypeId in (4, 16, 70, 81))
					AND MODIFIED = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + +REPLACE(@PARAM1, @NoParameter, '[]') +', ' +@HIDEPARAM2 +', ' +REPLACE(@PARAM3, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMSSQLCredentials')
	delete from GxQscripts where name = 'QS_SetMSSQLCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMSSQLCredentials')
	delete from GXDBVersions where aliasname = 'QS_SetMSSQLCredentials'
GO

insert into GXDBVersions values(2, 'QS_SetMSSQLCredentials',  '00000000000000000000', 'QS_SetMSSQLCredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetMSSQLCredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f SetMSSQLcredentials -i c=clientName|allclients  encryptedPassword [userName]
'
 + CHAR(10) + '--   script_name : SetMSSQLcredentials'
)
GO

