

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetLogStreamsOnStoragePolicy.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetLogStreamsOnStoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetLogStreamsOnStoragePolicy <<<'
	drop procedure QS_SetLogStreamsOnStoragePolicy
END
IF EXISTS (select * from GxQscripts where name='QS_SetLogStreamsOnStoragePolicy')
	delete from GxQscripts where name = 'QS_SetLogStreamsOnStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetLogStreamsOnStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetLogStreamsOnStoragePolicy'
GO
print '... Creating Procedure: QS_SetLogStreamsOnStoragePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetLogStreamsOnStoragePolicy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 nvarchar(256) = '',
  @PARAM2 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_SPName NVARCHAR(256)
 DECLARE @i_numStreams INT
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetLogStreamsOnStoragePolicy'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
BEGIN TRY
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter) --Requires both storage policy name and number of streams
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_SetLogStreamsOnStoragePolicy'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_SPName = @PARAM1
	SET @i_numStreams = CAST(@PARAM2 as INT)
	DECLARE @l_SPId INT
	DECLARE @l_TotalStreams INT = 0
	SELECT @l_SPId = id, @l_TotalStreams = maxStreams FROM ArchGroup WITH(READUNCOMMITTED) WHERE name = @i_SPName
	--Validate storage policy name
	IF @l_SPId IS NULL OR @l_SPId < 2
	BEGIN
		SET @localErrorMsg	=	'Error: Invalid StoragePolicy [' + @i_SPName + ']'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	IF @i_numStreams >= @l_TotalStreams
	BEGIN
		SET @localErrorMsg	=	'Error: Cannot dedicate total streams defined on storage policy for log backups'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	DECLARE @l_now INT = dbo.GetUnixTime(GETUTCDATE())
	--Set the streams
	UPDATE 	MMEntityProp
	SET		intVal = @i_numStreams,
			modified = @l_now
WHERE	CommCellId = 2
			AND EntityId = @l_SPId
AND EntityType = 1
AND propertyName = 'StreamsToHoldForLogBackups'
	IF @@ROWCOUNT = 0
		INSERT INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, created, modified)
VALUES (@l_SPId, 1, 'StreamsToHoldForLogBackups', 1, @i_numStreams, @l_now, @l_now)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		SELECT 'Successfully set dedicated streams on StoragePolicy [' + @i_SPName + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetLogStreamsOnStoragePolicy')
	delete from GxQscripts where name = 'QS_SetLogStreamsOnStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetLogStreamsOnStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetLogStreamsOnStoragePolicy'
GO

insert into GXDBVersions values(2, 'QS_SetLogStreamsOnStoragePolicy',  '00000000000000000000', 'QS_SetLogStreamsOnStoragePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetLogStreamsOnStoragePolicy',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn SetLogStreamsOnStoragePolicy -si "StoragePolicy Name" -si "Number of streams to dedicate for log backups"'
)
GO

