

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetLimitRunningJobs.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetLimitRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_SetLimitRunningJobs')
	drop procedure QS_SetLimitRunningJobs
IF EXISTS (select * from GxQscripts where name='QS_SetLimitRunningJobs')
	delete from GxQscripts where name = 'QS_SetLimitRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetLimitRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_SetLimitRunningJobs'
GO
print '... Creating Procedure: QS_SetLimitRunningJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetLimitRunningJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 NVARCHAR(255) = '',
  @param2 NVARCHAR(255) = '',
  @param3 INTEGER = NULL
AS
SET NOCOUNT ON
--*******-----------
--CONVENIENCE DEFS--
--************----
DECLARE @clientname NVARCHAR(255) = ''
DECLARE @attrName NVARCHAR(255) = ''
DECLARE @newAttrValue NVARCHAR(255) = ''
DECLARE @dbval  NVARCHAR(255) = ''
DECLARE @bitVal INTEGER = 0
DECLARE @oldIntVal INTEGER = 0
DECLARE @newIntVal INTEGER = 0
DECLARE @ClientID INTEGER = 0
DECLARE @NoParams  NVARCHAR(3) = ''
DECLARE @errorCode  INTEGER = 0
DECLARE @errorString  NVARCHAR(255) = ''
DECLARE @scriptName  NVARCHAR(255) = ''
DECLARE @nowtime  INTEGER = 0
SET @NoParams = ''
SET @ErrorCode = 0
SET @ErrorString = N'Succeeded'
SET @scriptName = N'SetLimitRunningJobs'
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
--Check whether all params are passed--
IF (@param1 = @NoParams)
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 1st param must be client name. Please see usage.'
	GOTO ARGS_ERROR
END
IF (@param2 = @NoParams) OR (@param2 NOT IN (N'LimitJobs' , N'DataCount', N'LogCount', N'Exclude', N'View'))
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 2nd param is not specified or invalid. Please see usage.'
	GOTO ARGS_ERROR
END
IF (@param2 <> N'View')
BEGIN
	IF (@param3 IS null)
	BEGIN
		SET @ErrorCode = 1
		SET @ErrorString = 'Error. 3nd param is not specified. Please see usage.'
		GOTO ARGS_ERROR
	END
	ELSE IF (@param2 IN (N'DataCount', N'LogCount') AND @param3 = 0)
	BEGIN
		SET @ErrorCode = 1
		SET @ErrorString = 'Error. 3nd param cannot be 0 for job count. Please see usage.'
		GOTO ARGS_ERROR
	END
	ELSE IF (@param2 IN (N'Exclude', N'LimitJobs') AND @param3 NOT IN(1,0) )
	BEGIN
		SET @ErrorCode = 1
		SET @ErrorString = 'Error. 3nd param cannot be other than 0 or 1 for this option. Please see usage.'
		GOTO ARGS_ERROR
	END
END
--Validation of client--
SET @clientname = @param1
SET @newAttrValue = @param3
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientname),0)
IF @ClientID = 0
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Invalid client[' + @clientname + '] specified.'
	GOTO ARGS_ERROR
END
-- If it is just view print the results and quit.
BEGIN TRAN
	BEGIN TRY
		IF @param2 <> N'View'
		BEGIN
			-- Determine the correct attribute name
			SET @attrName = CASE @param2
							WHEN N'DataCount' THEN 'Throttle Jobs - Data Threshold'
							WHEN N'LogCount' THEN 'Throttle Jobs - Log Threshold'
							ELSE 'Throttle Jobs Enabled'
							END
				SELECT @dbVal = attrVal FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = @attrName AND modified = 0
				IF @dbVal IS NOT NULL
				BEGIN
					-- These 2 are bits in the same option and so should be handled separately.
					IF @param2 IN (N'LimitJobs', N'Exclude')
					BEGIN
						SET @bitVal = CASE @param2
											  WHEN N'LimitJobs' THEN 0x1
											  WHEN N'Exclude' THEN 0x2
											  END
						SET @OldIntVal = CAST(@dbVal AS INTEGER) & @bitVal
						IF @param3 <> 0
							SET @newIntVal = @bitVal
						IF @oldIntVal = @NewIntVal
							GOTO PRINTRESULTS
						SET @oldIntVal = CAST(@dbVal AS INTEGER) ^ @bitVal
						SET @NewIntVal = @oldIntVal | @NewIntVal
					END
					ELSE
					BEGIN
						IF @dbVal = @newAttrValue
							GOTO PRINTRESULTS
					END
					-- This means property is modified..
					UPDATE APP_ClientProp
					SET modified = @nowtime
					WHERE componentNameId = @ClientID AND attrName = @attrName AND modified = 0
				END
				-- INSERT NEW ONE ANYWAY
				BEGIN
					IF @param2 IN (N'LimitJobs', N'Exclude')
						INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
						VALUES (@ClientID , @attrName, 10, CAST(@NewIntVal AS NVARCHAR(255)), @nowtime , 0, 0)
					ELSE
						INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
						VALUES (@ClientID , @attrName, 7, @newAttrValue, @nowtime , 0, 0)
				END
		END
PRINTRESULTS:
		-- Print the results anyway ---
		DECLARE @outPut TABLE
		( value		NVARCHAR(MAX))
		INSERT INTO @outPut
		VALUES(N'*************************')
		-- Limit Running Jobs
		SET @dbVal = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = 'Throttle Jobs Enabled' AND modified = 0), '')
		INSERT INTO @outPut
		VALUES('Limit Simultaneous Running Jobs : [' + CASE @dbVal
													  WHEN '3' THEN 'Yes'
													  WHEN '1' THEN 'Yes'
													  ELSE 'No'
													  END
													  + '].')
		IF @dbVal IN ('3', '1')
		BEGIN
			-- Max Data Jobs
			SET @dbVal = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = 'Throttle Jobs - Data Threshold' AND modified = 0), '1')
			INSERT INTO @outPut
			VALUES('Max Data Jobs : [' + @dbVal + '].')
			--Max Log Jobs
			SET @dbVal = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = 'Throttle Jobs - Log Threshold' AND modified = 0), '1')
			INSERT INTO @outPut
			VALUES('Max Log Jobs : [' + @dbVal + '].')
			-- Exclude Immediate Jobs
			SET @dbVal = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = 'Throttle Jobs Enabled' AND modified = 0), '')
			INSERT INTO @outPut
			VALUES('Exclude Immediate Jobs : [' + CASE @dbVal
												 WHEN '3' THEN 'Yes'
												 ELSE 'No'
												 END
												 + '].')
		END
		INSERT INTO @outPut
		VALUES(N'*************************')
		SELECT value AS " Current Settings:" FROM @outPut
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO ARGS_ERROR
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@Param1 + ', '+@Param2 + ', ' + CAST(@param3 AS NVARCHAR(255))
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetLimitRunningJobs')
	delete from GxQscripts where name = 'QS_SetLimitRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetLimitRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_SetLimitRunningJobs'
GO

insert into GXDBVersions values(2, 'QS_SetLimitRunningJobs',  '00000000000000000000', 'QS_SetLimitRunningJobs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetLimitRunningJobs',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		Qscript to enable\disable Limit Simultaneous Running Jobs on a client with settings.'
 + CHAR(10) + '			qoperation execscript -sn SetLimitRunningJobs.sql -si <clientName> -si <param name> -si <value>
'
 + CHAR(10) + '-- 		To enable the option to limit running jobs for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''LimitJobs'' -si 1'
 + CHAR(10) + '-- 		To disable the option to limit running jobs for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''LimitJobs'' -si 0'
 + CHAR(10) + '-- 		To set the maximum data job count as 5 for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''DataCount'' -si 5'
 + CHAR(10) + '-- 		To set the maximum log job count as 3 for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''LogCount'' -si 3'
 + CHAR(10) + '-- 		To enable the option to exclude immediate jobs for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''Exclude'' -si 1'
 + CHAR(10) + '-- 		To disable the option to exclude immediate jobs for myclient: '
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''Exclude'' -si 0'
 + CHAR(10) + '-- 		To view current settings for myclient:'
 + CHAR(10) + '-- 			qoperation execscript -sn SetLimitRunningJobs.sql -si ''myclient'' -si ''View'' '
)
GO

