

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetLibraryProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetLibraryProperty.sp,v $ $Id: QS_SetLibraryProperty.sp,v 1.1.4.7 2020/09/30 12:27:14 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_setLibraryProperty')
BEGIN
	print '>>> Drop Stored Procedure: QS_setLibraryProperty <<<'
	drop procedure QS_setLibraryProperty
END
IF EXISTS (select * from GxQscripts where name='QS_setLibraryProperty')
	delete from GxQscripts where name = 'QS_setLibraryProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setLibraryProperty')
	delete from GXDBVersions where aliasname = 'QS_setLibraryProperty'
GO
print '... Creating Procedure: QS_setLibraryProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setLibraryProperty
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @libraryName varchar(1024) = '',
  @optionName varchar(1024) = '',
  @primaryInputParam varchar(1024) = '',
  @optionalInputParam varchar(1024) = ''
AS
Set NOCOUNT ON
declare @option int = 0
declare @value varchar(max) = ''
 ---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setLibraryProperties'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
declare @libID int			= 0
declare @nvalue int				= 0
declare @oldValue1 varchar(1024)=''
declare @oldValue2 varchar(1024)=''
declare @outStatement 			varchar(256)
set @outStatement				=''
DECLARE @userId 				integer
set		@userId					= 0
------------------------------------------------------------------
begin tran
if(@libraryName = @NoParameter or @optionName = @NoParameter or @primaryInputParam = @NoParameter)
begin
 set @localErrorMsg = 'Error: Insufficient command line parameters'
 set @localErrorMsg += CHAR(13) +'Please refer to the readme file and retry with necessary parameters'
 SET	@lastError		=	1
 GOTO SCRIPT_EXIT
end
 set @option =
	case lower(@optionName)
	when lower('changename') then 1
	when lower('enablelibrary') then 2
	when lower('archfilereadonly') then 3
	when lower('mounttimeout') then 4
	when lower('unmounttimeout') then 5
	when lower('autoadddatapath') then 6
	when lower('hardwaresingleinstancing') then 7
	when lower('preventaccidentaldel') then 8
	when lower('spillnfill') then 9
	when lower('setwriters') then 10
	when lower('lowWaterMark') then 11
	when lower('warningWaterMark') then 12
	when lower('daysToRunOutOfSpace') then 13
	when lower('startAging') then 14
	when lower('stopAging') then 15
	when lower('MarkLibraryOfflineForMaintenance') then 16
	when lower('markMediaAsAppendable') then 17
	when lower('useAppendableMEdia') then 18
	when lower('startNewMediaWhenMediaExported') then 19
	when lower('startNewMediaOnMediaGettingStuck') then 20
	when lower('configureVMSE') then 21
	when lower('useVMSforDataProtection') then 22
	when lower('resetContainerWhenAssignedMediaReAppears') then 23
	when lower('resetExportLocationWhenAssignedMediaReAppears') then 24
	when lower('MarkLibraryBrokenWhenErrorTHresholdCrossed') then 25
	when lower('verifyAccessPathUsingSerialNumber') then 26
	when lower('checkForCleaningMediaInDrive') then 27
	when lower('CheckForTapeAlerts') then 28
	when lower('driveNeedsCleaningOnCRCErrors') then 29
	when lower('skipUnloadDriveForAutoLoaders') then 30
	when lower('detectAndUpdateMediaTypeWhenMediaLoaded') then 31
	when lower('AutoDriveReplacementwhenNewDeviceIsDetected') then 32
	when lower('SCSIReservaionType') then 33
	when lower('AutoCleaningOnSenseCode') then 34
	when lower('AutoCleaningOnThreshholdOverflow') then 35
	when lower('AutoCleaningWaitingDays') then 36
	when lower('continueUseEvenIfCleaningNeededDuringRestore') then 37
	when lower('OverWriteMediaOnContentVerificationFail') then 38
	when lower('preventDifferentVendorMediaUsage') then 39
	when lower('OverWriteMediaFromDifferentCommCell') then 40
	when lower('AutoDiscoveryInDefaultScratchPool') then 41
	when lower('AutoRecoveryWhenMediaIsStuck') then 42
	when lower('RemoveMediaWhenDriveUnloadFail') then 43
	when lower('UnmountAfterPeriod') then 44
	when lower('AutoUpdateBarcodesOnFirmwareCHanges') then 45
	when lower('RetryReadOnSCSIErrors') then 46
	when lower('ReadRetryIntervalonSCSIErrors') then 47
	when lower('ReadRetryAttemptsonSCSIErrors') then 48
	when lower('ShowPopUpsonCommCellConsole') then 49
	when lower('enableUseOfDifferentScratchMedia') then 50
	when lower('CheckForMediaChange') then 51
	when lower('MediaChangeCheckInterval') then 52
	when lower('overwriteMediaNotWrittenInDays_Hours') then 53
	when lower('OverwriteAfter') then 54
	when lower('UsePnPWhenBlank') then 55
	when lower('MinimumUsableSize') then 56
	when lower('SubmitFullScanOnFindingEmptyBarcodes') then 57
	when lower('ConfigParams') then 58
	when lower('StartAndStopAgingThreshHolds') then 59
	when lower('UnloadMediaInStandAloneWhenDifferentMediaRequired') then 60
	when lower('DonotLoadEjectedMedia') then 61
	when lower('unMountMedia') then 62
	when lower('DisableForWriteAtLowWatermark') then 63
	when lower('EnableLibImmutable') then 64
 end
 --Existence of table and fetching of top 1 userId is done for safety measures
 IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
 BEGIN
      SET @localErrorMsg = 'Error, no logged in user found'
      Set @lastError = 1
      goto   SCRIPT_EXIT
 END
 SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
 IF @userId = 0
 BEGIN
      SET @localErrorMsg = 'Error, no logged in user found'
      Set @lastError = 1
      goto   SCRIPT_EXIT
 END
 set @libID = isnull((select LibraryId from MMLibrary where AliasName = LTRIM(RTRIM(@libraryName))),0)
 if (@libID = 0)
 begin
	set @localErrorMsg =  'Error: Library not found'
	set @lastError = 2
	GOTO SCRIPT_EXIT
 end
 -- User Permission Check Code Starts
 IF OBJECT_ID('tempdb.dbo.#checkPermissionOnEntityTable') IS NOT NULL
 	DROP TABLE #checkPermissionOnEntityTable
 CREATE TABLE #checkPermissionOnEntityTable
 (
 	permissionId INT
 )
EXEC sec_getPermissionsOnEntity '#checkPermissionOnEntityTable',@userId,9,@libId
 DECLARE @ClientId int = 0
DECLARE cursor_ CURSOR
  LOCAL STATIC READ_ONLY FORWARD_ONLY
  FOR
  select ClientId from MMDrivePool DP inner join MMMasterPool  MP on DP.MasterPoolId = MP.MasterPoolId where MP.LibraryId = @libId
  UNION
  select ClientId from MMLibraryController where LibraryId = @libID
  OPEN cursor_
FETCH NEXT FROM cursor_ INTO @ClientId
WHILE @@FETCH_STATUS = 0
BEGIN
EXEC sec_getPermissionsOnEntity '#checkPermissionOnEntityTable',@userId,11,@ClientId
    FETCH NEXT FROM cursor_ INTO @ClientId
END
CLOSE cursor_
DEALLOCATE cursor_
IF NOT EXISTS (select * from #checkPermissionOnEntityTable where permissionId in (1,8,11,10))--  select id from UMPermissions where permissionName in (EV_SCHEDULE_ADMIN_NAME, EV_MANAGE_LIBRARY_NAME, EV_ADMIN_LIBRARY_NAME, EV_MANAGE_MEDIAAGENT_NAME)))
 BEGIN
	IF OBJECT_ID('tempdb.dbo.#checkPermissionOnEntityTable') IS NOT NULL
		DROP TABLE #checkPermissionOnEntityTable
SET @localErrorMsg = 'Error, User Does Not Have the Required Capability for the Library ['+'Library Management'+'], [' + 'Library Administration'+'] for this Library. Or ['+'MediaAgent Management'+'] for this CommCell and this Operation'
    SET @lastError = 1
  GOTO   SCRIPT_EXIT
 END
 IF OBJECT_ID('tempdb.dbo.#checkPermissionOnEntityTable') IS NOT NULL
 	DROP TABLE #checkPermissionOnEntityTable
-- User Permission check code ends here
 set @option = ISNULL(@option,0)
 if(@option <1 or @option > 64)
 begin
	set @localErrorMsg = 'Error: Invalid Option'
	SET	@lastError		=	1
	GOTO SCRIPT_EXIT
 end
begin try
 if(@option = 1) -- Change Library Name (Common for all)
 begin
  if(LTRIM(RTRIM(@primaryInputParam)) not in (select AliasName from MMLibrary)) -- needs confirmation
  begin
  set @oldValue1 = @libraryName
  update MMLibrary
  set AliasName = LTRIM(RTRIM(@primaryInputParam))
  where LibraryId = @libID
  end
  else
  begin
  set @localErrorMsg = 'The library name specified is already present in the CommServe'
  SET	@lastError		=	3
  goto SCRIPT_EXIT
  end
  set @outStatement = 'Library Name changed'
 end
 if (@option = 2) -- Enable Disable a Library (Common for all)
 begin
	set @nvalue  = convert(int,@primaryInputParam)
	if( @nvalue != 0 and @nvalue != 1)
	begin
		set @localErrorMsg = 'Invalid input enter 1 to enable and 0 to disable the library'
		SET	@lastError		=	4
		goto SCRIPT_EXIT
	end
	select @oldValue1 = LibraryEnabled
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set LibraryEnabled = @nvalue
	where LibraryId = @libID
	set @outStatement = 'Library status changed'
 end
 if(@option = 3) -- Mark Archive File As Read Only (Magnetic and Cloud Only)
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 3))
	begin
		set @localErrorMsg = 'This Option is only available for Magnetic and Cloud Libraries'
		SET	@lastError		=	5
		GOTO SCRIPT_EXIT
	end
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	6
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 8388608 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute & ~8388608 -- MMS2_LIBRARY_MARK_CHUNK_READONLY
		where LibraryId = @libID
		set @outStatement = 'UnMarked Archive File As Read Only'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute |8388608  -- MMS2_LIBRARY_MARK_CHUNK_READONLY
		where LibraryId = @libID
		set @outStatement = 'Marked Archive File As Read Only'
	end
 end
 if(@option = 4) -- Set Mount TimeOut (common for all except pnp???)
 begin
	if(@libID  in (select LibraryID from MMLibrary where LibraryTypeId = 4))
	begin
		set @localErrorMsg = 'This option is not available for PnP Libraries'
		SET	@lastError		=	114
		GOTO SCRIPT_EXIT
	end
	set @nvalue  = convert(int,@primaryInputParam)
	if(@nvalue < 1)
		begin
			set @localErrorMsg = 'Please enter a value greater than 0 '
			set @lastError		=	115
			GOTO SCRIPT_EXIT
		end
	select @oldValue1 = MountTimeoutSec/60
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set MountTimeoutSec = (@primaryInputParam*60)
	where LibraryId = @libID
	set @outStatement = 'Mount TimeOut Changed'
 end
 if(@option = 5) -- Set UnMount TimeOut( common for all except pnp??)
 begin
	if(@libID  in (select LibraryID from MMLibrary where LibraryTypeId = 4))
	begin
		set @localErrorMsg = 'This option is not available for PnP Libraries'
		SET	@lastError		=	116
		GOTO SCRIPT_EXIT
	end
	set @nvalue  = convert(int,@primaryInputParam)
	if(@nvalue < 1)
	begin
		set @localErrorMsg = 'Please enter a value greater than 0 '
		set @lastError		=	117
		GOTO SCRIPT_EXIT
	end
	select @oldValue1 = UnmountTimeoutSec/60
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set UnmountTimeoutSec = (@primaryInputParam*60)
	where LibraryId = @libID
	set @outStatement = 'UnMount TimeOut Changed'
 end
 if(@option = 6) -- AutoMatically Add DataPaths for New Drive Pools Configured (All except cloud)
 begin
	if(@libID in (select LibraryID from MMMountPath where MountPathTypeId = 7)) -- 7 : cloud
	begin
		set @localErrorMsg = 'Cloud libraries dont support this option'
		SET	@lastError		=	7
		GOTO SCRIPT_EXIT
	end
	set @nvalue  = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	8
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & Cast(~Cast(2147483648 as bigint) +1 as int) != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute & ~Cast(~Cast(2147483648 as bigint) +1 as int) -- MMS2_LIBRARY_AUTO_ADD_DATAPATHS
		where LibraryId = @libID
		set @outStatement = 'Disabled AutoMatically Add DataPaths for New Drive Pools Configured'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | Cast(~Cast(2147483648 as bigint) +1 as int)  -- MMS2_LIBRARY_AUTO_ADD_DATAPATHS
		where LibraryId = @libID
		set @outStatement = 'Enabled AutoMatically Add DataPaths for New Drive Pools Configured'
	end
 end
 if(@option = 7) -- Disks In this Library Support single instancing (In Magnetic Only)
 begin
	if(@libID not in (select LibraryID from MMMountPath where MountPathTypeId = 4)) -- 4 = magnetic
	begin
		set @localErrorMsg = 'This option is available for Magnetic Library Only'
		SET	@lastError		=	9
		GOTO SCRIPT_EXIT
	end
	if exists (select * from MMLibrary ML inner join MMMountPath MP
			on MP.LibraryId =  ML.LibraryId  inner join MMVolume MV ON MV.CurrMountPathId = MP.MountPathId
		where ML.LibraryId = @libID)
	begin
		set @localErrorMsg = 'This option cannot be changed for Libraries having Valid Data'
		SET	@lastError		=	9
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	10
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 268435456 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~268435456 -- MMS2_LIBRARY_SINGLE_INSTANCE_DATA
		where LibraryId = @libID
		set @outStatement = 'Disabled Disks In this Library Support Hardware single instancing '
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 268435456  -- MMS2_LIBRARY_SINGLE_INSTANCE_DATA
		where LibraryId = @libID
		set @outStatement = 'Enabled Disks In this Library Support Hardware single instancing '
	end
 end
 if(@option = 8) -- Set/Unset prevent accidental deletion (Mag Only)
 begin
	if (@libID not in (select LibraryId from MMMountPath where MountPathTypeId = 4))
	begin
		set @localErrorMsg = 'This Option is available only for Magnetic Libraries'
		SET	@lastError		=	11
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	12
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 262144 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes & ~262144 -- MMS2_LIBRARY_EXT_PREVENT_ACCIDENT_DELETE
		where LibraryId = @libID
		set @outStatement = 'Disabled prevent accidental deletion'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 262144  -- MMS2_LIBRARY_EXT_PREVENT_ACCIDENT_DELETE
		where LibraryId = @libID
		set @outStatement = 'Enabled prevent accidental deletion '
	end
 end
 if(@option = 9) --Fill and SPill/Spill and Fill (Mag and Cloud)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 3))
	begin
		set @localErrorMsg = 'This option is available for Magnetic and Cloud Libraries Only'
		SET	@lastError		=	13
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	14
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 1 > 0 then 1 else 0 end , @oldValue2 = case when ExtendedAttributes & 4194304 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~ 1 & ~ 4194304-- MMS2_LIBRARY_EXT_ROUND_ROBIN_MOUNT_PATH     MMS2_LIBRARY_EXT_PREFER_MOUNTHPATH_WITH_MORE_FREE_SPACE
		where LibraryId = @libID
		set @outStatement = 'Enabled Fill and SPill mode'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes | 1  -- MMS2_LIBRARY_EXT_ROUND_ROBIN_MOUNT_PATH
		where LibraryId = @libID
		set @outStatement = 'Enabled Spill and Fill mode/Round Robin mode'
		if(@optionalInputParam = '1')
		begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes | 4194304 -- MMS2_LIBRARY_EXT_PREFER_MOUNTHPATH_WITH_MORE_FREE_SPACE
		where LibraryId = @libID
		set @outStatement = @outStatement + ' and Enabled "Prefer MountPaths with more free space"'
		end
		else if (@optionalInputParam = '0')
		begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~ 4194304 -- MMS2_LIBRARY_EXT_PREFER_MOUNTHPATH_WITH_MORE_FREE_SPACE
		where LibraryId = @libID
		set @outStatement = @outStatement + ' and Disabled "Prefer MountPaths with more free space"'
		end
		else if(@optionalInputParam != @noParameter)
		begin
			set @localErrorMsg = 'Value is not correct for fourth parameter either give 0 to disable or 1 to enable'
			SET	@lastError		=	14
			GOTO SCRIPT_EXIT
		end
	end
 end
 if(@option = 10) -- Mount Path Allocation Policy (Mag and Cloud only)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 3))
	begin
		set @localErrorMsg = 'This option is available for Magnetic and Cloud Libraries Only'
		SET	@lastError		=	15
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if((@nvalue != -1 and @nvalue < 1 ) or @libID  in(select LibraryId from MMLibrary where LibraryTypeId = '1'))
	begin
		set @localErrorMsg = ('Incorrect number of writers specified please insert  "-1" for using maxumum writers or a value greater than 0 for setting a custom number of writers.' + CHAR(13)+ 'This operation is not available for tape drives')
		SET	@lastError		=	16
		GOTO SCRIPT_EXIT
	end
	if(@nvalue > 999)
	begin
		print 'Value is more than maximum allowed writers, the number of writers will be set to maximum'
		set @nvalue = -1
	end
	select @oldValue1 = case when MaxSwitchForHost = -1 then 'Maximum' else cast(MaxSwitchForHost as varchar(1024)) end
	from MMMasterPool
	where LibraryId = @libID
	update MMMasterPool
	set MaxSwitchForHost =  @nvalue
	where LibraryId = @libID
	set @outStatement = 'Mount Path Allocation Policy: Number of Writers Changed'
	set @primaryInputParam = case when @primaryInputParam = '-1' then 'Maximum' else @primaryInputParam end
 end
 if(@option = 11) -- Space ThreshHolds - Low Disk SPace WaterMark dont use (Mag Only) dont use
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if(@nvalue <=0 or @nvalue > 100) -- 4 mag
	begin
		set @localErrorMsg = 'Please Enter a correct percentage value between 1 to 100'
		SET	@lastError		=	17
		GOTO SCRIPT_EXIT
	end
	if(@libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)))
	begin
		set @localErrorMsg = 'This option only available for Magnetic Library'
		SET	@lastError		=	17
		GOTO SCRIPT_EXIT
	end
	declare @OOSDays int = (select OutOfSpaceAlertInDays from MMLibrary where LibraryId = @libID)
	if(@OOSDays != 0)
	begin
		update MMLibrary
		set WarningWaterMark = 30 , OutOfSpaceAlertInDays = 0 -- Default Value
		where LibraryId = @libID
	end
	select @oldValue1 = LowWaterMarkMB
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue > (select WarningWatermark from MMLibrary where @libID = LibraryId))
	begin
	 update MMLibrary
	 set WarningWaterMark = @nvalue
	 where @libID = LibraryId
	end
	update MMLibrary
	set LowWaterMarkMB = @nvalue
	where LibraryId = @libID
	set @outStatement = 'Disk FreePercentage Low Disk SPace WaterMark changed'
 end
 if(@option = 12)  -- Space ThreshHolds - Disk Free Percentage Warning WaterMark (MagOnly) dont use
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if(@nvalue <10 or @nvalue > 100) -- 4 mag
	begin
		set @localErrorMsg = 'Please Enter a correct percentage value between 10 to 100'
		SET	@lastError		=	18
		GOTO SCRIPT_EXIT
	end
	if(@libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)))
	begin
		set @localErrorMsg =  'This option only available for Magnetic Library'
		SET	@lastError		=	18
		GOTO SCRIPT_EXIT
	end
	declare @OOSDays1 int = (select OutOfSpaceAlertInDays from MMLibrary where LibraryId = @libID)
	if(@OOSDays1 != 0)
	begin
		update MMLibrary
		set LowWaterMarkMB = 15 , OutOfSpaceAlertInDays = 0-- Default Value
		where LibraryId = @libID
	end
	declare @lowWM int = (select LowWaterMarkMB from MMLibrary where LibraryID = @libID)
	if(@nvalue< @lowWM)
	begin
		print 'Warning Watermark % cant be less than Low WaterMark %, Warning WaterMark Will be set to the Low WaterMark Value'
		set @nvalue = @lowWM
		set @primaryInputParam = @lowWM
	end
	select @oldValue1 = WarningWaterMark
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set WarningWaterMark = @nvalue
	where LibraryId = @libID
	set @outStatement = 'Disk FreePercentage Warning WaterMark changed'
 end
 if(@option = 13)  -- Space ThreshHolds - Warning Days (MagOnly)  dont use
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if(@nvalue <=0 or @nvalue > 9999 ) -- 4 mag
	begin
		set @localErrorMsg = 'Please Enter a correct number of days between 1 to 9999'
		SET	@lastError		=	19
		GOTO SCRIPT_EXIT
	end
	if(@libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)))
	begin
		set @localErrorMsg =  'This option only available for Magnetic Library'
		SET	@lastError		=	18
		GOTO SCRIPT_EXIT
	end
	declare @LowWaterMarkMB int = (select LowWaterMarkMB from MMLibrary where LibraryId = @libID)
	if(@LowWaterMarkMB != 0)
	begin
		update MMLibrary
		set LowWaterMarkMB = 0 , WarningWaterMark = 0
		where LibraryId = @libID
	end
	select @oldValue1 = OutOfSpaceAlertInDays
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set OutOfSpaceAlertInDays = @nvalue
	where LibraryId = @libID
	set @outStatement = 'Warning Days changed'
 end
 if(@option = 14) -- ThreshHoldsForManaged Disk SPace -Start Aging threshhold (Mag Only)
 begin
	set @nvalue =  convert(int,@primaryInputParam)
	declare @oldThreshPerc int = (select ThresholdPercentage from MMLibrary where LibraryId = @libID)
	declare @oldthreshVariation int =  (select ThresholdVariation from MMLibrary where LibraryId = @libID)
	declare @threshVariation int = @nvalue + @oldthreshVariation - @oldThreshPerc
	if @libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)) -- 4 mag
	begin
	set @localErrorMsg = 'This OPtion is only available for magnetic Libraries'
	set @lasterror = 20
	goto SCRIPT_EXIT
	end
	if(@nvalue < 10 or @nvalue > 100 or @threshVariation < 1)
	begin
		set @localErrorMsg = 'Please Enter a correct percentage value between 10 to 100 and greater than stop aging ThreshHold value :'+ convert(nvarchar, @oldThreshPerc- @oldthreshVariation)
		SET	@lastError		=	21
		GOTO SCRIPT_EXIT
	end
	set @oldValue1 = @oldThreshPerc
	update MMLibrary
	set ThresholdPercentage = @nvalue , ThresholdVariation = @threshVariation
	where LibraryId = @libID
	set @outStatement = 'Start Aging threshhold changed'
 end
 if(@option = 15) -- ThreshHoldsForManaged Disk SPace -Stop Aging threshhold (Mag Only)
 begin
	set @nvalue =  convert(int,@primaryInputParam)
	declare @oldThreshPerc1 int = (select ThresholdPercentage from MMLibrary where LibraryId = @libID)
	declare @oldthreshVariation1 int =  (select ThresholdVariation from MMLibrary where LibraryId = @libID)
	declare @threshVariation1 int = @oldthreshPerc1 - @nvalue
	if @libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)) -- 4 mag
	begin
	set @localErrorMsg = 'This OPtion is only available for magnetic Libraries'
	set @lasterror = 22
	goto SCRIPT_EXIT
	end
	if(@nvalue < 5 or @nvalue > 98 or @threshVariation1 < 1)
	begin
		set @localErrorMsg = 'Please Enter a correct percentage value between 5 to 98 and lesser than start aging ThreshHold value :'+ convert(nvarchar, @oldThreshPerc1)
		SET	@lastError		=	23
		GOTO SCRIPT_EXIT
	end
	set @oldValue1 = @oldThreshPerc1 - @oldthreshVariation1
	update MMLibrary
	set ThresholdVariation = @threshVariation1
	where LibraryId = @libID
	set @outStatement = 'Stop Aging threshhold changed'
 end
 if (@option = 16) -- Mark Offline For Maintenance (Tape and PnP libraries)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in ( 1 , 4)))
	begin
		set @localErrorMsg = 'This option is available for Tape and PnP Libraries Only'
		SET	@lastError		=	24
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to Enable OR 1 to Mark Offline For Maintenance '
	 SET	@lastError		=	25
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 512 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~512 -- MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE
		where LibraryId = @libID
		set @outStatement = 'Disabled Mark Offline For Maintenance'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 512  -- MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE
		where LibraryId = @libID
		set @outStatement = 'Enabled Mark Offline For Maintenance'
	end
 end
 if (@option = 17) -- Mark Media as Appendable (Tape,StandAlone and PnP libraries)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in ( 1 , 4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	26
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to Unmark OR 1 to Mark media as Appendable '
	 SET	@lastError		=	27
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 262144 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~262144 -- MMS2_LIBRARY_MARK_APPENDABLE
		where LibraryId = @libID
		set @outStatement = 'Disabled Mark Media as Appendable'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 262144  -- MMS2_LIBRARY_MARK_APPENDABLE
		where LibraryId = @libID
		set @outStatement = 'Enabled Mark Media as Appendable'
	end
 end
 if (@option = 18) -- To set use appendable media and use within days (Tape,StandAlone and PnP libraries)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in ( 1 , 4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	28
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to not use Appendable Media OR 1 to use Appendable Media '
	 SET	@lastError		=	29
	 GOTO SCRIPT_EXIT
	end
if((select LibraryAttribute from MMLibrary where LibraryID = @libID ) & 262144 = 0)
	begin
		set @localErrorMsg = 'To Set/Unset this option, please enable the option "Mark Media As Appendable"'
		SET	@lastError		=	29
		GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 512 != 0 then 1 else 0 end, @oldValue2 = UseWithinDaysinSec/24/60/60
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~512 --MMS2_LIBRARY_MEDIA_APPEND_ABLE
		where LibraryId = @libID
		set @outStatement = 'Disabled use appendable media'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 512  -- MMS2_LIBRARY_MEDIA_APPEND_ABLE
		where LibraryId = @libID
		if(@optionalInputParam = @noParameter)
		begin
			set @optionalInputParam = '14' -- Default number of days in GUI
		end
		update MMLibrary
		set UseWithinDaysinSec = convert(int,@optionalInputParam)*60*60*24
		where LibraryId = @libID
		set @outStatement = 'Use appendable media and use within days set'
	end
 end
 if (@option = 19) -- Start a new Media on Media Export(Tape  Only)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	30
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to start a new media on media export or 0 to not start a new media on media export '
	 SET	@lastError		=	31
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 128 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~128 -- MMS2_LIBRARY_MARK_MEDIA_FULL_ON_EXPORT
		where LibraryId = @libID
		set @outStatement = 'Disabled Start a new Media on Media Export'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 128  -- MMS2_LIBRARY_MARK_MEDIA_FULL_ON_EXPORT
		where LibraryId = @libID
		set @outStatement = 'Enabled - Start New Media when required media is exported'
	end
 end
 if (@option = 20) -- Start a new Media on Media getting Stuck in Drive(Tape  Only)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	32
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to start a new Media if  Media is Stuck in Drive or 0 to not start a new media if  Media is Stuck in Drive '
	 SET	@lastError		=	33
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 256 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~256 -- MMS2_LIBRARY_MARK_MEDIA_FULL_ON_STUCK
		where LibraryId = @libID
		set @outStatement = 'Disabled Start a new Media on Media getting Stuck in Drive'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 256  -- MMS2_LIBRARY_MARK_MEDIA_FULL_ON_STUCK
		where LibraryId = @libID
		set @outStatement = 'Enabled Start a new Media on Media getting Stuck in Drive'
	end
 end
 if(@option = 21) -- Enable and configure virtual mail slot for export (Tape Only)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	34
		GOTO SCRIPT_EXIT
	end
	if(@optionalInputParam = @NoParameter and @primaryInputParam != '0')
	begin
		set @localErrorMsg = 'You need to enter fourth paramater too for specifying the direction'
		SET	@lastError		=	35
		GOTO SCRIPT_EXIT
	end
	if(upper(@optionalInputParam) not in ('','UP','DOWN'))
	begin
		set @localErrorMsg = 'Enter a correct direction :  UP or DOWN'
		SET	@lastError		=	36
		GOTO SCRIPT_EXIT
	end
	declare @direction int = 0
	set @direction =
		( CASE
		  WHEN (upper(@optionalInputParam) = 'UP') then 1
		  WHEN (upper(@optionalInputParam) = 'DOWN') then 2
		  else 1
		  END
		)
	set @nvalue = convert(int,@primaryInputParam)
	if(@nvalue <0 or @nvalue > 50)
	begin
		set @localErrorMsg = 'Please Enter a correct slot number(1 to 50), 0 to disable Virual Mail Slot'
		SET	@lastError		=	37
		GOTO SCRIPT_EXIT
	end
	select @oldValue2 = case when (VMSDirection = 1) then 'UP' when (VMSDirection = 2) then 'DOWN' else 'DISABLED' end, @oldValue1 = (
																	select slots.rownumber
																	from (select ROW_NUMBER() OVER  (ORDER BY s.slotID ASC) AS rownumber,s.ElementAddress from MMLibrary mml inner join MMBay mmb on mml.LibraryId = mmb.LibraryId inner join MMSlot s on mmb.BayId = s.BayId where mml.LibraryId = @libId) as slots
																	where slots.ElementAddress = MML.StartVMSElementAddress
												)
	from MMLibrary MML
	where LibraryId = @libID
	set @oldValue1 = ISNULL(@oldValue1,0)
	if(@nvalue = 0)
	begin
		update MMLibrary
		set VMSDirection = 0, StartVMSElementAddress = 0
		where LibraryID = @libID
		set @outStatement = 'Disabled virtual mail slot for export'
	end
	else
	begin
		update MMLibrary
		set VMSDirection = @direction, StartVMSElementAddress = (
																	select ElementAddress
																	from (select ROW_NUMBER() OVER  (ORDER BY s.slotID ASC) AS rownumber,s.ElementAddress from MMLibrary mml inner join MMBay mmb on mml.LibraryId = mmb.LibraryId inner join MMSlot s on mmb.BayId = s.BayId where mml.LibraryId = @libId) as slots
																	where slots.rownumber = @nvalue
																)
																where LibraryId = @libID
		set @outStatement = 'Enabled and configured virtual mail slot for export'
	end
 end
 if (@option = 22) -- Use media in virtual mail slot for data protection (Tape Only)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	38
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to start a new Media if  Media is Stuck in Drive or 0 to not start a new media if  Media is Stuck in Drive '
	 SET	@lastError		=	39
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 32768 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~32768 -- MMS2_LIBRARY_USE_EXPORTABLE_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Use media in virtual mail slot for data protection Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 32768  -- MMS2_LIBRARY_USE_EXPORTABLE_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Use media in virtual mail slot for data protection Enabled'
	end
 end
 if (@option = 23) -- Reset container when assigned media re-appears in library(Tape,StandAlone  and PnP)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	40
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to disable "Reset container when assigned media re-appears in library" '
	 SET	@lastError		=	41
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 128 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~128 -- MMS2_LIBRARY_EXT_RESET_CONTAINER_ON_ASSIGNED_MED
		where LibraryId = @libID
		set @outStatement = 'Reset container when assigned media re-appears in library Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 128  -- MMS2_LIBRARY_EXT_RESET_CONTAINER_ON_ASSIGNED_MED
		where LibraryId = @libID
		set @outStatement = 'Reset container when assigned media re-appears in library Enabled'
	end
 end
 if (@option = 24) -- Reset export location when assigned media re-appears in library(Tape,StandAlone  and PnP)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	42
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to disable "Reset export location when assigned media re-appears in library" '
	 SET	@lastError		=	43
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 256 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~256 -- MMS2_LIBRARY_EXT_RESET_EXPORTLOCATION_ON_ASSIGNED_MED
		where LibraryId = @libID
		set @outStatement = 'Reset export location when assigned media re-appears in library Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 256  -- MMS2_LIBRARY_EXT_RESET_EXPORTLOCATION_ON_ASSIGNED_MED
		where LibraryId = @libID
		set @outStatement = 'Reset export location when assigned media re-appears in library Enabled'
	end
 end
 if (@option = 25) -- Mark Library/Drive broken when error threshold exceeded(Tape,StandAlone  and PnP)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	44
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to disable "Mark Library/Drive broken when error threshold exceeded" '
	 SET	@lastError		=	45
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 1024 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~1024 -- MMS2_LIBRARY_MARK_DRIVE_OFFLINE_ONERROR
		where LibraryId = @libID
		set @outStatement = 'Mark Library/Drive broken when error threshold exceeded Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 1024  -- MMS2_LIBRARY_MARK_DRIVE_OFFLINE_ONERROR
		where LibraryId = @libID
		set @outStatement = 'Mark Library/Drive broken when error threshold exceeded Enabled'
	end
 end
 if (@option = 26) -- Verify access path using Serial Number for Drive(Tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	46
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Verify access path using Serial Number for Drive" '
	 SET	@lastError		=	47
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 131072 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~131072 -- MMS2_LIBRARY_CHECK_FOR_SERIAL_NUMBER
		where LibraryId = @libID
		set @outStatement = 'Verify access path using Serial Number for Drive Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 131072  -- MMS2_LIBRARY_CHECK_FOR_SERIAL_NUMBER
		where LibraryId = @libID
		set @outStatement = 'Verify access path using Serial Number for Drive Enabled'
	end
 end
 if (@option = 27) -- Check for cleaning media loaded in Drive(Tape)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	48
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Check for cleaning media loaded in Drive" '
	 SET	@lastError		=	49
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 65536 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~65536 -- MMS2_LIBRARY_CHECK_FOR_CLEANING_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Check for cleaning media loaded in Drive Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 65536  -- MMS2_LIBRARY_CHECK_FOR_CLEANING_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Check for cleaning media loaded in Drive Enabled'
	end
 end
 if (@option = 28) -- Check for Tape Alerts(Tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	50
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Check for Tape Alerts" '
	 SET	@lastError		=	51
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 524288 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~524288 -- MMS2_LIBRARY_CHECK_TAPE_ALERT
		where LibraryId = @libID
		set @outStatement = 'Check for Tape Alerts Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 524288  -- MMS2_LIBRARY_CHECK_TAPE_ALERT
		where LibraryId = @libID
		set @outStatement = 'Check for Tape Alerts Enabled'
	end
 end
 if (@option = 29) -- Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	52
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors" '
	 SET	@lastError		=	53
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 33554432 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~33554432 -- MMS2_LIBRARY_MARK_DRIVE_NEEDS_CLEANING_ON_CRC_ERROR
		where LibraryId = @libID
		set @outStatement = 'Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 33554432  -- MMS2_LIBRARY_MARK_DRIVE_NEEDS_CLEANING_ON_CRC_ERROR
		where LibraryId = @libID
		set @outStatement = 'Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors Enabled'
	end
 end
 if (@option = 30) -- Skip unload drive for Autoloaders before unmounting media (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	54
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Skip unload drive for Autoloaders before unmounting media" '
	 SET	@lastError		=	55
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 32 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~32 -- MMS2_LIBRARY_EXT_SKIP_UNLOAD_DRIVE_BEFORE_UNMOUNT
		where LibraryId = @libID
		set @outStatement = 'Skip unload drive for Autoloaders before unmounting media Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 32  -- MMS2_LIBRARY_EXT_SKIP_UNLOAD_DRIVE_BEFORE_UNMOUNT
		where LibraryId = @libID
		set @outStatement = 'Skip unload drive for Autoloaders before unmounting media Enabled'
	end
 end
 if (@option = 31) -- Detect and update media type when media is loaded into the drive (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAloneLibraries Only'
		SET	@lastError		=	56
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Detect and update media type when media is loaded into the drive" '
	 SET	@lastError		=	57
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 64 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~64 -- MMS2_LIBRARY_EXT_SET_MEDIATYPE_DURING_RUNTIME
		where LibraryId = @libID
		set @outStatement = 'Detect and update media type when media is loaded into the drive Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 64  --MMS2_LIBRARY_EXT_SET_MEDIATYPE_DURING_RUNTIME
		where LibraryId = @libID
		set @outStatement = 'Detect and update media type when media is loaded into the drive Enabled'
	end
 end
 if (@option = 32) -- Enable Auto Drive Replacement when new device is detected during Mount (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	58
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Enable Auto Drive Replacement when new device is detected during Mount" '
	 SET	@lastError		=	59
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 16384 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~16384 -- MMS2_LIBRARY_EXT_ENABLE_AUTO_DRIVE_REPLACEMENT
		where LibraryId = @libID
		set @outStatement = 'Auto Drive Replacement when new device is detected during Mount Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 16384  -- MMS2_LIBRARY_EXT_ENABLE_AUTO_DRIVE_REPLACEMENT
		where LibraryId = @libID
		set @outStatement = 'Auto Drive Replacement when new device is detected during Mount Enabled'
	end
 end
 if (@option = 33) -- Use or don't SCSI-2/3 Reserve for contention resolution (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAloneLibraries Only'
		SET	@lastError		=	60
		GOTO SCRIPT_EXIT
	end
	set @nvalue = case WHEN (upper(@primaryInputParam) = 'SCSI-2') then 2 WHEN (upper(@primaryInputParam) = 'SCSI-3') then 3 when (upper(@primaryInputParam) = '0') then 0 else -1 end
	if (@nvalue not in (0,2,3))
	begin
	 set @localErrorMsg = 'Value is not correct either enter SCSI-3 or SCSI-2 or 0 to Disable '
	 SET	@lastError		=	61
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 2 != 0 then 'SCSI-2' when LibraryAttribute & 16777216!=0 then 'SCSI-3' else 'SCSI disabled' end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0) -- No SCSI
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~2 , LibraryAttribute = LibraryAttribute & ~16777216  -- MMS2_LIBRARY_USE_SCSI_RESERVE MMS2_LIBRARY_EXT_USE_SCSI2_RESERVE
		where LibraryId = @libID
		set @outStatement = 'Disabled Use SCSI'
		set @primaryInputParam = 'SCSI disabled'
	end
	else if (@nvalue = 2) -- USE SCSI-2
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 2 , LibraryAttribute =  LibraryAttribute & ~16777216 --MMS2_LIBRARY_USE_SCSI_RESERVE MMS2_LIBRARY_EXT_USE_SCSI2_RESERVE
		where LibraryId = @libID
		set @outStatement = 'USE SCSI-2 enabled'
	end
	else if (@nvalue = 3) -- USE SCSI-3
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes & ~2 , LibraryAttribute =  LibraryAttribute | 16777216 -- MMS2_LIBRARY_USE_SCSI_RESERVE MMS2_LIBRARY_EXT_USE_SCSI2_RESERVE
		where LibraryId = @libID
		set @outStatement = 'USE SCSI-3 enabled'
	end
 end
 if (@option = 34) -- Enable Auto-Cleaning: On sense code (tape,StandAlone and pnp)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and Pnp Libraries Only'
		SET	@lastError		=	62
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Enable Auto-Cleaning: On sense code" '
	 SET	@lastError		=	63
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 1 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~1 -- MMS2_LIBRARY_CLEAN_ON
		where LibraryId = @libID
		set @outStatement = 'Auto-Cleaning: On sense code Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 1  -- MMS2_LIBRARY_CLEAN_ON
		where LibraryId = @libID
		set @outStatement = 'Auto-Cleaning: On sense code Enabled'
	end
 end
 if (@option = 35) -- Enable Auto-Cleaning: Cleaning thresholds exceed (tape,StandAlone and pnp)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	64
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Enable Auto-Cleaning: Cleaning thresholds exceed" '
	 SET	@lastError		=	65
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 8192 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~8192 -- MMS2_LIBRARY_SET_DRIVE_CLEAN_ON_THRESHOLD
		where LibraryId = @libID
		set @outStatement = 'Auto-Cleaning: Cleaning thresholds exceed Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 8192  -- MMS2_LIBRARY_SET_DRIVE_CLEAN_ON_THRESHOLD
		where LibraryId = @libID
		set @outStatement = 'Auto-Cleaning: Cleaning thresholds exceed Enabled'
	end
 end
 if (@option = 36) -- Enable Auto Cleaning - Wait N day(s) after last cleaning (tape,StandAlone and pnp)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	66
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue < 0)
	begin
	 set @localErrorMsg = 'Incorrect Value, please give a number of days greater than 0 to set and 0 to unset this Option '
	 SET	@lastError		=	67
	 GOTO SCRIPT_EXIT
	end
	select @oldValue1 = DriveCleanIntervalInSec/(24*60*60)
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set DriveCleanIntervalInSec = @nvalue*24*60*60
	where LibraryId = @libID
	set @outStatement = 'Auto-Cleaning: day(s) after last cleaning Changed'
 end
 if (@option = 37) -- Continue using drive even if need cleaning during restore (tape,StandAlone and pnp)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	68
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Continue using drive even if need cleaning during restore" '
	 SET	@lastError		=	69
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 2048 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~2048 -- MMS2_LIBRARY_USE_DRIVES_NEEDING_CLEANING
		where LibraryId = @libID
		set @outStatement = 'Continue using drive even if need cleaning during restore Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 2048  -- MMS2_LIBRARY_USE_DRIVES_NEEDING_CLEANING
		where LibraryId = @libID
		set @outStatement = 'Continue using drive even if need cleaning during restore Enabled'
	end
 end
 if (@option = 38) -- Overwite media when content verification fails (tape,StandAlone and pnp)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4)))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	70
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Overwite media when content verification fails" '
	 SET	@lastError		=	71
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 16 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~16 -- MMS2_LIBRARY_IGNORE_OML_READ_ERRORS
		where LibraryId = @libID
		set @outStatement = 'Overwite media when content verification fails Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 16 , ExtendedAttributes = ExtendedAttributes & ~ 2048  --MMS2_LIBRARY_IGNORE_OML_READ_ERRORS  MMS2_LIBRARY_EXT_USE_ONLY_GALAXY_SPARES
		where LibraryId = @libID
		set @outStatement = 'Overwite media when content verification fails Enabled'
	end
 end
 if (@option = 39) -- Prevent use of tapes from a different backup vendor (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	72
		GOTO SCRIPT_EXIT
	end
	declare @ignoreOML int = 16 & (select LibraryAttribute from MMLibrary where @libID = LibraryId)
	if @ignoreOML != 0
	begin
		set @localErrorMsg = 'This option is not avaliable if the "Overwite media when content verification fails" is enabled '
		SET	@lastError		=	73
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Continue using drive even if need cleaning during restore" '
	 SET	@lastError		=	74
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 2048 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~2048 -- MMS2_LIBRARY_EXT_USE_ONLY_GALAXY_SPARES
		where LibraryId = @libID
		set @outStatement = 'Prevent use of tapes from a different backup vendor Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 2048  -- MMS2_LIBRARY_EXT_USE_ONLY_GALAXY_SPARES
		where LibraryId = @libID
		set @outStatement = 'Prevent use of tapes from a different backup vendor Enabled'
	end
 end
 if (@option = 40)  -- Overwite media when it is from different CommCell (tape,StandAlone and pnp)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4) ))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	75
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Overwite media when it is from different CommCell" '
	 SET	@lastError		=	76
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 32 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~32 -- MMS2_LIBRARY_OVERWRITE_WRONG_COMMCELL
		where LibraryId = @libID
		set @outStatement = 'Overwite media when it is from different CommCell Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 32  -- MMS2_LIBRARY_OVERWRITE_WRONG_COMMCELL
		where LibraryId = @libID
		set @outStatement = 'Overwite media when it is from different CommCell Enabled'
	end
 end
 if (@option = 41)  -- Enable Auto-Discovery of media into default scratch pool / auto stamp media drive (tape,StandALone n pnp)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4) ))
	begin
		set @localErrorMsg = 'This option is available for Tape,PnP and StandALone Libraries Only'
		SET	@lastError		=	77
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Auto-Discovery of media into default scratch pool" '
	 SET	@lastError		=	78
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 8 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~8 -- MMS2_LIBRARY_AUTO_DISCOVER
		where LibraryId = @libID
		set @outStatement = 'Auto-Discovery of media into default scratch pool / auto stamp media drive Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 8  -- MMS2_LIBRARY_AUTO_DISCOVER
		where LibraryId = @libID
		set @outStatement = 'Auto-Discovery of media into default scratch pool / auto stamp media drive Enabled'
	end
 end
 if (@option = 42)  -- Enable Auto-Recovery when media is stuck in drive(tape)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 ))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	79
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Auto-Recovery when media is stuck in drive" '
	 SET	@lastError		=	80
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 64 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~64 -- MMS2_LIBRARY_ENABLE_AUTO_STUCK_TAPE_RECOVERY
		where LibraryId = @libID
		set @outStatement = 'Auto-Recovery when media is stuck in drive Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 64  -- MMS2_LIBRARY_ENABLE_AUTO_STUCK_TAPE_RECOVERY
		where LibraryId = @libID
		set @outStatement = 'Auto-Recovery when media is stuck in drive Enabled'
	end
 end
 if (@option = 43)  --Attempt to remove media from the drive when unload fails(tape)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 ))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	81
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Attempt to remove media from the drive when unload fails" '
	 SET	@lastError		=	82
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 4096 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~4096 -- MMS2_LIBRARY_MOVE_MEDIA_WHEN_UNLOAD_FAILS
		where LibraryId = @libID
		set @outStatement = 'Attempt to remove media from the drive when unload fails Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 4096  -- MMS2_LIBRARY_MOVE_MEDIA_WHEN_UNLOAD_FAILS
		where LibraryId = @libID
		set @outStatement = 'Attempt to remove media from the drive when unload fails Enabled'
	end
 end
 if (@option = 44) -- Unmount Media after N Hours/Minutes of inactivity (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	83
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue <= 0)
	begin
	 set @localErrorMsg = 'Incorrect Value, please give a value greater than 0  '
	 SET	@lastError		=	84
	 GOTO SCRIPT_EXIT
	end
	if (upper(@optionalInputParam) != 'HOURS' and @optionalInputParam != @noParameter)
	begin
	 set @localErrorMsg = 'Invalid fourth parameter'
	 SET	@lastError		=	84
	 GOTO SCRIPT_EXIT
	end
	if (upper(@optionalInputParam) = 'HOURS')
	begin
		set @nvalue *= 60
	end
	select @oldValue1 = case when upper(@optionalInputParam) = 'HOURS' then convert(varchar,CacheMountPeriodInSec/60/60) else convert(varchar,CacheMountPeriodInSec/60) end
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set CacheMountPeriodInSec = @nvalue*60
	where LibraryId = @libID
	set @outStatement = 'Changed Inactivity time to Unmount Media'
	set @optionalInputParam = ''
 end
 if (@option = 45)  --Automatically update barcodes on firmware changes(tape)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 ))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	85
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Automatically update barcodes on firmware changes" '
	 SET	@lastError		=	86
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 8 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~8 -- MMS2_LIBRARY_EXT_AUTO_UPDATE_BARCODES
		where LibraryId = @libID
		set @outStatement = 'Automatically update barcodes on firmware changes Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 8  -- MMS2_LIBRARY_EXT_AUTO_UPDATE_BARCODES
		where LibraryId = @libID
		set @outStatement = 'Automatically update barcodes on firmware changes Enabled'
	end
 end
 if (@option = 46)  --Retry read operations on SCSI errors(tape and Pnp and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId in (1,4) ))
	begin
		set @localErrorMsg = 'This option is available for Tape,StandAlone and PnP Libraries Only'
		SET	@lastError		=	87
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Retry read operations on SCSI errors" '
	 SET	@lastError		=	88
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 1073741824 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~1073741824 -- MMS2_LIBRARY_RETRY_READ_ON_ERROR
		where LibraryId = @libID
		set @outStatement = 'Retry read operations on SCSI errors Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 1073741824  -- MMS2_LIBRARY_RETRY_READ_ON_ERROR
		where LibraryId = @libID
		set @outStatement = 'Retry read operations on SCSI errors Enabled'
	end
 end
 if (@option = 47) -- Retry read operations on SCSI errors every N Minutes (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	89
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue <= 0 or @nvalue > 5)
	begin
	 set @localErrorMsg = 'Incorrect Value, please give a value greater than 0 and no more than 5  '
	 SET	@lastError		=	90
	 GOTO SCRIPT_EXIT
	end
if((select LibraryAttribute & 1073741824
	from MMLibrary
	where LibraryId = @libID) <=0)
	begin
		set @localErrorMsg = 'This option is Only Available if the "Retry Read Operations on SCSI errors" is enabled'
		SET	@lastError		=	90
		GOTO SCRIPT_EXIT
	end
	select @oldValue1 = ReadRetryIntervalInSec/60
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set ReadRetryIntervalInSec = @nvalue*60
	where LibraryId = @libID
	set @outStatement = 'Retry read operations on SCSI errors Interval changed'
 end
 if (@option = 48) -- Attempts to Retry read operations on SCSI errors  (tape and StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 or (LibraryTypeId = 4 and DefaultMediaTypeId != 11002)))
	begin
		set @localErrorMsg = 'This option is available for Tape and StandAlone Libraries Only'
		SET	@lastError		=	91
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue > 10 or @nvalue <= 0)
	begin
	 set @localErrorMsg = 'Incorrect Value, please give a value greater than 0 and no more than 10 '
	 SET	@lastError		=	92
	 GOTO SCRIPT_EXIT
	end
if((select LibraryAttribute & 1073741824
	from MMLibrary
	where LibraryId = @libID) <=0)
	begin
		set @localErrorMsg = 'This option is Only Available if the "Retry Read Operations on SCSI errors" is enabled'
		SET	@lastError		=	92
		GOTO SCRIPT_EXIT
	end
	select @oldValue1 = ReadRetryAttempts
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set ReadRetryAttempts = @nvalue
	where LibraryId = @libID
	set @outStatement = 'Maximum Retry attempts for read operations on SCSI errors  changed'
 end
 if (@option = 49)  --Show Media related pop-up messages on CommCell Console  (Pnp and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4  ))
	begin
		set @localErrorMsg = 'This option is available for PnP and StandAlone Libraries Only'
		SET	@lastError		=	93
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Show Media related pop-up messages on CommCell Console" '
	 SET	@lastError		=	94
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 2097152 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~2097152 -- MMS2_LIBRARY_SHOW_GLXYCONSOLE_POPUP
		where LibraryId = @libID
		set @outStatement = 'Show Media related pop-up messages on CommCell Console Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 2097152  -- MMS2_LIBRARY_SHOW_GLXYCONSOLE_POPUP
		where LibraryId = @libID
		set @outStatement = 'Show Media related pop-up messages on CommCell Console Enabled'
	end
 end
 if (@option = 50)  --Automatically use spare media from different scratch pool if found in drive  (Pnp and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4))
	begin
		set @localErrorMsg = 'This option is available for PnP and StandAlone Libraries Only'
		SET	@lastError		=	95
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Automatically use spare media from different scratch pool if found in drive" '
	 SET	@lastError		=	96
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 4 != 0 then 0 else 1 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 1)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~4 -- MMS2_LIBRARY_EXT_DONOTUSE_MEDIAFROM_DIFF_POOL
		where LibraryId = @libID
		set @outStatement = 'Automatically use spare media from different scratch pool if found in drive Enabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 4  -- MMS2_LIBRARY_EXT_DONOTUSE_MEDIAFROM_DIFF_POOL
		where LibraryId = @libID
		set @outStatement = 'Automatically use spare media from different scratch pool if found in drive Disabled'
	end
 end
 if (@option = 51)  --Check for media change in drive every N minute(s) (Pnp and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 ))
	begin
		set @localErrorMsg = 'This option is available for PnP and StandAlone Libraries Only'
		SET	@lastError		=	97
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Check for media change in drive every N minute(s)" '
	 SET	@lastError		=	98
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 134217728 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~134217728 -- MMS2_LIBRARY_STDALN_MEDIA_CHECK
		where LibraryId = @libID
		set @outStatement = 'Check for media change in drive every N minute(s) Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 134217728  -- MMS2_LIBRARY_STDALN_MEDIA_CHECK
		where LibraryId = @libID
		set @outStatement = 'Check for media change in drive every N minute(s) Enabled'
	end
 end
 if (@option = 52)  --Check for media change in drive every N minute(s) (PnP and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 ))
	begin
		set @localErrorMsg = 'This option is available for PnP and StandAlone Libraries Only'
		SET	@lastError		=	99
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue < 0)
	begin
	 set @localErrorMsg = 'Enter a Value greater than or equal to 0 '
	 SET	@lastError		=	100
	 GOTO SCRIPT_EXIT
	end
	select @oldValue1 = stdAlnCHkIntervalinSec/60
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~134217728 -- MMS2_LIBRARY_STDALN_MEDIA_CHECK
		where LibraryId = @libID
		set @outStatement = 'Check for media change in drive every N minute(s) Disabled'
	end
	else
	begin
		update MMLibrary
set stdAlnCHkIntervalinSec = @nvalue * 60, LibraryAttribute = LibraryAttribute | 134217728  -- MMS2_LIBRARY_STDALN_MEDIA_CHECK
		where LibraryID = @libID
		set @outStatement = 'Check for media change in drive Interval Changed'
	end
 end
 if (@option = 53)  --Overwrite Media in Drive if Media Not Written to in N Days/Hours (PnP n StndAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 ))
	begin
		set @localErrorMsg = 'This option is available for PnP and StndAlone Libraries Only'
		SET	@lastError		=	101
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Overwrite Media in Drive if Media Not Written to in N Days/Hours" '
	 SET	@lastError		=	102
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 16384 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~16384 -- MMS2_LIBRARY_OVERWRITE_STDALN_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Overwrite Media in Drive if Media Not Written to in N Days/Hours Disabled'
	end
else if((select LibraryAttribute from MMLibrary where LibraryId = @libID) & 16384 = 0) -- MMS2_LIBRARY_OVERWRITE_STDALN_MEDIA
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 16384 , StdAlnMedRetentionTime = 15*24*60*60 -- MMS2_LIBRARY_OVERWRITE_STDALN_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Overwrite Media in Drive if Media Not Written to in N Days/Hours Enabled'
	end
 end
 if (@option = 54)  -- Overwrite Media in Drive if Media Not Written to in N Days/Hours (PnP and StandAlone)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 ))
	begin
		set @localErrorMsg = 'This option is available for PnP and StandAlone Libraries Only'
		SET	@lastError		=	103
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue < 1)
	begin
	 set @localErrorMsg = 'Enter a Value greater than 0 '
	 SET	@lastError		=	104
	 GOTO SCRIPT_EXIT
	end
	if (upper(@optionalInputParam) != 'DAYS' and @optionalInputParam != @noParameter)
	begin
	 set @localErrorMsg = 'Invalid fourth parameter'
	 SET	@lastError		=	104
	 GOTO SCRIPT_EXIT
	end
	if (upper(@optionalInputParam) = 'DAYS')
	begin
		set @nvalue *= 24
	end
	select @oldValue1 = case when upper(@optionalInputParam) = 'DAYS' then convert(varchar,StdAlnMedRetentionTime/24/60/60) else convert(varchar,StdAlnMedRetentionTime/60/60) end
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set StdAlnMedRetentionTime = @nvalue*60 * 60
	where LibraryID = @libID
	set @outStatement = 'Time after Media is Overwriten in Drive changed'
	set @optionalInputParam = ''
 end
 if (@option = 55)  --Only use PnP disk when it is blank (PnP)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4  and DefaultMediaTypeId = 11002))
	begin
		set @localErrorMsg = 'This option is available for PnP Libraries Only'
		SET	@lastError		=	105
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Only use PnP disk when it is blank" '
	 SET	@lastError		=	106
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when extendedAttributes & 8192 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set extendedAttributes =  extendedAttributes & ~8192     -- MMS2_LIBRARY_EXT_STAMP_MEDIA_IF_BLANK
		where LibraryId = @libID
		set @outStatement = 'Only use PnP disk when it is blank Disabled'
	end
	else
	begin
		update MMLibrary
set extendedAttributes = extendedAttributes | 8192      -- MMS2_LIBRARY_EXT_STAMP_MEDIA_IF_BLANK
		where LibraryId = @libID
		set @outStatement = 'Only use PnP disk when it is blank Enabled'
	end
 end
 if (@option = 56)  --use disk only when the size is greater than (PnP)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4  and DefaultMediaTypeId = 11002))
	begin
		set @localErrorMsg = 'This option is available for PnP Libraries Only'
		SET	@lastError		=	107
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != -1 and @nvalue<=0)
	begin
	 set @localErrorMsg = 'Enter "-1" to disable or a postive value N to set "Use disk only when the size is greater than (N) MB" '
	 SET	@lastError		=	108
	 GOTO SCRIPT_EXIT
	end
	select @oldValue1 = LowWaterMarkMB
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set LowWaterMarkMB = @nvalue
	where LibraryID = @libID
	set @outStatement = 'Minimum Size for the PnP disk to be Usable Changed'
 end
 if (@option = 57)  --Submit full scan on library when finding an empty barcode during drive unmounts (Tape)
 begin
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 ))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	118
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue not in (0,1))
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable "Submit full scan on library when finding an empty barcode during drive unmounts" '
	 SET	@lastError		=	119
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 32768 > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if (@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~32768 -- MMS2_LIBRARY_EXT_FULL_SCAN_UPON_EMPTY_BARCODE
		where LibraryId = @libID
		set @outStatement = 'Submit full scan on library when finding an empty barcode during drive unmounts Disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 32768  -- MMS2_LIBRARY_EXT_FULL_SCAN_UPON_EMPTY_BARCODE
		where LibraryId = @libID
		set @outStatement = 'Submit full scan on library when finding an empty barcode during drive unmounts Enabled'
	end
 end
  if (@option = 58) -- Set Configuration Params (Tape Only)
 begin
	if(@optionalInputParam = @NoParameter)
	begin
		set @localErrorMsg = 'You need to enter fourth paramater too'
		SET	@lastError		=	109
		GOTO SCRIPT_EXIT
	end
	declare @configParamInd int = 0 --convert(int,@optionalInputParam)
	set @configParamInd =
		case LOWER(@optionalInputParam)
		when LOWER('PreventPhysicalInventory') then 1
		when LOWER('PeriodicMailSlotCheckForStatusChange') then 2
		when LOWER('PreventAutoImportOfMediaFromMailSlot') then 3
		when LOWER('AllowMediumRemovalFromMailSlot') then 4
		when LOWER('PreventImportMediaFromIEPortToSlots') then 5
		when LOWER('LibraryStatusCheckInterval') then 6
	end
	set @configParamInd = ISNULL(@configParamInd,0)
	set @nvalue =  convert(int,@primaryInputParam)
	if (@configParamInd < 1 or @configParamInd > 6)
	begin
		set @localErrorMsg = 'Wrong configuration parameter entered '
		SET @lastError		=	110
		GOTO SCRIPT_EXIT
	end
	if (@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 1 ))
	begin
		set @localErrorMsg = 'This option is available for Tape Libraries Only'
		SET	@lastError		=	111
		GOTO SCRIPT_EXIT
	end
	if (@configParamInd < 6)
	begin
		if (@nvalue not in (0,1))
		begin
			set @localErrorMsg = 'Enter 0 to disable or 1 to enable this option '
			SET	@lastError		=	112
			GOTO SCRIPT_EXIT
		end
		if (@configParamInd < 5)
		begin
			declare @ConfigParams nvarchar(100) = (select ConfigParams from MMLibrary where LibraryId = @libID)
			--declare @newConfigParams nvarchar(100) = (select ConfigParams from MMLibrary where LibraryId = @libID)
			declare @runner int = CHARINDEX('-',@configParams)
			declare @count int = 1
			set @configParamInd =
				(
					CASE
					WHEN (@configParamInd = 4) then 9
					WHEN (@configParamInd = 3) then 4
					WHEN (@configParamInd = 2) then 2
					WHEN (@configParamInd = 1) then 1
					END
				)
			while (@count < @ConfigParamInd)
			begin
				set @runner = CHARINDEX('-',@configParams, @runner+1)
				set @count += 1
			end
			set @oldValue1 = SUBSTRING(@ConfigParams,@runner+1,1)
			set @ConfigParams = STUFF(@ConfigParams,@runner+1,1,@nvalue)
			/*if(@configParamInd = 1)
			begin
				set @ConfigParams = STUFF(@ConfigParams,@runner+1,1,@nvalue)
			end
			set @runner = CHARINDEX('-',@configParams, @runner+1)
			if(@configParamInd = 2)
			begin
				set @ConfigParams = STUFF(@ConfigParams,@runner+1,1,@nvalue)
			end*/
			update MMLibrary
			set ConfigParams = @ConfigParams
			where LibraryId = @libID
		end
		else
		begin
select @oldValue1 = case when ExtendedAttributes & 131072  > 0 then 1 else 0 end
		from MMLibrary
		where LibraryId = @libID
			if (@nvalue = 0)
			begin
				update MMLibrary
set extendedAttributes =  extendedAttributes & ~131072     -- MMS2_LIBRARY_EXT_USE_IMPEXP_BIT_FOR_EXPORT
				where LibraryId = @libID
			end
			else
			begin
				update MMLibrary
set extendedAttributes = extendedAttributes | 131072      -- MMS2_LIBRARY_EXT_USE_IMPEXP_BIT_FOR_EXPORT
				where LibraryId = @libID
			end
		end
	end
	else -- configParamInd = 6
	begin
		if(@nvalue < 1)
		begin
			set @localErrorMsg = 'Please enter a value greater than 0 '
			set @lastError		=	113
			GOTO SCRIPT_EXIT
		end
		select @oldValue1 = TURIntervalInSec
		from MMLibrary
		where LibraryId = @libID
		update MMLibrary
		set TURIntervalInSec = @nvalue
		where LibraryId = @libID
	end
	set @outStatement = 'Configuration Parameter changed'
	set @optionalInputParam = ''
 end
 if(@option = 59) -- ThreshHoldsForManaged Disk SPace -Start and Stop Aging threshhold (Mag Only)
 begin
	set @nvalue =  convert(int,@primaryInputParam)
	if(@optionalInputParam = @NoParameter)
	begin
		set @localErrorMsg = 'Please enter the stop aging threshold value as fourth Parameter '
		set @lastError		=	114
		GOTO SCRIPT_EXIT
	end
	declare @stopAgingThresh int = convert(int,@optionalInputParam)
	declare @threshVar int = @nvalue - @stopAgingThresh
	if @libID not in (select LibraryId from MMLibrary where LibraryTypeId = 3 and LibraryId not in (select LibraryId from MMMountPath where MountPathTypeId != 4)) -- 4 mag
	begin
	set @localErrorMsg = 'This OPtion is only available for magnetic Libraries'
	set @lasterror = 115
	goto SCRIPT_EXIT
	end
	if(@stopAgingThresh < 5 or @stopAgingThresh > 98)
	begin
		SET @localErrorMsg = 'Please Enter a correct stop aging threshold percentage value between 5 to 98'
		SET	@lastError		=	116
		GOTO SCRIPT_EXIT
	end
	if(@nvalue < 10 or @nvalue > 100 )
	begin
		SET @localErrorMsg = 'Please Enter a correct start aging threshold percentage value between 10 to 100'
		SET	@lastError		=	117
		GOTO SCRIPT_EXIT
	end
	if(@threshVar < 1 )
	begin
		SET @localErrorMsg = 'The start Aging Threshold needs to be greater than Stop Aging Threshold'
		SET	@lastError		=	117
		GOTO SCRIPT_EXIT
	end
	select @oldValue1 = ThresholdPercentage , @oldValue2 = ThresholdPercentage - ThresholdVariation
	from MMLibrary
	where LibraryId = @libID
	update MMLibrary
	set ThresholdPercentage = @nvalue , ThresholdVariation = @threshVar
	where LibraryId = @libID
	set @outStatement = 'Start and Stop Aging threshhold changed'
 end
 if(@option = 60) -- Unload media in StandAlone Drive when different media is required (StandAlone Only)
 begin
	if (@libID not in (select LibraryId from MMLibrary where LibraryTypeId = 4 and DefaultMediaTypeId != 11002))
	begin
		set @localErrorMsg = 'This Option is available only for StandAlone Libraries'
		SET	@lastError		=	120
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either give 0 to disable or 1 to enable'
	 SET	@lastError		=	121
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 16  > 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes & ~16  -- MMS2_LIBRARY_EXT_EJECT_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Disabled Unload media in StandAlone Drive when different media is required'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 16   -- MMS2_LIBRARY_EXT_EJECT_MEDIA
		where LibraryId = @libID
		set @outStatement = 'Enabled Unload media in StandAlone Drive when different media is required '
	end
 end
 if (@option = 61) -- Do not attempt to load ejected media(StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 and DefaultMediaTypeId != 11002))
	begin
		set @localErrorMsg = 'This option is available for StandAlone Libraries Only'
		SET	@lastError		=	122
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable'
	 SET	@lastError		=	123
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 65536 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~65536 -- MMS2_LIBRARY_CHECK_FOR_CLEANING_MEDIA
		where LibraryId = @libID
		set @outStatement = '"Do not attempt to load ejected media" Disabled'
	end
	else
	begin
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 65536  -- MMS2_LIBRARY_CHECK_FOR_CLEANING_MEDIA
		where LibraryId = @libID
		set @outStatement = '"Do not attempt to load ejected media" Enabled'
	end
 end
 if (@option = 62) -- Unmount Media(StandAlone)
 begin
	if(@libID not in (select LibraryID from MMLibrary where LibraryTypeId = 4 and DefaultMediaTypeId != 11002))
	begin
		set @localErrorMsg = 'This option is available for StandAlone Libraries Only'
		SET	@lastError		=	124
		GOTO SCRIPT_EXIT
	end
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
	 set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable'
	 SET	@lastError		=	125
	 GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when LibraryAttribute & 1048576 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set LibraryAttribute =  LibraryAttribute & ~1048576 -- MMS2_LIBRARY_EJECT_STDALN_MEDIA
		where LibraryId = @libID
		set @outStatement = '"Unmount Media" Disabled'
	end
	else
	begin
		if(@oldValue1 = 0)
		begin
			update MMLibrary
			set CacheMountPeriodInSec = 20*60
			where LibraryId = @libID
		end
		update MMLibrary
set LibraryAttribute = LibraryAttribute | 1048576  -- MMS2_LIBRARY_EJECT_STDALN_MEDIA
		where LibraryId = @libID
		set @outStatement = '"Unmount Media" Enabled'
	end
 end
 if(@option = 63) -- DisableForWriteAtLowWatermark
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
		set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable'
		SET	@lastError		=	126
		GOTO SCRIPT_EXIT
	end
	if NOT EXISTS(select 1 from MMLibrary where LibraryId = @libID and LibraryTypeId = 3)
		OR NOT EXISTS(select 1 from MMMountPath where LibraryId = @libID and MountPathTypeId = 4)
	begin
		set @localErrorMsg = 'This option only available for Magnetic Library'
		SET	@lastError		=	127
		GOTO SCRIPT_EXIT
	end
	if EXISTS(select 1 from MMLibrary where LibraryId = @libID and LowWaterMarkMB = 0)
	begin
		set @localErrorMsg = 'This option is available only when low water mark is set'
		SET	@lastError		=	128
		GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 67108864 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~67108864 -- MMS2_LIBRARY_EXT_DISABLE_FOR_WRITE_AT_LOW_WATER_MARK
		where LibraryId = @libID
		set @outStatement = '"Disable for new data at low watermark" is disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 67108864  -- MMS2_LIBRARY_EXT_DISABLE_FOR_WRITE_AT_LOW_WATER_MARK
		where LibraryId = @libID
		set @outStatement = '"Disable for new data at low watermark" is enabled'
	end
 end
 if(@option = 64) -- EnableLibImmutable
 begin
	set @nvalue = convert(int,@primaryInputParam)
	if (@nvalue != 0 and @nvalue !=1)
	begin
		set @localErrorMsg = 'Value is not correct either enter 1 to Enable or 0 to Disable'
		SET	@lastError		=	129
		GOTO SCRIPT_EXIT
	end
	if NOT EXISTS(select 1 from MMLibrary where LibraryId = @libID and LibraryTypeId = 3)
		OR NOT EXISTS(select 1 from MMMountPath where LibraryId = @libID and MountPathTypeId IN (4,7))
	begin
		set @localErrorMsg = 'This option only available for Magnetic/Cloud Library'
		SET	@lastError		=	130
		GOTO SCRIPT_EXIT
	end
select @oldValue1 = case when ExtendedAttributes & 536870912 != 0 then 1 else 0 end
	from MMLibrary
	where LibraryId = @libID
	if(@nvalue = 0)
	begin
		update MMLibrary
set ExtendedAttributes =  ExtendedAttributes & ~536870912
		where LibraryId = @libID
		set @outStatement = '"Enable library immutable option" is disabled'
	end
	else
	begin
		update MMLibrary
set ExtendedAttributes = ExtendedAttributes | 536870912
		where LibraryId = @libID
		set @outStatement = '"Enable library immutable option" is enabled'
	end
 end
  if(@oldValue1 != @primaryInputParam or  (@oldValue2 != @NoParameter and @oldValue2 != @optionalInputParam and @optionalInputParam != @NoParameter))
  begin
	declare @thirdParamName varchar(128) = ''
	set @thirdParamName =
			(
				CASE
				WHEN (@option = 59) then 'Start Aging Percentage '
			    WHEN (@option = 21) then 'Slot Number '
				else 'Primary paramater '
				END
			)
 	print @thirdParamName+'- Old Value : "'+@oldValue1+'" New Value : "'+@primaryInputParam+'"'
 	 if(@oldValue2 != @NoParameter and @optionalInputParam != @NoParameter)
 	 begin
	 declare @fourthParamName varchar(128) = ''
	 set @fourthParamName =
			(
				CASE
				WHEN (@option = 59) then 'Stop Aging Percentage '
			    WHEN (@option = 21) then 'Direction '
				else 'Optional paramater '
				END
			)
	 print @fourthParamName + '- Old Value : "'+@oldValue2+'" New Value : "'+@optionalInputParam+'"'
 	 end
 	print @outStatement
  end
  else
  begin
	print 'Nothing was Changed as entered value is same as stored value'
  end
end try
begin catch
	set @localErrorMsg = ERROR_MESSAGE()
 end catch
--print 'Script executed successfully'
commit tran
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK tran
		set @localErrorMSg = CHAR(13)+CHAR(10) + @localErrorMsg
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetLibraryProperty')
	delete from GxQscripts where name = 'QS_SetLibraryProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetLibraryProperty')
	delete from GXDBVersions where aliasname = 'QS_SetLibraryProperty'
GO

insert into GXDBVersions values(2, 'QS_SetLibraryProperty',  '00010001000400070000', 'QS_SetLibraryProperty', '00010001000400070000')
GO

insert into GxQscripts values(2+8,'QS_SetLibraryProperty',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To change library name '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si changename -si newName'
 + CHAR(10) + '-- 		Enable  a Library (Common for all)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si enablelibrary -si 1'
 + CHAR(10) + '-- 		Disable  a Library (Common for all)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si enablelibrary -si 0'
 + CHAR(10) + '-- 		Mark Archive File As Read Only (Magnetic and Cloud) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si archfilereadonly -si 1'
 + CHAR(10) + '-- 		UnMark Archive File As Read Only (Magnetic and Cloud) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si archfilereadonly -si 0'
 + CHAR(10) + '-- 		Set Mount TimeOut '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si mounttimeout -si newTimeOutinMinutes'
 + CHAR(10) + '-- 		Set UnMount TimeOut '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si unmounttimeout -si newTimeOutinMinutes'
 + CHAR(10) + '-- 		Enable AutoMatically Add DataPaths for New Drive Pools Configured (All except cloud) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si autoadddatapath -si 1'
 + CHAR(10) + '-- 		Disable AutoMatically Add DataPaths for New Drive Pools Configured (All except cloud) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si autoadddatapath -si 0'
 + CHAR(10) + '-- 		Enable Library Support for Hardware Single Instancing (In Magnetic Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si hardwaresingleinstancing -si 1'
 + CHAR(10) + '-- 		Disable Library Support for Hardware Single Instancing (In Magnetic Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si hardwaresingleinstancing -si 0'
 + CHAR(10) + '-- 		Set prevent accidental deletion (Mag Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si preventaccidentaldel -si 1'
 + CHAR(10) + '-- 		UnSet prevent accidental deletion (Mag Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si preventaccidentaldel -si 0'
 + CHAR(10) + '-- 		Enable Fill and SPill mode(Mag and Cloud) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si spillnfill -si 0'
 + CHAR(10) + '-- 		Enable Spill and Fill mode/Round Robin mode (Mag and Cloud)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si spillnfill -si 1 -si 1/0(setprefermountpathswithmorefreespace)'
 + CHAR(10) + '-- 		Mount Path Allocation Policy(Library Level) - Use max number of writers (Mag and Cloud only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si setwriters -si ''-1'''
 + CHAR(10) + '-- 		Mount Path Allocation Policy(Library Level) - Use specified number of writers(Mag and Cloud only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si setwriters -si NumberOfWriters'
 + CHAR(10) + '-- 		Space ThreshHolds - Low Disk SPace WaterMark  (Mag Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si lowWaterMark -si ThreshHoldInPercentage'
 + CHAR(10) + '-- 		Space ThreshHolds - Disk FreePercentage Warning WaterMark (MagOnly)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si warningWaterMark -si ThreshHoldInPercentage'
 + CHAR(10) + '-- 		Space ThreshHolds - Warning Days (MagOnly) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si daysToRunOutOfSpace -si NumberOfDays'
 + CHAR(10) + '-- 		ThreshHolds For Managed Disk SPace -Start and Stop Aging threshholds (Mag Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si StartAndStopAgingThreshHolds -si startAgingThreshHoldInPercentage -si stopAgingThreshHoldInPercentage'
 + CHAR(10) + '-- 		ThreshHolds For Managed Disk SPace -Start Aging threshhold (Mag Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si startAging -si ThreshHoldInPercentage'
 + CHAR(10) + '-- 		ThreshHolds For Managed Disk SPace -Stop Aging threshhold (Mag Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si stopAging -si ThreshHoldInPercentage'
 + CHAR(10) + '-- 		Mark Offline For Maintenance (Tape,StandAlone and PnP libraries)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MarkLibraryOfflineForMaintenance -si 1'
 + CHAR(10) + '-- 		UnMark Offline For Maintenance (Tape,StandAlone and PnP libraries)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MarkLibraryOfflineForMaintenance -si 0'
 + CHAR(10) + '-- 		Mark Media as Appendable (Tape,StandAlone and PnP libraries) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si markMediaAsAppendable -si 1'
 + CHAR(10) + '-- 		UnMark Media as Appendable (Tape,StandAlone and PnP libraries)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si markMediaAsAppendable -si 0'
 + CHAR(10) + '-- 		Set use appendable media and use within days (Tape,StandAlone and PnP libraries) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si useAppendableMEdia -si 1 -si UseWithinDays '
 + CHAR(10) + '-- 		UnSet use appendable media (Tape,StandAlone and PnP libraries) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si useAppendableMEdia -si 0'
 + CHAR(10) + '-- 		Enable Start a new Media on Media Export(Tape  Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si startNewMediaWhenMediaExported -si 1'
 + CHAR(10) + '-- 		Disable Start a new Media on Media Export(Tape  Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si startNewMediaWhenMediaExported -si 0'
 + CHAR(10) + '-- 		Enable Start a new Media on Media getting Stuck in Drive(Tape  Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si startNewMediaOnMediaGettingStuck -si 1'
 + CHAR(10) + '-- 		Disable Start a new Media on Media getting Stuck in Drive(Tape  Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si startNewMediaOnMediaGettingStuck -si 0'
 + CHAR(10) + '-- 		Enable and configure virtual mail slot for export (Tape Only)'
 + CHAR(10) + '-- 		Set slot 7 as starting slot and direction up'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si configureVMSE -si 7 -si ''UP'''
 + CHAR(10) + '-- 		Set slot 7 as starting slot and direction Down'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si configureVMSE -si 7 -si ''DOWN'''
 + CHAR(10) + '-- 		Disable virtual mail slot for export (Tape Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si configureVMSE -si 0 '
 + CHAR(10) + '-- 		Enable Use media in virtual mail slot for data protection (Tape Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si useVMSforDataProtection -si 1'
 + CHAR(10) + '-- 		Disable Use media in virtual mail slot for data protection (Tape Only) '
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si useVMSforDataProtection -si 0'
 + CHAR(10) + '-- 		Enable Reset container when assigned media re-appears in library (Tape,StandAlone and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si resetContainerWhenAssignedMediaReAppears -si 1'
 + CHAR(10) + '-- 		Disable Reset container when assigned media re-appears in library (Tape,StandAlone and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si resetContainerWhenAssignedMediaReAppears -si 0'
 + CHAR(10) + '-- 		Enable Reset export location when assigned media re-appears in library(Tape,StandAlone  and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si resetExportLocationWhenAssignedMediaReAppears -si 1'
 + CHAR(10) + '-- 		Disable Reset export location when assigned media re-appears in library(Tape,StandAlone  and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si resetExportLocationWhenAssignedMediaReAppears -si 0'
 + CHAR(10) + '-- 		Enable Mark Library/Drive broken when error threshold exceeded(Tape,StandAlone  and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MarkLibraryBrokenWhenErrorTHresholdCrossed -si 1'
 + CHAR(10) + '-- 		Disable Mark Library/Drive broken when error threshold exceeded(Tape,StandAlone  and PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MarkLibraryBrokenWhenErrorTHresholdCrossed -si 0'
 + CHAR(10) + '-- 		Enable Verify access path using Serial Number for Drive(Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si verifyAccessPathUsingSerialNumber -si 1'
 + CHAR(10) + '-- 		Disable Verify access path using Serial Number for Drive(Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si verifyAccessPathUsingSerialNumber -si 0'
 + CHAR(10) + '-- 		Enable Check for cleaning media loaded in Drive(Tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si checkForCleaningMediaInDrive -si 1'
 + CHAR(10) + '-- 		Disable Check for cleaning media loaded in Drive(Tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si checkForCleaningMediaInDrive -si 0'
 + CHAR(10) + '-- 		Enable Check for Tape Alerts(Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si CheckForTapeAlerts -si 1'
 + CHAR(10) + '-- 		Disable Check for Tape Alerts(Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si CheckForTapeAlerts -si 0'
 + CHAR(10) + '-- 		Enable Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si driveNeedsCleaningOnCRCErrors -si 1'
 + CHAR(10) + '-- 		Disable Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si driveNeedsCleaningOnCRCErrors -si 0'
 + CHAR(10) + '-- 		Enable Skip unload drive for Autoloaders before unmounting media (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si skipUnloadDriveForAutoLoaders -si 1  '
 + CHAR(10) + '-- 		Disable Skip unload drive for Autoloaders before unmounting media (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si skipUnloadDriveForAutoLoaders -si 0'
 + CHAR(10) + '-- 		Enable Detect and update media type when media is loaded into the drive (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si detectAndUpdateMediaTypeWhenMediaLoaded -si 1'
 + CHAR(10) + '-- 		Disable Detect and update media type when media is loaded into the drive (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si detectAndUpdateMediaTypeWhenMediaLoaded -si 0'
 + CHAR(10) + '-- 		Enable Auto Drive Replacement when new device is detected during Mount (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoDriveReplacementwhenNewDeviceIsDetected -si 1'
 + CHAR(10) + '-- 		Disable Auto Drive Replacement when new device is detected during Mount (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoDriveReplacementwhenNewDeviceIsDetected -si 0'
 + CHAR(10) + '-- 		Do not use SCSI-2/3 Reserve for contention resolution (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si SCSIReservaionType -si 0	'
 + CHAR(10) + '-- 		Use SCSI-2 Reserve for contention resolution (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si SCSIReservaionType -si SCSI-2'
 + CHAR(10) + '-- 		Use SCSI-3 Reserve for contention resolution (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si SCSIReservaionType -si SCSI-3'
 + CHAR(10) + '-- 		Enable Auto-Cleaning: On sense code (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningOnSenseCode -si 1'
 + CHAR(10) + '-- 		Disable Auto-Cleaning: On sense code (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningOnSenseCode -si 0'
 + CHAR(10) + '-- 		Enable Auto-Cleaning: Cleaning thresholds exceed (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningOnThreshholdOverflow -si 1'
 + CHAR(10) + '-- 		Disable Auto-Cleaning: Cleaning thresholds exceed (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningOnThreshholdOverflow -si 0'
 + CHAR(10) + '-- 		Enable Auto Cleaning - Wait N day(s) after last cleaning (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningWaitingDays -si numberOfDays'
 + CHAR(10) + '-- 		Disable Auto Cleaning - Wait N day(s) after last cleaning (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoCleaningWaitingDays -si 0'
 + CHAR(10) + '-- 		Enable Continue using drive even if need cleaning during restore (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si continueUseEvenIfCleaningNeededDuringRestore -si 1	'
 + CHAR(10) + '-- 		Disable Continue using drive even if need cleaning during restore (tape,StandAlone and pnp )'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si continueUseEvenIfCleaningNeededDuringRestore -si 0'
 + CHAR(10) + '-- 		Enable Overwite media when content verification fails (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverWriteMediaOnContentVerificationFail -si 1'
 + CHAR(10) + '-- 		Disable Overwite media when content verification fails (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverWriteMediaOnContentVerificationFail -si 0'
 + CHAR(10) + '-- 		Enable Prevent use of tapes from a different backup vendor (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si preventDifferentVendorMediaUsage -si 1'
 + CHAR(10) + '-- 		Disable Prevent use of tapes from a different backup vendor (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si preventDifferentVendorMediaUsage -si 0'
 + CHAR(10) + '-- 		Enable Overwite media when it is from different CommCell (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverWriteMediaFromDifferentCommCell -si 1'
 + CHAR(10) + '-- 		Disable Overwite media when it is from different CommCell (tape,StandAlone and pnp)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverWriteMediaFromDifferentCommCell -si 0'
 + CHAR(10) + '-- 		Enable Auto-Discovery of media into default scratch pool / auto stamp media drive (tape, PnP and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoDiscoveryInDefaultScratchPool -si 1'
 + CHAR(10) + '-- 		Disable Auto-Discovery of media into default scratch pool / auto stamp media drive (tape, PnP and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoDiscoveryInDefaultScratchPool -si 0'
 + CHAR(10) + '-- 		Enable Auto-Recovery when media is stuck in drive(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoRecoveryWhenMediaIsStuck -si 1'
 + CHAR(10) + '-- 		Disable Enable Auto-Recovery when media is stuck in drive(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoRecoveryWhenMediaIsStuck -si 0'
 + CHAR(10) + '-- 		Enable Attempt to remove media from the drive when unload fails(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si RemoveMediaWhenDriveUnloadFail -si 1'
 + CHAR(10) + '-- 		Disable Attempt to remove media from the drive when unload fails(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si RemoveMediaWhenDriveUnloadFail -si 0'
 + CHAR(10) + '-- 		Unmount Media after N Minutes of inactivity (Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UnmountAfterPeriod -si timeInMinutes'
 + CHAR(10) + '-- 		Unmount Media after N Hours of inactivity (Tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UnmountAfterPeriod -si timeInHours -si ''Hours'''
 + CHAR(10) + '-- 		Enable Unmount Media  (StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si unMountMedia -si 1'
 + CHAR(10) + '-- 		Disable Unmount Media  (StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si unMountMedia -si 0'
 + CHAR(10) + '-- 		Enable Automatically update barcodes on firmware changes(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoUpdateBarcodesOnFirmwareCHanges -si 1'
 + CHAR(10) + '-- 		Disable Automatically update barcodes on firmware changes(tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si AutoUpdateBarcodesOnFirmwareCHanges -si 0'
 + CHAR(10) + '-- 		Enable Retry read operations on SCSI errors(tape, PnP and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si RetryReadOnSCSIErrors -si 1'
 + CHAR(10) + '-- 		Disable Retry read operations on SCSI errors(tape, PnP and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si RetryReadOnSCSIErrors -si 0'
 + CHAR(10) + '-- 		Retry read operations on SCSI errors every N Minutes (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ReadRetryIntervalonSCSIErrors -si Minutes'
 + CHAR(10) + '-- 		Set Attempts to Retry read operations on SCSI errors  (tape and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ReadRetryAttemptsonSCSIErrors -si numAttempts'
 + CHAR(10) + '-- 		Enable Show Media related pop-up messages on CommCell Console  (Pnp and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ShowPopUpsonCommCellConsole -si 1'
 + CHAR(10) + '-- 		Disable Show Media related pop-up messages on CommCell Console  (Pnp and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ShowPopUpsonCommCellConsole -si 0'
 + CHAR(10) + '-- 		Enable Automatically use spare media from different scratch pool if found in drive  (Pnp and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si enableUseOfDifferentScratchMedia -si 1'
 + CHAR(10) + '-- 		Disable Automatically use spare media from different scratch pool if found in drive  (Pnp and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si enableUseOfDifferentScratchMedia -si 0'
 + CHAR(10) + '-- 		Disable Check for media change in drive every N minute(s) (Pnp and StandALone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MediaChangeCheckInterval -si 0'
 + CHAR(10) + '-- 		Enable and Set interval (in Minutes) to check for media change in drive every N minute(s) (Pnp And StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MediaChangeCheckInterval -si InterValInMinutes'
 + CHAR(10) + '-- 		Disable Overwrite Media in Drive if Media Not Written to in N Days/Hours (PnP and StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si overwriteMediaNotWrittenInDays_Hours -si 0'
 + CHAR(10) + '-- 		Enable Overwrite Media in Drive if Media Not Written to in N Days/Hours (PnP and  StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si overwriteMediaNotWrittenInDays_Hours -si 1'
 + CHAR(10) + '-- 		Hours after Media in the Drive is OverWritten(PnP and  StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverwriteAfter -si periodInHours'
 + CHAR(10) + '-- 		Days after which Media in the Drive is OverWritten(PnP and  StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si OverwriteAfter -si periodInDays -si ''Days'''
 + CHAR(10) + '-- 		Disable :Only use PnP disk when it is blank (PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UsePnPWhenBlank -si 0'
 + CHAR(10) + '-- 		Enable :Only use PnP disk when it is blank (PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UsePnPWhenBlank -si 1'
 + CHAR(10) + '-- 		Disable "Use disk only when the size is greater than N MB" (PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MinimumUsableSize -si ''-1'''
 + CHAR(10) + '-- 		Minimum size of the Disk Required if It is to be used (PnP)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si MinimumUsableSize -si sizeInMegaBytes'
 + CHAR(10) + '-- 		Disable :Submit full scan on library when finding an empty barcode during drive unmounts (Tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si SubmitFullScanOnFindingEmptyBarcodes -si 0'
 + CHAR(10) + '-- 		Enable :Submit full scan on library when finding an empty barcode during drive unmounts (Tape)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si SubmitFullScanOnFindingEmptyBarcodes -si 1'
 + CHAR(10) + '-- 		Set Configuration Params (Tape Only)'
 + CHAR(10) + '-- 			Prevent physical inventory of the library(0 to disable 1 to enable)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (0 or 1) -si PreventPhysicalInventory	'
 + CHAR(10) + '-- 			Do Periodic mail slot check for any change in status(0 to disable 1 to enable)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (0 or 1) -si PeriodicMailSlotCheckForStatusChange'
 + CHAR(10) + '-- 			Prevent Auto Import of Media from mail slot(0 to disable 1 to enable)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (0 or 1) -si PreventAutoImportOfMediaFromMailSlot'
 + CHAR(10) + '-- 			Allow Medium Removal from mail slot(0 to disable 1 to enable)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (0 or 1) -si AllowMediumRemovalFromMailSlot'
 + CHAR(10) + '-- 			Do not import media from I/E port back to the slots(0 to disable 1 to enable)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (0 or 1) -si PreventImportMediaFromIEPortToSlots'
 + CHAR(10) + '-- 			Library Status Check Interval in seconds'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si ConfigParams -si (intervalInSeconds) -si LibraryStatusCheckInterval'
 + CHAR(10) + '-- 		Disable :Unload media in StandAlone Drive when different media is required (StandAlone Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UnloadMediaInStandAloneWhenDifferentMediaRequired -si 0'
 + CHAR(10) + '-- 		Enable :Unload media in StandAlone Drive when different media is required (StandAlone Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si UnloadMediaInStandAloneWhenDifferentMediaRequired -si 1'
 + CHAR(10) + '-- 		Disable :Do not attempt to load ejected media(StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si DonotLoadEjectedMedia -si 0'
 + CHAR(10) + '-- 		Enable :Do not attempt to load ejected media(StandAlone)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si DonotLoadEjectedMedia -si 1'
 + CHAR(10) + '-- 		Enable : Disable library for new data when free space reaches low watermark(Magnetic Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si DisableForWriteAtLowWatermark -si 1'
 + CHAR(10) + '-- 		Disable : Disable library for new data when free space reaches low watermark(Magnetic Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si DisableForWriteAtLowWatermark -si 0'
 + CHAR(10) + '-- 		Enable : Enable library immutable option on the library so that no micro pruning is sent(Dedupe Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si EnableLibImmutable -si 1'
 + CHAR(10) + '-- 		Disable : Disable library immutable option on the library so that no micro pruning is sent(Dedupe Only)'
 + CHAR(10) + '-- 		qoperation execscript -sn setLibraryProperty -si LibName -si EnableLibImmutable -si 0'
)
GO

