

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetKeyIntoGlobalParamTbl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetKeyIntoGlobalParamTbl <<<'

IF EXISTS (select * from sysobjects where name='QS_SetKeyIntoGlobalParamTbl')
	drop procedure QS_SetKeyIntoGlobalParamTbl
IF EXISTS (select * from GxQscripts where name='QS_SetKeyIntoGlobalParamTbl')
	delete from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyIntoGlobalParamTbl')
	delete from GXDBVersions where aliasname = 'QS_SetKeyIntoGlobalParamTbl'
GO
print '... Creating Procedure: QS_SetKeyIntoGlobalParamTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetKeyIntoGlobalParamTbl
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @key varchar(512) = '%s',
  @enabled varchar(64) = '%s',
  @value varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @key varchar(512)
--SET @key	=		'%s'
--DECLARE @enabled	varchar(64)
--SET @enabled =		'%s'
--DECLARE @value varchar(512)
--SET @value	=		'%s'
--------------------------------------------
-- Testing --
--------------------------------------------
--SET @key		=		'JMExtnRtnCombinedPriority'
--SET @enabled	=		'Y'
--SET @value	=		'066'
--------------------------------------------
-- Convenience Definitions --
--------------------------------------------
DECLARE @scriptName			varchar(32)
SET		@scriptName	=		'SetKeyIntoGlobalParamTbl'
DECLARE @transactionName	varchar(32)
SET @transactionName =		'SetKeyIntoGlobalParamTblTran'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--------------------------------------------
--------------------------------------------
-- @enabled is compulsory param
if (@enabled = @noParameter) or (LOWER(@enabled) <> 'y' and LOWER(@enabled) <> 'n') or
   (@key = @noParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid enabled or key paramater value. Enter [y] to enable and [n] to disable.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-- If @enabled is true, Validate @value
if (LOWER(@enabled) = 'y')
	if @value = @noParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Invalid value parameter  value.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
BEGIN TRY
BEGIN TRANSACTION @transactionName
	DELETE from GxGlobalParam where name = @key
	if (@enabled ='y')
		INSERT INTO GxGlobalParam(name,value,created,modified) VALUES (@key, @value,dbo.GetUnixTime(GetUTCDate()),0)
COMMIT TRANSACTION @transactionName
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION @transactionName
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
	if (@lastError <> 0)
		Raiserror(@localErrorMsg,
				    15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl')
	delete from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyIntoGlobalParamTbl')
	delete from GXDBVersions where aliasname = 'QS_SetKeyIntoGlobalParamTbl'
GO

insert into GXDBVersions values(2, 'QS_SetKeyIntoGlobalParamTbl',  '00000000000000000000', 'QS_SetKeyIntoGlobalParamTbl', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetKeyIntoGlobalParamTbl',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	To set the key "JMExtnRtnCombinedPriority" into gxglobalparam table
'
 + CHAR(10) + '	qoperation execscript -sn SetKeyIntoGlobalParamTbl.sql -si JMExtnRtnCombinedPriority -si y -si 066
'
 + CHAR(10) + '	To remove the key from gxglobalparam table
'
 + CHAR(10) + '	qoperation execscript -sn SetKeyIntoGlobalParamTbl.sql -si JMExtnRtnCombinedPriority -si n
'
 + CHAR(10) + '--   script_name : SetKeyIntoGlobalParamTbl'
)
GO

