

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetJobDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetJobDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_SetJobDescription')
	drop procedure QS_SetJobDescription
IF EXISTS (select * from GxQscripts where name='QS_SetJobDescription')
	delete from GxQscripts where name = 'QS_SetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_SetJobDescription'
GO
print '... Creating Procedure: QS_SetJobDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetJobDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @inJobId varchar(64) = '%s',
  @jobDescription varchar(4096) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @inJobId	varchar(64)
--SET @inJobId =	'%s'
--SET @inJobId = 10
--DECLARE @jobDescription	varchar(4096)
--SET @jobDescription =	'%s'
--SET @jobDescription =	'jayaram test'
-------------------------------------------
---- Convenience Definitions    -----------
-------------------------------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetJobDescription'
-------------------------------------------
-------- Local Variables    -------------
-------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
DECLARE @currDTime				datetime
DECLARE @inChangeTime			bigint
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0			-- Be optimistic
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------------------------------------------
---- Input parameter validation -----------
-------------------------------------------
IF (@inJobId = @NoParameter) or (@jobDescription = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId paramater value or description'
	Set @lastError = 1
	goto	ARGS_ERROR
END
IF NOT EXISTS(select *from JMJobStats where jobId = @inJobId)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-------------------------------------------
----- Procession Logic --------------------
-------------------------------------------
BEGIN TRY
BEGIN TRAN
	-- Getting the current UTC Data Time
	set @currDTime = GETUTCDATE()
	-- Converting the UTC Date Time into milli seconds
	set @inChangeTime =  dbo.getunixtime(@currDTime)*2147483648 + DATEPART(ms,@currDTime)
	IF EXISTS(select *from JMJobStats where jobId = @inJobId)
		update JMJobStats set jobDescription = @jobDescription where jobId = @inJobId and commCellId = 2
	IF EXISTS(select *from JMJobInfo where jobId = @inJobId)
		update JMJobInfo set jobDescription = @jobDescription, lastStateChangeTime = @inChangeTime
		 where jobId = @inJobId
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetJobDescription')
	delete from GxQscripts where name = 'QS_SetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_SetJobDescription'
GO

insert into GXDBVersions values(2, 'QS_SetJobDescription',  '00000000000000000000', 'QS_SetJobDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetJobDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetJobDescription.sql -si jobId -si jobDescription
'
 + CHAR(10) + '--   script_name : SetJobDescription'
)
GO

