

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetJobConfiguration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetJobConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetJobConfiguration <<<'
	drop procedure QS_SetJobConfiguration
END
IF EXISTS (select * from GxQscripts where name='QS_SetJobConfiguration')
	delete from GxQscripts where name = 'QS_SetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_SetJobConfiguration'
GO
print '... Creating Procedure: QS_SetJobConfiguration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetJobConfiguration
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @OPT varchar(512) = '%s',
  @VAL varchar(512) = '%s',
  @PWD varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @PARAM1 varchar(512)
--DECLARE @OPT    varchar(512)
--DECLARE @VAL    varchar(512)
--DECLARE @PWD	varchar(512)
--SET @PARAM1 = '%s'  			-- c=clientName, allclients
--SET @OPT = '%s'					-- what is to be set, DiskFullPercent, JMPriority, JobResultsThresholdMB, AgingDays, username, password
--SET @VAL = '%s'					-- new value
--SET @PWD = '%s'					-- optional encrypted password. only if username is being changed
--SET @PARAM1 =  'c=roman'
--SET @OPT =	'1'
--SET @VAL =	'80'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetJobConfiguration'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
---------------------- Validate Inputs -----------------------------
if(@PARAM1 = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
IF @OPT = @NoParameter OR (@OPT <> 1 AND @OPT <> 2 AND @OPT <>3 AND @OPT <>4 AND @OPT <>5 AND @OPT <>6)
BEGIN
	SET @localErrorMsg	='Error. Parameter2 must be refer to what option you want to set(1-6). Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @OPTNAME varchar(64)
SET @OPTNAME = (CASE @OPT
WHEN '1' THEN 'DiskFullPercent'
WHEN '2' THEN 'JMPriority'
WHEN '3' THEN 'JobResultsThresholdMB'
WHEN '4' THEN 'AgingDays'
WHEN '5' THEN 'Job Results Dir Username'
WHEN '6' THEN 'Job Results Dir Password'
ELSE ''
END)
DECLARE @OPTTYPE varchar(64)
SET @OPTTYPE = (CASE @OPT
WHEN '1' THEN '7' --integer
WHEN '2' THEN '7'
WHEN '3' THEN '7'
WHEN '4' THEN '7'
WHEN '5' THEN '1' --string
WHEN '6' THEN '1'
ELSE '1'
END)
IF @OPTNAME = ''
BEGIN
	SET @localErrorMsg	='Error. Unsupported option ['+@OPT+']. Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @VAL= @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Parameter3 must be the the new value. Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'JMPriority' AND (@VAL < 0 OR @VAL > 9)
BEGIN
	SET @localErrorMsg	='Error. Job proprity must be in the range 0-9.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'DiskFullPercent' AND (@VAL < 0 OR @VAL > 100)
BEGIN
	SET @localErrorMsg	='Error. Invalid input for "Prune Job results when Disk Capaicity reaches". This is a percentage value.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'Job Results Dir Username' AND @PWD= @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Password was empty. Please propide the encrypted password for user ['+@VAL+'].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
	IF @clientId = 0
	BEGIN
		--if present already update it
		-- SKatz: This really should be a cursor so we can look at each client, one by one and determine
		--        whether or not to update the property.  This current method will potentially age properties
		--		  that really haven't changed!
		UPDATE APP_CLIENTPROP SET ATTRVAL =@VAL WHERE AttrName = @OPTNAME	AND MODIFIED = 0
		--insert it for all other clients
		INSERT INTO APP_CLIENTPROP (componentnameid, attrname, attrval, attrtype, created, modified)
				SELECT id, @OPTNAME, @VAL, @OPTTYPE, @nowTime, 0  FROM	APP_CLIENT
				WHERE id not in (SELECT Cli.id
					FROM APP_CLIENT Cli, APP_CLIENTPROP Prop
					WHERE Cli.id = Prop.componentnameid AND Prop.AttrName = @OPTNAME AND Prop.MODIFIED = 0)
	END
	ELSE
	BEGIN
		IF (exists(SELECT * FROM APP_CLIENTPROP WHERE AttrName = @OPTNAME AND componentNameId = @clientId AND MODIFIED = 0))
			UPDATE APP_CLIENTPROP SET ATTRVAL =@VAL WHERE AttrName = @OPTNAME AND componentNameId = @clientId AND MODIFIED = 0
		ELSE
			INSERT INTO APP_CLIENTPROP (componentnameid, attrname, attrval, attrtype, created, modified)
				VALUES (@clientId, @OPTNAME, @VAL, @OPTTYPE, @nowTime, 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Job Result Information ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: [ ' + @PARAM1 +', ' +@OPT+', ' +@VAL
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetJobConfiguration')
	delete from GxQscripts where name = 'QS_SetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_SetJobConfiguration'
GO

insert into GXDBVersions values(2, 'QS_SetJobConfiguration',  '00000000000000000000', 'QS_SetJobConfiguration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetJobConfiguration',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn setJobConfiguration.sql -si c=clientName|allclients -si option -si new_value
'
 + CHAR(10) + '--   script_name : SetJobConfiguration'
 + CHAR(10) + '--   Option Mapping'
 + CHAR(10) + '--   1	-	Prune Job results when Disk Capacity reaches a percent full'
 + CHAR(10) + '--   2	-	Job priority'
 + CHAR(10) + '--   3	-	Low Space Threshold on Job Results Folder(MB)'
 + CHAR(10) + '--   4	-	Prune job results after specified days'
 + CHAR(10) + '--   5	-	Job Results Directory user name'
 + CHAR(10) + '--   6	-	Job Results Directory user password'
)
GO

