

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetInvalidGUID.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetInvalidGUID <<<'

IF EXISTS (select * from sysobjects where name='QS_SetInvalidGUID')
	drop procedure QS_SetInvalidGUID
IF EXISTS (select * from GxQscripts where name='QS_SetInvalidGUID')
	delete from GxQscripts where name = 'QS_SetInvalidGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetInvalidGUID')
	delete from GXDBVersions where aliasname = 'QS_SetInvalidGUID'
GO
print '... Creating Procedure: QS_SetInvalidGUID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetInvalidGUID
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_GUID VARCHAR(36)
 DECLARE @i_Authcode INT
 DECLARE @i_AlternateGUID VARCHAR(36)
---------------Local variables---------------------
 DECLARE @l_commCellNumber INT
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetInvalidGUID'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
/*Auth code.
select
(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_GUID AS VARCHAR(36))+'><COMMVAULT>')) & 2147483646)
*/
BEGIN TRY
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter) --Requires GUID and authcode
	BEGIN
		SET @localErrorMsg = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SELECT @l_commCellNumber = number from APP_CommCell where id = 2
	SET @i_GUID = @PARAM1
	SET @i_Authcode = convert(INT, @PARAM2)
	SET @i_AlternateGUID = CASE ISNULL(@PARAM3, '') WHEN '' THEN null ELSE @PARAM3 END
	IF((checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_GUID AS VARCHAR(36))+'><COMMVAULT>')) & 2147483646) <> @i_Authcode)
	BEGIN
		SET @localErrorMsg	=	'Error: Incorrect Authentication code passed '
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	IF NOT EXISTS(SELECT 1 FROM APP_InvalidGUID WHERE GUID = @i_GUID)
	BEGIN
		INSERT INTO APP_InvalidGUID
		VALUES (@i_GUID, @i_AlternateGUID)
		IF @@ERROR <> 0
		BEGIN
			SET @localErrorMsg	=	'Error: Failed to set invalid GUID. ErrorMessage : ' + ISNULL(ERROR_MESSAGE(), '')
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		SELECT 'Successfully set the invalied GUID [' + @i_GUID + ']'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetInvalidGUID')
	delete from GxQscripts where name = 'QS_SetInvalidGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetInvalidGUID')
	delete from GXDBVersions where aliasname = 'QS_SetInvalidGUID'
GO

insert into GXDBVersions values(2, 'QS_SetInvalidGUID',  '00000000000000000000', 'QS_SetInvalidGUID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetInvalidGUID',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn SetInvalidGUID -si <GUID> -si <authentication_code> -si <Alternate GUID>'
)
GO

