

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetIndexingV2Property.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetIndexingV2Property.sp,v $ $Id: QS_SetIndexingV2Property.sp,v 1.7.2.24 2020/10/08 15:51:13 mmansano Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetIndexingV2Property')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetIndexingV2Property <<<'
	drop procedure QS_SetIndexingV2Property
END
IF EXISTS (select * from GxQscripts where name='QS_SetIndexingV2Property')
	delete from GxQscripts where name = 'QS_SetIndexingV2Property'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIndexingV2Property')
	delete from GXDBVersions where aliasname = 'QS_SetIndexingV2Property'
GO
print '... Creating Procedure: QS_SetIndexingV2Property'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetIndexingV2Property
  @param1 nvarchar(1024) = '%s',
  @agent nvarchar(2)  = '%s',
  @enableSubclientIndex INT  = 0
AS
-- param1 should ideally be sending client only not groups. Can enable subclient index for unwanted clients.
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
--
DECLARE @scriptName nvarchar(32) = 'SetIndexingV2Property';
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(1024) = '';
DECLARE @warningString nvarchar(MAX) = '';
DECLARE @noParam NVARCHAR(8) = '%'
DECLARE @skippedClientsNum INTEGER = 0
DECLARE @skippedClientNames nvarchar(MAX) = ''
SET @noParam = @noParam + 's'
--
-- insufficient parameters
IF @param1 = @noParam
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Please provide client name or client group name as input.';
	GOTO ARGS_ERROR;
END
IF @agent = @noParam
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Please provide agent id as input.';
	GOTO ARGS_ERROR;
END
DECLARE @iAgent INT
IF ISNUMERIC(@agent) = 1
BEGIN
	SET @iAgent = CAST (@agent AS INT)
END
ELSE
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Invalid agent id: ' + @agent + '. Please provide a valid agent.';
	GOTO ARGS_ERROR;
END
--
-- invalid parameters
DECLARE @clientNamePrefix NVARCHAR(8) = 'c=';
DECLARE @clientIdPrefix NVARCHAR(8) = 'cId=';
DECLARE @cGroupNamePrefix NVARCHAR(8)= 'cg=';
DECLARE @cGroupIdPrefix NVARCHAR(8)= 'cgId=';
DECLARE @clientId INT;
DECLARE @clientName NVARCHAR(1024)
DECLARE @cGroupId INT;
DECLARE @cGroupName NVARCHAR(1024);
DECLARE @isClientGroup INT = 0;
--
IF LEFT(@param1, 2) = @clientNamePrefix
BEGIN
	SET @clientName =  RIGHT(@param1, LEN(@param1) - 2);
	SET @clientId = (SELECT C.id FROM APP_Client C WITH (NOLOCK) WHERE C.name = @clientName);
	IF @clientId IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client ['+ @clientName + '] does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE IF LEFT(@param1, 4) = @clientIdPrefix
BEGIN
	IF ISNUMERIC(RIGHT(@param1, LEN(@param1) - 4)) <> 1
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Invalid Client Id';
		GOTO ARGS_ERROR;
	END
	SET @clientId =  CAST(RIGHT(@param1, LEN(@param1) - 4) AS INT);
	SET @clientName = (SELECT C.name FROM APP_Client C WITH (NOLOCK) WHERE C.id = @clientId);
	IF @clientName IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Id does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE IF LEFT(@param1, 3) = @cGroupNamePrefix
BEGIN
	SET @cGroupName = RIGHT(@param1, LEN(@param1) - 3);
	SET @cGroupId = (SELECT CG.id FROM APP_ClientGroup CG WITH (NOLOCK) WHERE CG.name = @cGroupName);
	IF @cGroupId IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Group ['+ @cGroupName + '] does not exist.';
		GOTO ARGS_ERROR;
	END
	SET @isClientGroup = 1;
END
ELSE IF LEFT(@param1, 5) = @cGroupIdPrefix
BEGIN
	IF ISNUMERIC(RIGHT(@param1, LEN(@param1) - 5)) <> 1
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Invalid Client Group Id.';
		GOTO ARGS_ERROR;
	END
	SET @cGroupId = CAST(RIGHT(@param1, LEN(@param1) - 5) AS INT);
	SET @cGroupName = (SELECT CG.name FROM APP_ClientGroup CG WITH (NOLOCK) WHERE CG.id = @cGroupId);
	IF @cGroupName IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Group Id does not exist.';
		GOTO ARGS_ERROR;
	END
	SET @isClientGroup = 1;
END
ELSE
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Invalid input [' + @param1 + ']';
	GOTO ARGS_ERROR;
END
--
IF @iAgent < 1 OR @iAgent > 13
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Invalid agent input [' + @agent + ']';
	GOTO ARGS_ERROR;
END
-- set IndexingV2 property
DECLARE @indexingV2AttrName nvarchar(512) = CASE @iAgent
											WHEN 1 THEN 'IndexingV2'
											WHEN 2 THEN 'IndexingV2_Oracle'
											WHEN 3 THEN 'IndexingV2_NAS'
											WHEN 4 THEN 'IndexingV2_VSA'
											WHEN 5 THEN 'IndexingV2_SF'
											WHEN 6 THEN 'IndexingV2_ExchangeMailbox'
											WHEN 7 THEN 'IndexingV2_MSSqlServer'
											WHEN 8 THEN 'IndexingV2_Azure'
											WHEN 9 THEN 'IndexingV2_S3'
											WHEN 10 THEN 'IndexingV2_SAPHANA'
											WHEN 11 THEN 'IndexingV2_Postgress'
											WHEN 12 THEN 'IndexingV2_ExchangeDB'
											WHEN 13 THEN 'IndexingV2_Informix'
											ELSE 'IndexingV1' END
DECLARE @indexingV2AttrName10 nvarchar(512)
SET @indexingV2AttrName10 = @indexingV2AttrName + '_postponed'
DECLARE @indexingV2EnabledMaskAttrName NVARCHAR(22) = 'IndexingV2_EnabledMask'
DECLARE @timeNow INT
SET @timeNow = dbo.GetUnixTime(GETUTCDATE())
IF @isClientGroup = 1
BEGIN
	CREATE TABLE #clientReleaseTbl (clientId INT PRIMARY KEY, releaseId INT, clientName VARCHAR(MAX))
	INSERT	INTO #clientReleaseTbl
	SELECT	C.id, C.releaseId, C.name
	FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN APP_ClientGroupAssoc CG WITH (NOLOCK)
			ON C.id = CG.clientId AND CG.clientGroupId = @cGroupId
	--For Exchange DB agent delete the clients from upgrade list if any subclient in it has snap backup enabled.
	IF (@iAgent = 12)
	BEGIN
		IF object_id('tempdb.dbo.#skippedClientsFromUpgrade') IS NOT NULL DROP TABLE #skippedClientsFromUpgrade
		CREATE TABLE #skippedClientsFromUpgrade (clientId INT, clientName VARCHAR(MAX))
		DELETE CRT
		OUTPUT DELETED.clientId, DELETED.clientName	INTO #skippedClientsFromUpgrade
		FROM #clientReleaseTbl CRT
		INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.clientId = CRT.clientId
INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SCP.componentNameId = APP.id AND APP.appTypeId = 53
		AND SCP.attrName = 'Enable Snap Backups' AND SCP.modified = 0
		WHERE SCP.attrVal = 1
		SET @skippedClientsNum = @@ROWCOUNT
		IF(@skippedClientsNum > 0)
		BEGIN
			SELECT @skippedClientNames = @skippedClientNames + clientName +', ' FROM #skippedClientsFromUpgrade
			SET @warningString = 'Skipped enabling Indexing V2 for Exchange Database agent on [' + @skippedClientNames +'] client/s of client group [' + @cGroupName + ']. Reason [Snap backup enabled on one more subclients of the client]'
		END
		IF object_id('tempdb.dbo.#skippedClientsFromUpgrade') IS NOT NULL DROP TABLE #skippedClientsFromUpgrade
	END
	-- update records with disabled IndexingV2 attribute
	UPDATE	APP_ClientProp
	SET		attrVal = '1', created = @timeNow
	FROM	APP_ClientProp CP
		INNER JOIN #clientReleaseTbl CR
			ON CP.componentNameId = CR.clientId
	WHERE	attrName = (CASE WHEN CR.releaseId >= 16 THEN @indexingV2AttrName ELSE @indexingV2AttrName10 END)
		AND	attrVal = '0'
	--
	-- insert missing records
	INSERT	INTO APP_ClientProp
	SELECT	CR.clientId, (CASE WHEN CR.releaseId >= 16 THEN @indexingV2AttrName ELSE @indexingV2AttrName10 END), 2, '1', @timeNow, 0, 0
	FROM	#clientReleaseTbl CR
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON CR.clientId = CP.componentNameId
			AND CP.attrName = (CASE WHEN CR.releaseId >= 16 THEN @indexingV2AttrName ELSE @indexingV2AttrName10 END)
	WHERE	CP.componentNameId IS NULL
	-- update v2 enabled mask
	EXEC dbo.UpdateIdxV2AppTypesBitmask
	-- Reset backup ref time to 0 for FULL backups when indexing V2 is enabled for PostgreSQL App Type
	IF @iAgent=11 OR @iAgent = 12
	BEGIN
			CREATE TABLE #subClientTbl (subclientId INT PRIMARY KEY)
			INSERT INTO #subClientTbl
				SELECT A.id FROM APP_Application A
					INNER JOIN #clientReleaseTbl CR
					ON A.clientId = CR.clientId
AND A.appTypeId = CASE WHEN @iAgent = 11 THEN 125
WHEN @iAgent = 12 THEN 53
									  END
			UPDATE	APP_SubClientProp
				SET		attrVal = 0
				FROM	APP_SubClientProp SCP
					INNER JOIN #subClientTbl SC
						ON SCP.componentNameId = SC.subclientId
						WHERE SCP.attrName = 'sys:last full'
						AND SCP.modified = 0
						AND SCP.attrVal <> 0
			UPDATE	APP_SubClientProp
				SET modified = @timeNow
				FROM	APP_SubClientProp SCP
					INNER JOIN #subClientTbl SC
						ON SCP.componentNameId = SC.subclientId
						WHERE SCP.attrName = 'Reason last backup time cleared'
						AND SCP.modified = 0
			INSERT INTO APP_SubClientProp (componentnameid, attrname, attrval, attrtype, created, modified)
				SELECT SC.subclientId, 'Reason last backup time cleared', 30, 7, @timeNow, 0  FROM #subClientTbl SC
			-- CV_CLEAR_UPGRADED 30, PROPERTY_INTEGER  7
			DROP TABLE #subClientTbl
	END
	DECLARE @m_xmlText XML
	DECLARE @m_clientId INT
	DECLARE the_cursor CURSOR FAST_FORWARD
	FOR SELECT CR.clientId
		FROM #clientReleaseTbl CR
			INNER JOIN App_ClientProp CP WITH (NOLOCK) ON CR.clientId = CP.componentNameId
		WHERE	CP.attrName = 'IndexingV2'
			AND	CP.attrVal='1'
			AND	CP.modified=0
			AND	CR.releaseId > 15
	OPEN the_cursor
	FETCH NEXT FROM the_cursor INTO @m_clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @m_xmlText =    (SELECT
								(SELECT @m_clientId AS '@clientId'
									FOR XML PATH('client'), TYPE)
							FOR XML PATH('App_UpgradeRetentionPropertiesReq'), TYPE )
		EXEC dbo.AppUpgradeRetentionPropertiesV2 @m_xmlText OUTPUT
		FETCH NEXT FROM the_cursor INTO @m_clientId
	END
	CLOSE the_cursor
	DEALLOCATE the_cursor
	DROP TABLE #clientReleaseTbl
END
ELSE
BEGIN
	DECLARE @releaseId INT
	SELECT @releaseId = C.releaseId FROM APP_Client C WITH (NOLOCK) WHERE C.id = @clientId
	DECLARE @indexingAttrName NVARCHAR(512)
	SET @indexingAttrName = (CASE WHEN @releaseId >= 16 THEN @indexingV2AttrName ELSE @indexingV2AttrName10 END)
	DECLARE @indexingAttributeExists INT = 0
	DECLARE @indexingAttributeDisabled INT = 0
	--For Exchange DB agent fail if any subclient for the client has snap backup enabled.
	IF (@iAgent = 12 AND EXISTS ( SELECT 1 FROM APP_Application APP WITH(NOLOCK) INNER JOIN APP_SubClientProp SCP WITH(NOLOCK)
ON APP.clientId = @clientId AND SCP.componentNameId = APP.id AND APP.appTypeId = 53
								  AND SCP.attrName = 'Enable Snap Backups' AND SCP.modified = 0
								  WHERE SCP.attrVal = 1)
		)
	BEGIN
		SET @errorCode = 2;
		SET @errorString = 'Error: Snap backup enabled on one or more subclients. Failed to enable Indexing V2 for client [' + @clientName + '] Exchange database agent.';
		GOTO ARGS_ERROR;
	END
	IF EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingAttrName AND modified=0)
	BEGIN
		SET @indexingAttributeExists = 1
	END
	IF NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingAttrName AND attrVal = '1' AND modified=0)
		AND @indexingAttributeExists = 1
	BEGIN
		SET @indexingAttributeDisabled = 1
	END
	IF @releaseId >= 16
	BEGIN
		IF @indexingAttributeExists = 0
		BEGIN
			IF @iAgent=1 and EXISTS (SELECT 1 FROM GXGlobalParam where name='NewFsClientWithV1Index' and value='1')
				INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, '0', @timeNow, 0, 0;
			ELSE
				INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, '1', @timeNow, 0, 0;
		END
		ELSE IF @indexingAttributeDisabled = 1
			UPDATE APP_ClientProp SET attrVal = '1', created = @timeNow WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND modified=0;
		-- update v2 enabled mask
		EXEC dbo.UpdateIdxV2AppTypesBitmask @clientId
		-- Reset backup ref time to 0 for FULL backups when indexing V2 is enabled for PostgreSQL App Type and Exchange DB
		IF @iAgent=11 OR @iAgent = 12
	    BEGIN
			CREATE TABLE #subClientTblN (subclientId INT PRIMARY KEY)
			INSERT INTO #subClientTblN
				SELECT A.id FROM APP_Application A
					WHERE A.clientId = @clientId
AND A.appTypeId = CASE WHEN @iAgent = 11 THEN 125
WHEN @iAgent = 12 THEN 53
									  END
			UPDATE	APP_SubClientProp
				SET		attrVal = 0
				FROM	APP_SubClientProp SCP
					INNER JOIN #subClientTblN SC
						ON SCP.componentNameId = SC.subclientId
						WHERE SCP.attrName = 'sys:last full'
						AND SCP.modified = 0
						AND SCP.attrVal <> 0
			UPDATE	APP_SubClientProp
				SET modified = @timeNow
				FROM APP_SubClientProp SCP
					INNER JOIN #subClientTblN SC
						ON SCP.componentNameId = SC.subclientId
						WHERE SCP.attrName = 'Reason last backup time cleared'
						AND SCP.modified = 0
			INSERT INTO APP_SubClientProp (componentnameid, attrname, attrval, attrtype, created, modified)
				SELECT SC.subclientId, 'Reason last backup time cleared', 30, 7, @timeNow, 0  FROM #subClientTblN SC
			-- CV_CLEAR_UPGRADED 30, PROPERTY_INTEGER  7
			DROP TABLE #subClientTblN
	    END
		if @indexingV2AttrName = 'IndexingV2' AND EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND attrVal = '1' and modified=0)
		BEGIN
			SET @m_xmlText =    (SELECT
									(SELECT @clientId AS '@clientId'
										FOR XML PATH('client'), TYPE)
								FOR XML PATH('App_UpgradeRetentionPropertiesReq'), TYPE )
			EXEC dbo.AppUpgradeRetentionPropertiesV2 @m_xmlText OUTPUT
		END
		--> For NAS, subclient index is default enabled
		IF (@iAgent = 3) OR
           (@iAgent = 1 AND EXISTS (SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = @clientId AND ( (status & 0x80) <> 0 OR (status & 0x8000000) <> 0) ) ) --CV_STATUS_NAS, CV_STATUS_NON_NDMP
		   OR @enableSubclientIndex > 0
		BEGIN
			DECLARE @agentType INT = 1
			IF (@iAgent = 3)
				SET @agentType = 2
			EXEC dbo.QS_EnableSubclientIndex @param1, @agentType, 2
		END
	END
	IF @releaseId < 16
	BEGIN
		IF @indexingAttributeExists = 0
			INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName10, 2, '1', @timeNow, 0, 0;
		ELSE IF @indexingAttributeDisabled = 1
			UPDATE APP_ClientProp SET attrVal = '1', created = @timeNow WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName10;
	END
END
--
ARGS_ERROR:
IF (@warningString <> '')
BEGIN
	PRINT 'Warning: ' + @warningString
END
PRINT CHAR(10) + @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE()) + ' with input '
	+ IIF(@isClientGroup <> 1, 'client name ['+ @clientName, 'client group name ['+ @cGroupName)
	+ ']. Error Code ['+ CONVERT(nvarchar(2), @errorCode) +'].'
IF @errorCode <> 0
	RAISERROR(@errorString, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetIndexingV2Property')
	delete from GxQscripts where name = 'QS_SetIndexingV2Property'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIndexingV2Property')
	delete from GXDBVersions where aliasname = 'QS_SetIndexingV2Property'
GO

insert into GXDBVersions values(2, 'QS_SetIndexingV2Property',  '00010007000200240000', 'QS_SetIndexingV2Property', '00010007000200240000')
GO

insert into GxQscripts values(2,'QS_SetIndexingV2Property',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' Enables new indexing on input client or input client group for the given input agent type.
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn SetIndexingV2Property.sql -si c=client_name -si <agent>'
 + CHAR(10) + '--  qoperation execscript -sn SetIndexingV2Property.sql -si cg=client_group_name -si <agent>'
 + CHAR(10) + '--  qoperation execscript -sn SetIndexingV2Property.sql -si cId=client_id -si <agent>'
 + CHAR(10) + '--  qoperation execscript -sn SetIndexingV2Property.sql -si cgId=client_group_id -si <agent>'
 + CHAR(10) + '--  Agent Mapping'
 + CHAR(10) + '--  1	-	FileSystem'
 + CHAR(10) + '--  2	-	Oracle'
 + CHAR(10) + '--  3	-	NAS'
 + CHAR(10) + '--  4	-	VSA'
 + CHAR(10) + '--  5	- 	SalesForce'
 + CHAR(10) + '--  6	-	ExchangeMailBox'
 + CHAR(10) + '--  7	-	MSSqlServer'
 + CHAR(10) + '--  8	-	Azure'
 + CHAR(10) + '--  9	-	S3'
 + CHAR(10) + '--  10	-	SAP HANA'
 + CHAR(10) + '--  11	-	PostgreSQL'
 + CHAR(10) + '--  12	-	Exchange Database'
 + CHAR(10) + '--  13	-	Informix'
 + CHAR(10) + ' 
'
)
GO

