

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetIndexSearchEngineAssoc.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetIndexSearchEngineAssoc <<<'

IF EXISTS (select * from sysobjects where name='QS_SetIndexSearchEngineAssoc')
	drop procedure QS_SetIndexSearchEngineAssoc
IF EXISTS (select * from GxQscripts where name='QS_SetIndexSearchEngineAssoc')
	delete from GxQscripts where name = 'QS_SetIndexSearchEngineAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIndexSearchEngineAssoc')
	delete from GXDBVersions where aliasname = 'QS_SetIndexSearchEngineAssoc'
GO
print '... Creating Procedure: QS_SetIndexSearchEngineAssoc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetIndexSearchEngineAssoc
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_exchVirtualCloudName nvarchar(2048) = N'',
  @i_searchEngineList nvarchar(2048) =N'',
  @i_operationType varchar(2048) =N'ADD'
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetIndexSearchEngineAssoc'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @exchVirtualCloudId		INTEGER = 0
DECLARE @nowTime INT
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @propertyTypeId INT = 0
-----------------------invalid parameters------------------------------
IF(@i_exchVirtualCloudName = @NoParameter OR @i_searchEngineList = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of Search engines---------------------
IF @i_exchVirtualCloudName ='Mailbox Index'
BEGIN
	SELECT  @exchVirtualCloudId = cloudId
		FROM DM2CLOUD WITH (NOLOCK)
WHERE (flags & 4) > 0
SET @propertyTypeId = 1040
END
ELSE IF @i_exchVirtualCloudName ='Journal Index'
BEGIN
	SELECT  @exchVirtualCloudId = cloudId
		FROM DM2CLOUD WITH (NOLOCK)
WHERE (flags & 2) > 0
SET @propertyTypeId = 1041
END
IF ISNULL(@exchVirtualCloudId, 0) =0
BEGIN
	SET @errorString = N'Wrong virtual cloud name ['+ @i_exchVirtualCloudName +'] is provided.'
	SET @errorCode = 2
	GOTO SCRIPT_EXIT
END
IF (OBJECT_ID('tempdb.dbo.#searchEngineList') IS NOT NULL) DROP TABLE #searchEngineList
CREATE TABLE #searchEngineList
(
    t_cloudId INT
)
IF ISNULL(@i_searchEngineList, N'') <> N''
BEGIN
    INSERT INTO #searchEngineList (t_cloudId)
    SELECT id
	FROM APP_componentProp (nolock)
    WHERE stringval IN (SELECT Data FROM dbo.SplitString(@i_searchEngineList, ','))
END
IF NOT EXISTS (SELECT 1 FROM #searchEngineList)
BEGIN
	SET @errorString = N'Wrong search engine names ['+ @i_searchEngineList +'] are provided.'
	SET @errorCode = 3
	GOTO SCRIPT_EXIT
END
-----------------set virtual to physical search enigne associations--------------
BEGIN TRAN
	BEGIN TRY
		IF @i_operationType = 'ADD'
		BEGIN
			INSERT INTO APP_ComponentProp (componentType, componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created, modified)
SELECT  2 , @exchVirtualCloudId, @propertyTypeId, 7, t_cloudId, 0, '', @nowTime, 0
			FROM #searchEngineList
WHERE NOT EXISTS (SELECT 1 FROM  APP_ComponentProp (nolock)  WHERE  componentType = 2 AND componentId = @exchVirtualCloudId
                                    AND propertyTypeId = @propertyTypeId AND longVal= t_cloudId)
		END
		ELSE IF @i_operationType = 'REMOVE'
		BEGIN
			DELETE  CP
			FROM APP_ComponentProp CP
			JOIN #searchEngineList T ON CP.longVal= t_cloudId
WHERE  componentType = 2 AND componentId = @exchVirtualCloudId
                                    AND propertyTypeId = @propertyTypeId
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_exchVirtualCloudName + ', '+@i_searchEngineList +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetIndexSearchEngineAssoc')
	delete from GxQscripts where name = 'QS_SetIndexSearchEngineAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIndexSearchEngineAssoc')
	delete from GXDBVersions where aliasname = 'QS_SetIndexSearchEngineAssoc'
GO

insert into GXDBVersions values(2, 'QS_SetIndexSearchEngineAssoc',  '00000000000000000000', 'QS_SetIndexSearchEngineAssoc', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetIndexSearchEngineAssoc',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetIndexSearchEngineAssoc.sql -si ''ExchangeVirtualCloud'' -si ''SearchEngineList'' [-si ''ADD/REMOVE'']
'
 + CHAR(10) + '-- 	script_name: QS_SetIndexSearchEngineAssoc'
 + CHAR(10) + '-- 	 Qscript to set association between virtual cloud to physical search engines.'
 + CHAR(10) + '-- 	ExchangeVirtualCloud - specifies Exchange virtual cloud names (Journal Index/ Mailbox Index)'
 + CHAR(10) + '-- 	SearchEngines - specifies list of comma seperated search engine  names. (eg. ''SE1,SE2,SE3'' )'
 + CHAR(10) + '-- 	ADD/REMOVE [OPTIONAL]- ADD - to add search engine to existing exchange virtual cloud, REMOVE - to delete search engine from existing virtual cloud, default is ADD '
)
GO

