

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetIDAVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetIDAVersion <<<'

IF EXISTS (select * from sysobjects where name='QS_SetIDAVersion')
	drop procedure QS_SetIDAVersion
IF EXISTS (select * from GxQscripts where name='QS_SetIDAVersion')
	delete from GxQscripts where name = 'QS_SetIDAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIDAVersion')
	delete from GXDBVersions where aliasname = 'QS_SetIDAVersion'
GO
print '... Creating Procedure: QS_SetIDAVersion'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetIDAVersion
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @idaType varchar(1024) = '%s',
  @idaVersion varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName	= '%s'
--DECLARE @idaType	varchar(1024)
--SET		@idaType	= '%s'
--DECLARE @idaVersion	varchar(1024)
--SET		@idaVersion	= '%s'
---------------------------------------
--test
--SET		@clientName	= 'MyClient'
--SET		@idaType	= 'File System'
--SET		@idaVersion	= '12'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetIDAVersion'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @clientName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client Name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @idaType	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA type Expected as parameter 2.'
	GOTO ARGS_ERROR
END
IF @idaVersion	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA version name Expected as parameter 3.'
	GOTO ARGS_ERROR
END
--------------Validate client name ---------------------
DECLARE @clientId	INT
DECLARE @now		INT
DECLARE @componentId	INT
DECLARE @appTypeId	INT
SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName), 0)
IF @clientId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client [' + @clientName + '] Not found.'
	GOTO ARGS_ERROR
END
SET @appTypeId = ISNULL((SELECT DISTINCT type FROM APP_IDAType WHERE displayName = @idaType AND
			type IN (SELECT DISTINCT appTypeId FROM APP_Application WHERE clientId = @clientId)), 0)
IF @appTypeId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Application type [' + @idaType + '] Not found for client ['+@clientName+'].'
	GOTO ARGS_ERROR
END
SET @now = dbo.GetUnixTime (GetUTCdate())
SET @componentId = ISNULL((SELECT TOP 1 id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = @appTypeId), 0)
IF @componentId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Could not find appType ['+@idaType+'] for client ['+@clientName+'].'
	GOTO ARGS_ERROR
END
--------------SETP 1 ---------------------
BEGIN TRY
BEGIN TRAN
	IF EXISTS(SELECT * FROM APP_IDAProp WHERE attrName='IDA Version' AND componentNameId = @componentId AND modified = 0 )
	BEGIN	--DO UPDATE
		UPDATE APP_IDAProp SET modified = @now WHERE attrName='IDA Version' AND componentNameId IN (
		SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = @appTypeId
		) AND modified = 0
	END
	INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrVal, created, modified)
	VALUES (@componentId, 'IDA Version', 10, @idaVersion, @now, 0)
	set @lastError = @@ERROR
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not update property'
		GOTO TRANS_EXIT
	END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	DECLARE @o_errorCode INT
	DECLARE @tmpErrorString NVARCHAR
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
	PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
	PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'
		ROLLBACK TRANSACTION;
	END
END CATCH;
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName+', '+@idaType+', '+@idaVersion+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetIDAVersion')
	delete from GxQscripts where name = 'QS_SetIDAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIDAVersion')
	delete from GXDBVersions where aliasname = 'QS_SetIDAVersion'
GO

insert into GXDBVersions values(2, 'QS_SetIDAVersion',  '00000000000000000000', 'QS_SetIDAVersion', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetIDAVersion',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn SetIDAVersion.sql -si clientName -si ida type -si version
'
 + CHAR(10) + '--   script_name : SetIDAVersion'
)
GO

