

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetHoliday.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetHoliday <<<'

IF EXISTS (select * from sysobjects where name='QS_SetHoliday')
	drop procedure QS_SetHoliday
IF EXISTS (select * from GxQscripts where name='QS_SetHoliday')
	delete from GxQscripts where name = 'QS_SetHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetHoliday')
	delete from GXDBVersions where aliasname = 'QS_SetHoliday'
GO
print '... Creating Procedure: QS_SetHoliday'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetHoliday
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @Name NVARCHAR(80) = '%s',
  @isAnually NVARCHAR(4) = '%s',
  @StartDateTime NVARCHAR(100) = '%s',
  @EndDateTime NVARCHAR(100) = '%s',
  @HolidayDescription NVARCHAR(80) = '%s'
AS
---------------command line inputs-------
--DECLARE @Name NVARCHAR(80)
--SET @Name = '%s'
--DECLARE @isAnually NVARCHAR(4)
--SET @isAnually = '%s'
--DECLARE @StartDateTime NVARCHAR(100)
--SET @StartDateTime = '%s'
--DECLARE @EndDateTime NVARCHAR(100)
--SET @EndDateTime = '%s'
--DECLARE @HolidayDescription NVARCHAR(80)
--SET @HolidayDescription = '%s'
------------------command line input format------------------------------
-- cl=name YES/NO 10/17/2009 14:29:20 10/18/2009 16:29:20  Its a festival
-------------------------------------------------------------------------
------------------input prefixes-----------------------------------------
----------------------constants------------------------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetHoliday'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling------------------------------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters -----------------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
BEGIN TRAN
IF @Name = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Group/Client Name not given.'
	GOTO ARGS_ERROR
END
SET @Name = RTRIM(LTRIM(@Name))
IF @StartDateTime = @noParameter or @EndDateTime = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Date and Time not given.'
	GOTO ARGS_ERROR
END
IF @isAnually = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error.Anunal Holiday Information not given (Yes/No)'
	GOTO ARGS_ERROR
END
IF @HolidayDescription = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Holday description is not given'
	GOTO ARGS_ERROR
END
-------------------------------------------------------------------------------
DECLARE @ClientId  INT
DECLARE @GroupId  INT
DECLARE @vtPolicyId INT
DECLARE @association NVARCHAR(10)
DECLARE @pos INT
BEGIN TRY
SET @association = UPPER(RTRIM(LTRIM(@Name)))
SET @pos = CHARINDEX('=',@association)
IF (@pos > 0)
BEGIN
	SET @association = LEFT(@association, @pos-1)
	SET @Name = RIGHT(@Name, LEN(@Name)-@pos)
END
IF @association = 'CG'
BEGIN
	IF EXISTS(SELECT id FROM APP_ClientGroup where name = @Name)
	BEGIN
		SET @GroupId = (SELECT id FROM APP_ClientGroup where name = @Name)
		SET @ClientId = 0
		SET @vtPolicyId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid Group Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'CL'
BEGIN
	IF EXISTS(SELECT id FROM APP_Client where name = @Name)
	BEGIN
		SET @ClientId = (SELECT id FROM APP_Client where name = @Name)
		SET @GroupId = 0
		SET @vtPolicyId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid Client Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'VT'
BEGIN
	IF EXISTS(SELECT PolicyId FROM VTPolicy where PolicyName = @Name)
	BEGIN
		SET @vtPolicyId = (SELECT PolicyId FROM VTPolicy where PolicyName = @Name)
		SET @GroupId = 0
		SET @ClientId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid VT Policy Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'CS'
BEGIN
	SET @ClientId = 0
	SET @GroupId = 0
	SET @vtPolicyId = 0
END
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid holiday association type'
	GOTO ARGS_ERROR
END
SET @isAnually = UPPER(RTRIM(LTRIM(@isAnually)))
DECLARE @isAnuallyInt int
SET @isAnuallyInt = (SELECT CASE(@isAnually) WHEN('YES') THEN 1 ELSE 0 END)
DECLARE @StartDay	int
SET @StartDay = 0
DECLARE @StartMonth	int
SET @StartMonth	= 0
DECLARE @StartYear	int
SET @StartYear	= 0
DECLARE @StartHour	int
SET @StartHour = 0
DECLARE @StartMin	int
SET @StartMin = 0
DECLARE @StartSec	int
SET @StartSec = 0
DECLARE @EndDay		int
SET @EndDay = 0
DECLARE @EndMonth	int
SET @EndMonth = 0
DECLARE @EndYear	int
SET @EndYear = 0
DECLARE @EndHour	int
SET @EndHour = 0
DECLARE @EndMin		int
SET @EndMin = 0
DECLARE @EndSec		int
SET @EndSec = 0
BEGIN TRY
		SET @StartDay	= DATEPART(DAY,@StartDateTime)
		SET @StartMonth	= DATEPART(MONTH,@StartDateTime)
		SET @StartYear	= DATEPART(YEAR,@StartDateTime)
		SET @StartHour	= DATEPART(HOUR,@StartDateTime)
		SET @StartMin	= DATEPART(MINUTE,@StartDateTime)
		SET @StartSec	= DATEPART(SECOND,@StartDateTime)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = 1
		SET @errorString = 'Error. Wrong Start Date Time given'
		GOTO ARGS_ERROR
END CATCH
BEGIN TRY
		SET @EndDay		= DATEPART(DAY,@EndDateTime)
		SET @EndMonth	= DATEPART(MONTH,@EndDateTime)
		SET @EndYear	= DATEPART(YEAR,@EndDateTime)
		SET @EndHour	= DATEPART(HOUR,@EndDateTime)
		SET @EndMin		= DATEPART(MINUTE,@EndDateTime)
		SET @EndSec		= DATEPART(SECOND,@EndDateTime)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = 1
		SET @errorString = 'Error. Wrong End Date Time given'
		GOTO ARGS_ERROR
END CATCH
BEGIN TRY
DECLARE @dtDiff int
SET @dtDiff = (SELECT DATEDIFF(SECOND, GETDATE(),@StartDateTime))
IF(@dtDiff < 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Past date are not allowed ['+@StartDateTime+']'
	GOTO ARGS_ERROR
END
SET @dtDiff = (SELECT DATEDIFF(SECOND, GETDATE(),@EndDateTime))
IF(@dtDiff < 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Past date are not allowed ['+@EndDateTime+']'
	GOTO ARGS_ERROR
END
SET @dtDiff = (SELECT DATEDIFF(SECOND, @StartDateTime,@EndDateTime))
IF (@dtDiff <= 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. End Date should be bigger than start date'
	GOTO ARGS_ERROR
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	SET @errorString = 'Error. Please Do not put Such a long Leave'
	GOTO ARGS_ERROR
END CATCH
SET @StartMonth = @StartMonth -1 -- start for 0 offset
SET @EndMonth = @EndMonth -1	 -- start for 0 offset
IF EXISTS(select * from SchedHoliday where (startYear = @StartYear or startYear = 0) and startMonth = @StartMonth and startDay = @StartDay and
startHour = @StartHour and startMinute = @StartMin and startSecond = @StartSec and endDay = @EndDay and endMonth = @EndMonth and
(endYear = @EndYear or endYear = 0) and endHour = @EndHour and endMinute = @EndMin and endSecond = @EndSec and clientId = @ClientId and groupId = @GroupId and vtPolicyId = @vtPolicyId)
BEGIN
	update SchedHoliday set description = @HolidayDescription,modified = @nowTime ,
		startYear = CASE(@isAnuallyInt)WHEN(0) THEN @StartYear ELSE 0 END
		,endYear = CASE(@isAnuallyInt)WHEN(0) THEN @EndYear ELSE 0 END
		where (startYear = @StartYear or startYear = 0) and startMonth = @StartMonth and startDay = @StartDay and
			startHour = @StartHour and startMinute = @StartMin and startSecond = @StartSec and endDay = @EndDay and endMonth = @EndMonth and
			(endYear = @EndYear or endYear = 0) and endHour = @EndHour and endMinute = @EndMin and endSecond = @EndSec and clientId = @ClientId and groupId = @GroupId and vtPolicyId = @vtPolicyId
	SET @errorCode = @@error
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Updation failed'
		GOTO ARGS_ERROR
	END
END
ELSE
BEGIN
	IF @isAnuallyInt <> 0
	BEGIN
		SET @EndYear	= 0
		SET @StartYear	= 0
	END
	insert into SchedHoliday (startYear,startMonth ,startDay,startHour,startMinute,startSecond,endYear,endMonth,endDay,
								endHour,endMinute,endSecond,clientId,groupId,description,modified,vtPolicyId)
		values(@StartYear,@StartMonth,@StartDay,@StartHour,@StartMin,@StartSec,@EndYear,@EndMonth,@EndDay,@EndHour,@EndMin,@EndSec,@ClientId,@GroupId,@HolidayDescription,@nowTime,@vtPolicyId)
	SET @errorCode = @@error
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Insertion failed'
		GOTO ARGS_ERROR
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+ ' with Parameters:[ clientId=' +CAST(@ClientId AS NVARCHAR(10))+ ' client groupId='+CAST(@GroupId AS NVARCHAR(10))+ ' VT PolicyId='+CAST(@vtPolicyId AS NVARCHAR(10))+ ' IsAnually='+@isAnually+
				' StartDateTime='+@StartDateTime + ' EndDateTime='+@EndDateTime+ ' Holiday Description='+@HolidayDescription +']. ErrorCode('+ Convert(varchar(2),@errorCode) +').'
ARGS_ERROR:
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetHoliday')
	delete from GxQscripts where name = 'QS_SetHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetHoliday')
	delete from GXDBVersions where aliasname = 'QS_SetHoliday'
GO

insert into GXDBVersions values(2, 'QS_SetHoliday',  '00000000000000000000', 'QS_SetHoliday', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetHoliday',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetHoliday.sql -si name -si isAnnualHoliday -si StartDateTime -si EndDateTime -si HolidayDescription
'
 + CHAR(10) + '--   script_name : SetHoliday'
)
GO

