

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetGuiAuditRetention.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- $Id: QS_SetGuiAuditRetention.sp,v 1.2.72.2 2018/03/20 00:50:19 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetGuiAuditRetention <<<'

IF EXISTS (select * from sysobjects where name='QS_SetGuiAuditRetention')
	drop procedure QS_SetGuiAuditRetention
IF EXISTS (select * from GxQscripts where name='QS_SetGuiAuditRetention')
	delete from GxQscripts where name = 'QS_SetGuiAuditRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGuiAuditRetention')
	delete from GXDBVersions where aliasname = 'QS_SetGuiAuditRetention'
GO
print '... Creating Procedure: QS_SetGuiAuditRetention'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetGuiAuditRetention
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_opString NVARCHAR(1024),
  @i_userName NVARCHAR(1024),
  @i_retentionDays INTEGER
AS
SET NOCOUNT ON
/*
DECLARE @i_opString NVARCHAR(1024)
DECLARE @i_userName NVARCHAR(1024)
DECLARE @i_retentionDays INTEGER
SET @i_opString = 'Command-line Login'
SET @i_userName = 'admin'
SET @i_retentionDays = 0
*/
DECLARE @localErrorMsg NVARCHAR(1024)
DECLARE @l_messageId BIGINT
DECLARE @l_userId INT
DECLARE @l_retentionDays INT
SELECT @l_messageId = MessageID from EvLocaleMsgs where LocaleID = 0 and Message = @i_opString and SubSystemId = 84
SELECT @l_userId = id from UMUsers where Login = @i_userName
IF @i_opString = '' OR @l_messageId IS null
BEGIN
	SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Invalid GUI operation specified.'
	GOTO ERROR_EXIT
END
IF @i_userName = '' OR @l_userId IS null
BEGIN
	SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Invalid user login specified.'
	GOTO ERROR_EXIT
END
IF @i_retentionDays IS null OR @i_retentionDays < -1
BEGIN
	SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Invalid retention days specified.'
	GOTO ERROR_EXIT
END
IF object_id('dbo.EvGuiAuditRetention') IS null
BEGIN
	CREATE TABLE EvGuiAuditRetention
		(
		opMsgId				integer,
		userId				integer,
		retentionDays		integer,
		primary key (opMsgId, userId),
		foreign key (userId) references UMUsers(id) ON DELETE CASCADE
		)
		IF @@ERROR > 0
		BEGIN
			SET @localErrorMsg = 'Failed to create table EvGuiAuditRetention.'
			GOTO ERROR_EXIT
		END
END
SELECT @l_retentionDays = retentionDays FROM EvGuiAuditRetention where opMsgId = @l_messageId and userId = @l_userId
IF @i_retentionDays = 0
BEGIN
	IF @l_retentionDays IS null
	BEGIN
		SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- There is no retention setting to delete.'
		GOTO ERROR_EXIT
	END
	ELSE
	BEGIN
		DELETE FROM EvGuiAuditRetention WHERE opMsgId = @l_messageId and userId = @l_userId
		IF @@ERROR = 0
			PRINT 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Retention setting is deleted.'
		ELSE
		BEGIN
			SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Failed to delete retention setting.'
			GOTO ERROR_EXIT
		END
	END
END
ELSE IF @l_retentionDays IS null
BEGIN
	insert into EvGuiAuditRetention select @l_messageId, @l_userId, @i_retentionDays
	IF @@ERROR = 0
		PRINT 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Retention days is set to [' + CAST(@i_retentionDays AS VARCHAR(12)) + '].'
	ELSE
	BEGIN
		SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Failed to add retention setting.'
		GOTO ERROR_EXIT
	END
END
ELSE
BEGIN
	IF @l_retentionDays <> @i_retentionDays
	BEGIN
		UPDATE EvGuiAuditRetention SET retentionDays = @i_retentionDays
		WHERE opMsgId = @l_messageId AND userId = @l_userId
		IF @@ERROR = 0
			PRINT 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Retention days is changed from [' + CAST(@l_retentionDays AS VARCHAR(12)) + '] to [' + CAST(@i_retentionDays AS VARCHAR(12)) + '].'
		ELSE
		BEGIN
			SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- Failed to update retention setting.'
			GOTO ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'GUI Operation [' + @i_opString + '] user [' + @i_userName + '] -- The same retention days has been set.'
		GOTO ERROR_EXIT
	END
END
IF @localErrorMsg IS NULL
	RETURN
ERROR_EXIT:
	Raiserror(@localErrorMsg, 15, 1)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetGuiAuditRetention')
	delete from GxQscripts where name = 'QS_SetGuiAuditRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGuiAuditRetention')
	delete from GXDBVersions where aliasname = 'QS_SetGuiAuditRetention'
GO

insert into GXDBVersions values(2, 'QS_SetGuiAuditRetention',  '00010002007200020000', 'QS_SetGuiAuditRetention', '00010002007200020000')
GO

insert into GxQscripts values(2,'QS_SetGuiAuditRetention',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn SetGuiAuditRetention -si "GUI Audit Operation" -si userName -si retentionDays'
 + CHAR(10) + '-- 	retentionDay values: ''-1'' is to set retention to infinite; 0 is to delete existing setting; 1 or bigger is the retention days'
)
GO

