

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetGlobalFilterState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetGlobalFilterState <<<'

IF EXISTS (select * from sysobjects where name='QS_SetGlobalFilterState')
	drop procedure QS_SetGlobalFilterState
IF EXISTS (select * from GxQscripts where name='QS_SetGlobalFilterState')
	delete from GxQscripts where name = 'QS_SetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_SetGlobalFilterState'
GO
print '... Creating Procedure: QS_SetGlobalFilterState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetGlobalFilterState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @STATE varchar(1024) = '%s',
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @STATE	varchar(1024)
--SET		@STATE  = '%s'
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
------------------------------
--SKATZ As Extracted from reported error email:
--SET		@STATE  = 'ON'
--SET		@PARAM1 = 'c=bigblue'
--SET		@PARAM2	= 'a=Q_SOLARIS_FS'
--SET		@PARAM3 = 'b=CmpTests'
--SET		@PARAM4 = 's=default'
--SET		@PARAM5 = '%s'
------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetGlobalFilterState'
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
DECLARE @NoParameter varchar(4)
SET @NoParameter = '%s'
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------------ Get ids ---------------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
------------------- VAlidate inputs --------------------------------
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy' and componentnameid = @backupsetid AND modified = 0),0)
DECLARE @useSCPfilters integer
if @scpid >0
begin
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where componentNameId = @subClientid AND attrname like 'use SCP filters' AND modified=0), 0)
end
if @useSCPfilters <> 0
BEGIN
	SET @localErrorMsg	='Cannot set global filters for subclient. It is associated to a subclient policy and uses policy filters.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @AppTypeId NOT IN (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,  54,56,57,58, 63,64,67,68,74,86, 105,106)
BEGIN
	SET @localErrorMsg	='Global filters are not applicable to iDA ['+@PARAM2+'].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @STATE= @NoParameter OR (@STATE <> N'ON' AND @STATE <> N'OFF' AND @STATE <> N'ENABLE' AND @STATE <> N'DISABLE' AND @STATE <> 'USE CELL LEVEL POLICY')
BEGIN
	SET @localErrorMsg	='Parameter1 Global Filter State must be "OFF" or "ON" or "USE CELL LEVEL POLICY"'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------ ONLY AGE OLD PROPERTY/ADD NEW IF THE STATE OF THE PROPERTY HAS CHANGED!
DECLARE @propVal1 integer
DECLARE @propVal2 integer
DECLARE @oldPropVal1 integer
DECLARE @oldPropVal2 integer
IF(@state = N'OFF')
BEGIN
	SET @propVal1 = 0
	SET @propVal2 = 0
END
ELSE IF(@state = N'ON')
BEGIN
	SET @propVal1 = 0
	SET @propVal2 = 1
END
ELSE IF(@state = N'USE CELL LEVEL POLICY')
BEGIN
	SET @propVal1 = 1
	SET @propVal2 = 0
END
SET @oldPropVal1 = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), 1)
SET @oldPropVal2 = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), 0)
BEGIN TRY
	BEGIN TRAN
	-- ONLY AGE OLD PROPERTY/ADD NEW IF THE STATE OF THE PROPERTY HAS CHANGED!
	IF @propVal1 <> @oldPropVal1
	BEGIN
		UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1
		INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
								VALUES (@subclientId, @nowTime, 0, 2 , @propName1, @propVal1)
	END
	IF @propVal2 <> @oldPropVal2
	BEGIN
		UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2
		INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
								VALUES (@subclientId, @nowTime, 0, 2 , @propName2, @propVal2)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN
    SET @lastError = ERROR_NUMBER()
    SET @localErrorMsg = 'Problems updating Global filter state' +ERROR_MESSAGE()
END
END CATCH
IF @lastError = 0
	COMMIT TRAN
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
--
-- Select * from app_subclientProp where componentNameId=208 and attrName=@propname
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetGlobalFilterState')
	delete from GxQscripts where name = 'QS_SetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_SetGlobalFilterState'
GO

insert into GXDBVersions values(2, 'QS_SetGlobalFilterState',  '00000000000000000000', 'QS_SetGlobalFilterState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetGlobalFilterState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetGlobalFilterState.sql -si OFF/ON/"USE CELL LEVEL POLICY" -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : SetGlobalFilterState'
)
GO

