

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetFlushBlockSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetFlushBlockSize.sp,v $ $Id: QS_SetFlushBlockSize.sp,v 1.5.14.2 2018/03/22 00:58:01 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetFlushBlockSize <<<'

IF EXISTS (select * from sysobjects where name='QS_SetFlushBlockSize')
	drop procedure QS_SetFlushBlockSize
IF EXISTS (select * from GxQscripts where name='QS_SetFlushBlockSize')
	delete from GxQscripts where name = 'QS_SetFlushBlockSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFlushBlockSize')
	delete from GXDBVersions where aliasname = 'QS_SetFlushBlockSize'
GO
print '... Creating Procedure: QS_SetFlushBlockSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetFlushBlockSize
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @option NVARCHAR(64),
  @RecordingFormat NVARCHAR(MAX),
  @FlushBlockSize INT = 0
AS
SET NOCOUNT ON
DECLARE @Str VARCHAR(1024)
DECLARE @CurFlushBlockSize INT
IF @option <> 'SET' AND @option <> 'VIEW'
BEGIN
	SET @Str = 'Error. Invalid option parameter [' + @option + '] specified.'
	GOTO PROC_ERROR
END
IF @option = 'SET' AND (@FlushBlockSize%32 <> 0 OR @FlushBlockSize>2048 OR @FlushBlockSize<=0)
BEGIN
	SET @Str = 'Invalid flush block size, please enter valid flush block size [32,64..2048]'
	GOTO PROC_ERROR
END
SET @CurFlushBlockSize = ISNULL ((SELECT FlushBlockSizeKB FROM MMRecordingFormats WHERE RecordingFormatName = @RecordingFormat),0)
IF @CurFlushBlockSize = 0
BEGIN
	SET @Str = 'Invalid recfmtname, please enter valid recfmtname...'
	GOTO PROC_ERROR
END
IF @option = 'SET'
BEGIN
	UPDATE MMRecordingFormats
	SET FlushBlockSizeKB = @FlushBlockSize
	WHERE RecordingFormatName = @RecordingFormat
	IF @@ERROR>0
	BEGIN
		SET @Str = 'Failed to update the MMRecordingFormats table'
		GOTO PROC_ERROR
	END
	SET @Str = 'Successfully updated flush block size from '+ CAST (@CurFlushBlockSize AS VARCHAR(1024))+' to '+CAST(@FlushBlockSize AS VARCHAR(1024))
	PRINT @Str
	RETURN
END
ELSE IF @option = 'VIEW'
BEGIN
	SET @Str = 'Current Flush Block Size for given recordmat is : '+ CAST(@CurFlushBlockSize AS VARCHAR(1024))
	PRINT @Str
	RETURN
END
PROC_ERROR:
	PRINT @Str
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetFlushBlockSize')
	delete from GxQscripts where name = 'QS_SetFlushBlockSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFlushBlockSize')
	delete from GXDBVersions where aliasname = 'QS_SetFlushBlockSize'
GO

insert into GXDBVersions values(2, 'QS_SetFlushBlockSize',  '00010005001400020000', 'QS_SetFlushBlockSize', '00010005001400020000')
GO

insert into GxQscripts values(2,'QS_SetFlushBlockSize',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '--    qoperation execscript -sn QS_SetFlushBlockSize -si <SET\VIEW> -si <Recording format name> -si <New flush block size>'
 + CHAR(10) + '--    RecordingFormat: Recording format name, FlushBlockSize: New flush block size'
)
GO

