

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetFirewallConfigOnClient.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_SetFirewallConfigOnClient()
--  | Description:  Set 'Firewall Config' based on client or clientgroupName
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetFirewallConfigOnClient.sp,v $ $Id: QS_SetFirewallConfigOnClient.sp,v 1.1.10.2 2019/07/23 17:31:08 pwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetFirewallConfigOnClient')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetFirewallConfigOnClient <<<'
	drop procedure QS_SetFirewallConfigOnClient
END
IF EXISTS (select * from GxQscripts where name='QS_SetFirewallConfigOnClient')
	delete from GxQscripts where name = 'QS_SetFirewallConfigOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFirewallConfigOnClient')
	delete from GXDBVersions where aliasname = 'QS_SetFirewallConfigOnClient'
GO
print '... Creating Procedure: QS_SetFirewallConfigOnClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetFirewallConfigOnClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @param1 NVARCHAR(100)
AS
SET NOCOUNT ON
DECLARE @errorCode				INTEGER
DECLARE @errorString			NVARCHAR(1024)
DECLARE @canManage				INT
DECLARE @clientName             NVARCHAR(256)
DECLARE @clientgroupName		NVARCHAR(512)
DECLARE @ClientId				INT
DECLARE @clientgroupId			INT
SET @ClientId = 0
SET @clientgroupId = 0
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
	--INSERT/UPDATE Operation
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'Successful'
        -- USER VALIDATION
		--Existence of table and fetching of top 1 userId is done for safety measures
		IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		DECLARE @userId INT
		SET @userId = 0
		SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
		IF @userId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		--Input validation and assignation--
		--1. Null and empty check
		IF (@param1 = '') OR (@param1 NOT LIKE 'c=%')
		BEGIN
			IF (@param1 = '') OR (@param1 NOT LIKE 'cg=%')
			BEGIN
				SET @ErrorCode = 2
				SET @ErrorString = 'Error. Input param must be client name specified as c=clientName or clientgroup name specified as cg=clientgroupName'
				GOTO SCRIPT_EXIT
			END
			ELSE
			BEGIN
				SET @clientgroupName = SUBSTRING(@param1,LEN('cg=')+1,LEN(@param1)-LEN('cg='))
				SET @ClientgroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = @clientgroupName),0)
				IF @ClientgroupId = 0
				BEGIN
					SET @ErrorCode = 3
					SET @ErrorString = 'Error. Invalid clientgroup[' + @clientgroupName + '] specified.'
					GOTO SCRIPT_EXIT
				END
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManage OUTPUT, 28, @clientgroupId
				IF @canManage <> 1
				BEGIN
					set @errorCode = 4
					set @errorString = 'Logged in user does not have rights to set property for clientgroup'
					GOTO SCRIPT_EXIT
				END
				MERGE App_clientProp TGT
				USING App_clientGroupAssoc SRC
				ON (SRC.clientId = TGT.componentNameId
				AND TGT.attrName = 'Include in Firewall Config' AND TGT.modified = 0
				AND SRC.clientGroupId = @clientgroupId)
				WHEN MATCHED THEN
				UPDATE SET attrVal = '1'
				WHEN NOT MATCHED BY TARGET AND SRC.clientGroupId = @clientgroupId THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (SRC.clientId, 'Include in Firewall Config', 7, '1', @nowTime, 0);
			END
		END
		ELSE
		BEGIN
			SET @clientName = SUBSTRING(@param1,LEN('c=')+1,LEN(@param1)-LEN('c='))
			SET @ClientId = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName),0)
			IF @ClientId = 0
			BEGIN
				SET @ErrorCode = 5
				SET @ErrorString = 'Error. Invalid client[' + @clientName + '] specified.'
				GOTO SCRIPT_EXIT
			END
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManage OUTPUT, 3, @clientId
			IF @canManage <> 1
			BEGIN
				set @errorCode = 6
				set @errorString = 'Logged in user does not have rights to set property for client.'
				GOTO SCRIPT_EXIT
			END
			UPDATE App_clientProp SET attrVal = '1' WHERE attrName = 'Include in Firewall Config' AND componentNameId=@clientId AND modified = 0
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO App_clientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@clientId, 'Include in Firewall Config', 7, '1', @nowTime, 0)
			END
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
PRINT ' completed at '
            + Convert(varchar(60), getdate())
            + ' with Parameters: ['+@param1+']. Execution('+ @errorString +').'
IF @errorCode <> 0
BEGIN
  RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetFirewallConfigOnClient')
	delete from GxQscripts where name = 'QS_SetFirewallConfigOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFirewallConfigOnClient')
	delete from GXDBVersions where aliasname = 'QS_SetFirewallConfigOnClient'
GO

insert into GXDBVersions values(2, 'QS_SetFirewallConfigOnClient',  '00010001001000020000', 'QS_SetFirewallConfigOnClient', '00010001001000020000')
GO

insert into GxQscripts values(2+8,'QS_SetFirewallConfigOnClient',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    To set ''Firewall Config'' based on client or clientgroupName  
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_SetFirewallConfigOnClient.sql -si c=clientName
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_SetFirewallConfigOnClient.sql -si cg=clientgroupName 
'
)
GO

