

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetExchangeDBIDAProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetExchangeDBIDAProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetExchangeDBIDAProp')
	drop procedure QS_SetExchangeDBIDAProp
IF EXISTS (select * from GxQscripts where name='QS_SetExchangeDBIDAProp')
	delete from GxQscripts where name = 'QS_SetExchangeDBIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetExchangeDBIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetExchangeDBIDAProp'
GO
print '... Creating Procedure: QS_SetExchangeDBIDAProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetExchangeDBIDAProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @clientName AS NVARCHAR(MAX) = '',
  @userName AS NVARCHAR(MAX) = '',
  @password AS NVARCHAR(MAX) = '',
  @backupType AS NVARCHAR(MAX) = '',
  @useVss AS NVARCHAR(MAX) = '',
  @backupFromReplica AS NVARCHAR(MAX) = '',
  @backupOnActiveNode AS NVARCHAR(MAX) = '',
  @serverName AS NVARCHAR(MAX) = '',
  @copyBackup AS NVARCHAR(MAX) = ''
AS
DECLARE @errorcode		AS	INT = 0
DECLARE @errorstring	AS	NVARCHAR(MAX) = 'Successful'
DECLARE @TRUE			AS	INT = 1
DECLARE @FALSE			AS	INT = 0
DECLARE @clientId		AS	INT = 0
DECLARE @idaId			AS	INT = 0
DECLARE @subclientId	AS	INT = 0
DECLARE @instanceId		AS	INT = 0
DECLARE @ibackupType		AS	INT = 0
DECLARE @existingBackupType	AS INT = 0
DECLARE @iuseVSS			AS	INT = 0
DECLARE	@iBackupFromReplica	AS INT = 0
DECLARE @iBackupOnActiveNode	AS INT = 0
DECLARE @icopyBackup		AS	INT = 0
DECLARE @qs_resultTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
--Validate first parameter, client name
IF @clientName = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientName), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name[' + @clientName + '] not correct. Please give valid client name.'
			SET		@errorcode = 2
			GOTO	ARGS_ERROR
		END
		SET @idaId = ISNULL((SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = 53), 0)
		IF @idaId = 0
		BEGIN
			SET		@errorstring = 'Error: Exchange IDA is not installed on client [' + @clientName + '].'
			SET		@errorcode = 3
			GOTO	ARGS_ERROR
		END
		SET @subclientId = ISNULL((SELECT id from APP_Application WHERE clientId = @clientId AND appTypeId = 53 AND subclientName = 'default' AND (subclientStatus & 0x8) = 0x8), 0)
		SET @instanceId = ISNULL((SELECT instance from APP_Application WHERE clientId = @clientId AND appTypeId = 53 AND subclientName = 'default' AND (subclientStatus & 0x8) = 0x8), 0)
	END
--Validate second parameter, user name
IF @userName = ''
BEGIN
	SET @errorcode = 4
	SET @errorstring = 'Error: Second parameter user name is empty, please give user name.'
	GOTO ARGS_ERROR
END
--Validate third parameter, password
IF @password = ''
	BEGIN
		SET @errorcode = 5
		SET @errorstring = 'Error: Third parameter password is empty, please give password.'
		GOTO ARGS_ERROR
	END
--ELSE
--	BEGIN
--		IF SUBSTRING (@password, 1, 1) != '2'
--		BEGIN
--			SET @errorcode = 6
--			SET @errorstring = 'Error: Third parameter password is not in p2 format, please give thrid parameters as -p2 <password>.'
--			GOTO ARGS_ERROR
--		END
--	END
--Validate fourth parameter, Backup Type
IF @backupType = ''
	BEGIN
		SET @errorcode = 7
		SET @errorstring = 'Error: Fourth parameter backup type is empty, it must be(Incremental / Differential) .'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupType = 'Incremental'
			SET @ibackupType = 2
		ELSE IF @backupType = 'Differential'
			SET @ibackupType = 4
		ELSE
			BEGIN
				SET @errorcode = 8
				SET @errorstring = 'Error: Fourth parameter is [' + @backupType + '], it must be (Incremental / Differential) .'
				GOTO ARGS_ERROR
			END
	END
--Validate fifth parameter, Use Vss
IF @useVss = ''
	BEGIN
		SET @errorcode = 9
		SET @errorstring = 'Error: Fifth parameter Use Vss is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @useVss = 'true'
			SET @iuseVSS = @TRUE
		ELSE IF @useVss = 'false'
			SET @iuseVSS = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 10
				SET @errorstring = 'Error: Fifth parameter Use Vss is [' + @useVss + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
	END
--Validate sixth parameter, BackupFromReplica
IF @backupFromReplica = ''
	BEGIN
		SET @errorcode = 11
		SET @errorstring = 'Error: Sixth parameter BackupFromReplica is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupFromReplica = 'true'
			SET @iBackupFromReplica = @TRUE
		ELSE IF @backupFromReplica = 'false'
			SET @iBackupFromReplica = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 12
				SET @errorstring = 'Error: Sixth parameter BackupFromReplica is [' + @backupFromReplica + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
		IF @iuseVSS = @FALSE AND @iBackupFromReplica = @TRUE
		BEGIN
			SET @errorcode = 13
			SET @errorstring = 'Error: Fifth parameter UseVss is false, so sixth parameter BackupFromReplica should be false'
			GOTO ARGS_ERROR
		END
	END
--Validate seventh parameter, BackupOnActiveNode
IF @backupOnActiveNode = ''
	BEGIN
		SET @errorcode = 14
		SET @errorstring = 'Error: Seventh parameter BackupOnActiveNode is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupOnActiveNode = 'true'
			SET @iBackupOnActiveNode = @TRUE
		ELSE IF @backupOnActiveNode = 'false'
			SET @iBackupOnActiveNode = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 15
				SET @errorstring = 'Error: Seventh parameter BackupOnActiveNode is [' + @backupOnActiveNode + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
		IF ( @iuseVSS = @FALSE OR @iBackupFromReplica = @FALSE ) AND @iBackupOnActiveNode = @TRUE
		BEGIN
			SET @errorcode = 16
			SET @errorstring = 'Error: Fifth parameter UseVss is ' + @useVss + ' and sixth parameter BackupFromReplica is ' + @backupFromReplica + ', so seventh parameter BackupOnActiveNode should be false. BackupOnActiveNode can be true if both UseVss and BackupFromReplica are true.'
			GOTO ARGS_ERROR
		END
	END
--Validate eigth parameter, ServerName
IF @serverName = ''
	BEGIN
		SET @errorcode = 17
		SET @errorstring = 'Error: Eigth parameter ServerName is empty, please give valid server name.'
		GOTO ARGS_ERROR
	END
--Validate ninth parameter, Copy Backup
IF @copyBackup = ''
	BEGIN
		SET @errorcode = 18
		SET @errorstring = 'Error: Ninth parameter copy Backup is empty, it should be (true/false).'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @copyBackup = 'true'
			SET @icopyBackup = @TRUE
		ELSE IF @copyBackup = 'false'
			SET @icopyBackup = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 19
				SET @errorstring = 'Error: Nineth parameter Copy Backup is [' + @copyBackup + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
	END
-----------------------------------------------
--Validation done, add User Name and Password--
-----------------------------------------------
BEGIN TRAN
BEGIN TRY
	--Set Server Name-------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'Server Name', 1, @serverName
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set User Name----------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'User Name', 1, @userName
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Password-----------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'User Password', 1, @password
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Use Vss------------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Use Snapshot Writer', 2, @iuseVSS
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set backup from replica------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Backup From Replica', 2, @iBackupFromReplica
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set backup on active node----------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Continue Backups From Replica After Failover', 2, @iBackupOnActiveNode
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Copy Backup--------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Copy Backup Enabled', 2, @icopyBackup
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Backup Level-------------------------------------------------------------------------------------------------
	SET @existingBackupType = ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId  = @subclientId AND attrName = 'Backup Level' AND modified = 0), 0)
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 1, 0, 'Backup Level', 7, @ibackupType
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	IF @existingBackupType != @ibackupType
	BEGIN
		--Force next backup to full------------------------------------------------------------------------------------
		INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 0, 0, 'turbo:last incr', 8, 0
		SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
		IF @errorcode <> 0
		BEGIN
			SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
			GOTO SKIP
		END
		DELETE FROM @qs_resultTbl;
		---------------------------------------------------------------------------------------------------------------
		--Force next backup to full------------------------------------------------------------------------------------
		INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 0, 0, 'turbo:last full', 8, 0
		SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
		IF @errorcode <> 0
		BEGIN
			SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
			GOTO SKIP
		END
		DELETE FROM @qs_resultTbl;
		---------------------------------------------------------------------------------------------------------------
	END
	print 'Successfully set properties.'
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetExchangeDBIDAProp')
	delete from GxQscripts where name = 'QS_SetExchangeDBIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetExchangeDBIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetExchangeDBIDAProp'
GO

insert into GXDBVersions values(2, 'QS_SetExchangeDBIDAProp',  '00000000000000000000', 'QS_SetExchangeDBIDAProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetExchangeDBIDAProp',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetExchangeDBIDAProp -si @clientName=''Client Name'' -si @userName=''User Name'' -p2 @password=''Password'' -si @backupType=''Incremental'' -si @useVss=''true'' -si @backupFromReplica=''true'' -si @backupOnActiveNode=''true'' -si @serverName=''Server Name'' -si @copyBackup=''true''
'
 + CHAR(10) + '	Where 	ClientName		would be client name.
'
 + CHAR(10) + '			UserName		User name to be set for IDA
'
 + CHAR(10) + '			Password		Password to be set for IDA.
'
 + CHAR(10) + '			BackupType		Incremental / Differential
'
 + CHAR(10) + '			UseVss			true / false
'
 + CHAR(10) + '			BackupFromReplica	true / false
'
 + CHAR(10) + '			BackupOnActiveNode	true / false
'
 + CHAR(10) + '			ServerName		Name of exchange server
'
 + CHAR(10) + '			CopyBackup		true / false
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn SetExchangeDBIDAProp -si @clientName=''Client Name'' -si @userName=''admin'' -p2 @password=''Password'' -si @backupType=''Incremental'' -si @useVss=''true'' -si @backupFromReplica=''true'' -si @backupOnActiveNode=''true'' -si @serverName=''E12SP3'' -si @copyBackup=''true''
'
 + CHAR(10) + '-- 	script_name: SetExchangeDBIDAProp'
 + CHAR(10) + '-- 	Set properties of ExchangeDB IDA.'
)
GO

