

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDriveProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDriveProperty <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDriveProperty')
	drop procedure QS_SetDriveProperty
IF EXISTS (select * from GxQscripts where name='QS_SetDriveProperty')
	delete from GxQscripts where name = 'QS_SetDriveProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDriveProperty')
	delete from GXDBVersions where aliasname = 'QS_SetDriveProperty'
GO
print '... Creating Procedure: QS_SetDriveProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetDriveProperty
-- Qscript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @TapeLibraryName VARCHAR(1024) = '%s',
  @DriveAliasName VARCHAR(1024) = '%s',
  @opType INT			  = 0
AS
Set NOCOUNT ON
DECLARE @errorString VARCHAR(1024) = 'Sucessfully Executed'
DECLARE @errorCode INT = 0
BEGIN TRANSACTION
IF NOT EXISTS (	SELECT	*
				FROM	MMLibrary
				WHERE	AliasName = @TapeLibraryName )
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error: Provide Valid Library Name
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
IF NOT EXISTS (	SELECT	*
				FROM	MMLibrary L , MMMasterPool MP , MMDrive D
				WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
					AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
					AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName )
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'Error: Provide valid Drive Name
									    Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
				END
IF NOT (@opType IN (1,2,3,4,5,6))
BEGIN
	SET @errorCode = 3
	SET @errorString = 'Error: Provide valid opType
						Please refer to the readme file and try again.'
					GOTO SCRIPT_EXIT
END
--@opType = 1 Enable Drive
--@opType = 2 Disable  Drive
--@opType = 3 Enable Mark drive offline for maintenance
--@opType = 4 Disable Mark drive offline for maintenance
--@opType = 5 Enable Mark drive as read only
--@opType = 6 Disable Mark drive as read only
IF (@opType = 1)
BEGIN
	UPDATE  D
	SET D.DriveEnabled = 1
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = 4
			SET @errorString = 'Failed to update MMDrive for enabling drive.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Enabled drive "' + @DriveAliasName + '" of "' + @TapeLibraryName +  '" tape library.'
END
ELSE IF (@opType = 2)
BEGIN
	UPDATE  D
	SET D.DriveEnabled = 0
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = 5
			SET @errorString = 'Failed to update MMDrive for disabling drive.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Disabled drive "' + @DriveAliasName + '" of "' + @TapeLibraryName +  '" tape library.'
END
ELSE IF (@opType = 3)
BEGIN
	UPDATE  D
SET D.Attributes = D.Attributes | 256
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = 6
			SET @errorString = 'Failed to update MMDrive for marking drive offline for maintenance.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Marked drive "' + @DriveAliasName + '" offline for maintenance from "' + @TapeLibraryName +  '" tape library.'
END
ELSE IF (@opType = 4)
BEGIN
	UPDATE  D
SET D.Attributes = D.Attributes &~ 256
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = 7
			SET @errorString = 'Failed to update MMDrive for disabling marking drive for maintenance.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Disabled marking drive "' + @DriveAliasName + '" offline for maintenance from "' + @TapeLibraryName +  '" tape library.'
END
ELSE IF (@opType = 5)
BEGIN
	UPDATE  D
SET D.Attributes = D.Attributes | 128
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = 8
			SET @errorString = 'Failed to update MMDrive for marking drive as read only.'
			GOTO SCRIPT_EXIT
		END
	SELECT 'Mark drive "' + @DriveAliasName + '" as read only from "' + @TapeLibraryName +  '" tape library.'
END
ELSE IF (@opType = 6)
BEGIN
	UPDATE  D
SET D.Attributes = D.Attributes &~ 128
	FROM	MMLibrary L , MMMasterPool MP , MMDrive D
	WHERE	L.LibraryId = MP.LibraryId AND L.origCCId = MP.origCCId
		AND D.MasterPoolId = MP.MasterPoolId AND D.origCCId = MP.origCCId
		AND	L.AliasName = @TapeLibraryName	AND D.AliasName = @DriveAliasName
	IF (@@ERROR > 0)
	BEGIN
		SET @errorString = 'Failed to update MMDrive for Disabling marking drive as read only.'
		SET @errorCode = 9
		GOTO SCRIPT_EXIT
	END
	SELECT 'Disabled marking drive "' + @DriveAliasName + '" as read only from "' + @TapeLibraryName +  '" tape library.'
END
COMMIT TRANSACTION
SCRIPT_EXIT:
	IF(@errorCode <> 0)
		BEGIN
			ROLLBACK TRAN
			RAISERROR(@errorString,16,1)
		END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDriveProperty')
	delete from GxQscripts where name = 'QS_SetDriveProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDriveProperty')
	delete from GXDBVersions where aliasname = 'QS_SetDriveProperty'
GO

insert into GXDBVersions values(2, 'QS_SetDriveProperty',  '00000000000000000000', 'QS_SetDriveProperty', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDriveProperty',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' Generic script for setting drive properties 
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + ' To enable drive.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''1'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To disable drive.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''2'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To Mark drive offline for maintenance.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''3'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To disable marking the drive offline for maintenance.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''4'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To mark drive as read only.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''5'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To disable marking drive as read only.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_SetDriveProperty -si @opType = ''6'' -si @TapeLibraryName=''Name of the library'' -si @DriveAliasName = ''Drive Alias Name'''
 + CHAR(10) + '
'
)
GO

